/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.window;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.ScreenDockWindowBorder;
import bibliothek.gui.dock.station.screen.window.ScreenDockWindowBorderFactory;
import bibliothek.gui.dock.station.screen.window.ScreenDockWindowColor;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;

public class DefaultScreenDockWindowBorder
implements ScreenDockWindowBorder {
    public static final ScreenDockWindowBorderFactory FACTORY = new ScreenDockWindowBorderFactory(){

        @Override
        public ScreenDockWindowBorder create(ScreenDockWindow window, JComponent owner) {
            return new DefaultScreenDockWindowBorder(window, owner);
        }
    };
    private int cornerSize = 0;
    private int moveSize = 0;
    private boolean moveable = false;
    private boolean resizeable = false;
    private ScreenDockWindowBorder.Position mouseOver = ScreenDockWindowBorder.Position.NOTHING;
    private ScreenDockWindowBorder.Position mousePressed = ScreenDockWindowBorder.Position.NOTHING;
    private boolean drawDividers = true;
    private JComponent target;
    private ScreenDockWindow window;
    private DockController controller;
    private boolean moveOnlyOnSameSideAsTitle = true;
    protected final BorderColor colorLine = new BorderColor("line");
    protected final BorderColor colorLineHighlightInner = new BorderColor("line.highlight.inner");
    protected final BorderColor colorLineHighlightOuter = new BorderColor("line.highlight.outer");
    protected final BorderColor colorLineShadowInner = new BorderColor("line.shadow.inner");
    protected final BorderColor colorLineShadowOuter = new BorderColor("line.shadow.outer");
    protected final BorderColor color = new BorderColor();
    protected final BorderColor colorHighlightInner = new BorderColor("highlight.inner");
    protected final BorderColor colorHighlightOuter = new BorderColor("highlight.outer");
    protected final BorderColor colorShadowInner = new BorderColor("shadow.inner");
    protected final BorderColor colorShadowOuter = new BorderColor("shadow.outer");
    protected final BorderColor colorHover = new BorderColor("hover");
    protected final BorderColor colorHighlightInnerHover = new BorderColor("highlight.inner.hover");
    protected final BorderColor colorHighlightOuterHover = new BorderColor("highlight.outer.hover");
    protected final BorderColor colorShadowInnerHover = new BorderColor("shadow.inner.hover");
    protected final BorderColor colorShadowOuterHover = new BorderColor("shadow.outer.hover");
    protected final BorderColor colorSelected = new BorderColor("selected");
    protected final BorderColor colorHighlightInnerSelected = new BorderColor("highlight.inner.selected");
    protected final BorderColor colorHighlightOuterSelected = new BorderColor("highlight.outer.selected");
    protected final BorderColor colorShadowInnerSelected = new BorderColor("shadow.inner.selected");
    protected final BorderColor colorShadowOuterSelected = new BorderColor("shadow.outer.selected");
    private BorderColor[] colors;

    public DefaultScreenDockWindowBorder(ScreenDockWindow window, JComponent target) {
        if (window == null) {
            throw new IllegalArgumentException("window must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        this.window = window;
        this.target = target;
        this.colors = new BorderColor[]{this.colorLine, this.colorLineHighlightInner, this.colorLineHighlightOuter, this.colorLineShadowInner, this.colorLineShadowOuter, this.color, this.colorHighlightInner, this.colorHighlightOuter, this.colorShadowInner, this.colorShadowOuter, this.colorHover, this.colorHighlightInnerHover, this.colorHighlightOuterHover, this.colorShadowInnerHover, this.colorShadowOuterHover, this.colorSelected, this.colorHighlightInnerSelected, this.colorHighlightOuterSelected, this.colorShadowInnerSelected, this.colorShadowOuterSelected};
    }

    @Override
    public void setController(DockController controller) {
        this.controller = controller;
        ColorManager manager = controller == null ? null : controller.getColors();
        for (BorderColor color : this.colors) {
            color.setManager(manager);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    @Override
    public void setCornerSize(int cornerSize) {
        if (this.cornerSize != cornerSize) {
            this.cornerSize = cornerSize;
            this.target.repaint();
        }
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    @Override
    public void setMoveSize(int moveSize) {
        if (this.moveSize != moveSize) {
            this.moveSize = moveSize;
            this.target.repaint();
        }
    }

    public int getMoveSize() {
        return this.moveSize;
    }

    @Override
    public void setMoveable(boolean moveable) {
        this.moveable = moveable;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    @Override
    public void setResizeable(boolean resizeable) {
        this.resizeable = resizeable;
    }

    public boolean isResizeable() {
        return this.resizeable;
    }

    public void setDrawDividers(boolean drawDividers) {
        if (this.drawDividers != drawDividers) {
            this.drawDividers = drawDividers;
            this.target.repaint();
        }
    }

    public boolean isDrawDividers() {
        return this.drawDividers;
    }

    public void setMoveOnlyOnSameSideAsTitle(boolean moveOnlyOnSameSideAsTitle) {
        this.moveOnlyOnSameSideAsTitle = moveOnlyOnSameSideAsTitle;
    }

    public boolean isMoveOnlyOnSameSideAsTitle() {
        return this.moveOnlyOnSameSideAsTitle;
    }

    @Override
    public void setMouseOver(ScreenDockWindowBorder.Position mouseOver) {
        if (mouseOver == null) {
            mouseOver = ScreenDockWindowBorder.Position.NOTHING;
        }
        if (this.mouseOver != mouseOver) {
            this.mouseOver = mouseOver;
            this.target.repaint();
        }
    }

    @Override
    public void setMousePressed(ScreenDockWindowBorder.Position mousePressed) {
        if (mousePressed == null) {
            mousePressed = ScreenDockWindowBorder.Position.NOTHING;
        }
        if (this.mousePressed != mousePressed) {
            this.mousePressed = mousePressed;
            this.target.repaint();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.isResizeable()) {
            return new Insets(5, 4, 4, 4);
        }
        if (this.moveOnlyOnSameSideAsTitle) {
            DockableDisplayer.Location titleLocation = null;
            DockableDisplayer displayer = this.window.getDockableDisplayer();
            if (displayer != null) {
                titleLocation = displayer.getTitleLocation();
            }
            if (titleLocation == null) {
                titleLocation = DockableDisplayer.Location.TOP;
            }
            switch (titleLocation) {
                case BOTTOM: {
                    return new Insets(0, 0, 5, 0);
                }
                case TOP: {
                    return new Insets(5, 0, 0, 0);
                }
                case LEFT: {
                    return new Insets(0, 5, 0, 0);
                }
                case RIGHT: {
                    return new Insets(0, 0, 0, 5);
                }
            }
            throw new IllegalStateException("unknown location: " + (Object)((Object)titleLocation));
        }
        return new Insets(5, 0, 0, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        PaintParameters parameters = new PaintParameters(width, height, c);
        Color oldColor = g.getColor();
        g.translate(x, y);
        this.paintTop(c, g, parameters);
        if (this.isResizeable()) {
            this.paintTopLeft(c, g, parameters);
            this.paintTopRight(c, g, parameters);
            this.paintLeft(c, g, parameters);
            this.paintRight(c, g, parameters);
            this.paintBottom(c, g, parameters);
            this.paintBottomLeft(c, g, parameters);
            this.paintBottomRight(c, g, parameters);
            if (this.drawDividers) {
                this.paintDividingLines(c, g, parameters);
            }
        } else {
            this.paintMoveOnly(c, g, parameters);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    private void paintMoveOnly(Component c, Graphics g, PaintParameters p) {
        this.paintLeftMoveOnly(c, g, p);
        this.paintRightMoveOnly(c, g, p);
        this.paintBottomMoveOnly(c, g, p);
    }

    private void paintTop(Component c, Graphics g, PaintParameters p) {
        if (this.moveSize > 0 && this.isMoveable()) {
            this.paintTopWithMove(c, g, p);
        } else {
            this.paintTopWithoutMove(c, g, p);
        }
    }

    private void paintLeftMoveOnly(Component c, Graphics g, PaintParameters p) {
        Insets insets = p.insets;
        if (insets.left > 0) {
            if (insets.left > 2) {
                g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.MOVE));
                g.fillRect(0, 0, insets.left, p.height);
            }
            g.setColor(this.getColor(c, false, false, ScreenDockWindowBorder.Position.MOVE));
            g.drawLine(insets.left - 2, 0, insets.left - 2, p.height);
            g.setColor(this.getColor(c, true, false, ScreenDockWindowBorder.Position.MOVE));
            g.drawLine(insets.left - 1, 0, insets.left - 1, p.height);
        }
    }

    private void paintRightMoveOnly(Component c, Graphics g, PaintParameters p) {
        Insets insets = p.insets;
        if (insets.right > 0) {
            int width = p.width;
            int height = p.height;
            if (insets.right > 2) {
                g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.MOVE));
                g.fillRect(width - insets.right + 2, 0, insets.right - 2, height);
            }
            g.setColor(this.getColor(c, false, true, ScreenDockWindowBorder.Position.MOVE));
            g.drawLine(width - insets.right + 1, 0, width - insets.right + 1, height - 1);
            g.setColor(this.getColor(c, true, true, ScreenDockWindowBorder.Position.MOVE));
            g.drawLine(width - insets.right, 0, width - insets.right, height - 1);
        }
    }

    private void paintBottomMoveOnly(Component c, Graphics g, PaintParameters p) {
        Insets insets = p.insets;
        if (insets.bottom > 0) {
            int width = p.width;
            int height = p.height;
            if (insets.bottom > 2) {
                g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.MOVE));
                g.fillRect(0, height - insets.bottom + 2, width, insets.bottom - 2);
            }
            g.setColor(this.getColor(c, true, true, ScreenDockWindowBorder.Position.MOVE));
            g.drawLine(0, height - insets.bottom, width - 1, height - insets.bottom);
            g.setColor(this.getColor(c, false, true, ScreenDockWindowBorder.Position.MOVE));
            g.drawLine(0, height - insets.bottom + 1, width - 1, height - insets.bottom + 1);
        }
    }

    private void paintTopWithMove(Component c, Graphics g, PaintParameters p) {
        int width = p.width;
        int corner = p.corner;
        Insets insets = p.insets;
        int titleLeft = p.titleLeft;
        int titleRight = p.titleRight;
        if (!this.isResizeable()) {
            titleLeft = 0;
            titleRight = width;
        }
        if (insets.top > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.MOVE));
            g.fillRect(titleLeft, 0, titleRight - titleLeft, insets.top - 2);
        }
        g.setColor(this.getColor(c, false, false, ScreenDockWindowBorder.Position.MOVE));
        g.drawLine(titleLeft, insets.top - 2, titleRight - 1, insets.top - 2);
        g.setColor(this.getColor(c, true, false, ScreenDockWindowBorder.Position.MOVE));
        g.drawLine(titleLeft, insets.top - 1, titleRight - 1, insets.top - 1);
        if (this.isResizeable()) {
            if (insets.top > 2) {
                g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.N));
                g.fillRect(corner, 0, titleLeft - corner, insets.top - 2);
                g.fillRect(titleRight, 0, width - corner - titleRight, insets.top - 2);
            }
            g.setColor(this.getColor(c, false, false, ScreenDockWindowBorder.Position.N));
            g.drawLine(corner, insets.top - 2, titleLeft - 1, insets.top - 2);
            g.drawLine(titleRight, insets.top - 2, width - corner - 1, insets.top - 2);
            g.setColor(this.getColor(c, true, false, ScreenDockWindowBorder.Position.N));
            g.drawLine(corner, insets.top - 1, titleLeft - 1, insets.top - 1);
            g.drawLine(titleRight, insets.top - 1, width - corner - 1, insets.top - 1);
        }
    }

    private void paintTopWithoutMove(Component c, Graphics g, PaintParameters p) {
        int width = p.width;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.bottom > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.N));
            g.fillRect(corner, 0, width - 2 * corner, insets.top - 2);
        }
        g.setColor(this.getColor(c, false, false, ScreenDockWindowBorder.Position.N));
        g.drawLine(corner, insets.top - 2, width - corner - 1, insets.top - 2);
        g.setColor(this.getColor(c, true, false, ScreenDockWindowBorder.Position.N));
        g.drawLine(corner, insets.top - 1, width - corner - 1, insets.top - 1);
    }

    private void paintTopLeft(Component c, Graphics g, PaintParameters p) {
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.top > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.NW));
            g.fillRect(0, 0, corner, insets.top - 2);
        }
        if (insets.left > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.NW));
            g.fillRect(0, 0, insets.left - 2, corner);
        }
        g.setColor(this.getColor(c, false, false, ScreenDockWindowBorder.Position.NW));
        g.drawLine(insets.left - 2, insets.top - 2, corner - 1, insets.top - 2);
        g.drawLine(insets.left - 2, insets.top - 2, insets.left - 2, corner - 1);
        g.setColor(this.getColor(c, true, false, ScreenDockWindowBorder.Position.NW));
        g.drawLine(insets.left - 1, insets.top - 1, corner - 1, insets.top - 1);
        g.drawLine(insets.left - 1, insets.top - 1, insets.left - 1, corner - 1);
    }

    private void paintTopRight(Component c, Graphics g, PaintParameters p) {
        int width = p.width;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.top > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.NE));
            g.fillRect(width - corner, 0, corner, insets.top - 2);
        }
        if (insets.right > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.NE));
            g.fillRect(width - insets.right + 2, 0, insets.right - 2, corner);
        }
        g.setColor(this.getColor(c, false, false, ScreenDockWindowBorder.Position.NE));
        g.drawLine(width - corner, insets.top - 2, width - insets.right, insets.top - 2);
        g.setColor(this.getColor(c, false, true, ScreenDockWindowBorder.Position.NE));
        g.drawLine(width - insets.right + 1, insets.top - 2, width - insets.right + 1, corner - 1);
        g.setColor(this.getColor(c, true, false, ScreenDockWindowBorder.Position.NE));
        g.drawLine(width - corner, insets.top - 1, width - insets.right - 1, insets.top - 1);
        g.setColor(this.getColor(c, true, true, ScreenDockWindowBorder.Position.NE));
        g.drawLine(width - insets.right, insets.top - 1, width - insets.right, corner - 1);
    }

    private void paintLeft(Component c, Graphics g, PaintParameters p) {
        int height = p.height;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.left > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.W));
            g.fillRect(0, corner, insets.left - 2, height - 2 * corner);
        }
        g.setColor(this.getColor(c, false, false, ScreenDockWindowBorder.Position.W));
        g.drawLine(insets.left - 2, corner, insets.left - 2, height - corner - 1);
        g.setColor(this.getColor(c, true, false, ScreenDockWindowBorder.Position.W));
        g.drawLine(insets.left - 1, corner, insets.left - 1, height - corner - 1);
    }

    private void paintRight(Component c, Graphics g, PaintParameters p) {
        int width = p.width;
        int height = p.height;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.right > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.E));
            g.fillRect(width - insets.right + 2, corner, insets.right - 2, height - 2 * corner);
        }
        g.setColor(this.getColor(c, false, true, ScreenDockWindowBorder.Position.E));
        g.drawLine(width - insets.right + 1, corner, width - insets.right + 1, height - corner - 1);
        g.setColor(this.getColor(c, true, true, ScreenDockWindowBorder.Position.E));
        g.drawLine(width - insets.right, corner, width - insets.right, height - corner - 1);
    }

    private void paintBottom(Component c, Graphics g, PaintParameters p) {
        int width = p.width;
        int height = p.height;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.bottom > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.S));
            g.fillRect(corner, height - insets.bottom + 2, width - 2 * corner, insets.bottom - 2);
        }
        g.setColor(this.getColor(c, true, true, ScreenDockWindowBorder.Position.S));
        g.drawLine(corner, height - insets.bottom, width - corner - 1, height - insets.bottom);
        g.setColor(this.getColor(c, false, true, ScreenDockWindowBorder.Position.S));
        g.drawLine(corner, height - insets.bottom + 1, width - corner - 1, height - insets.bottom + 1);
    }

    private void paintBottomLeft(Component c, Graphics g, PaintParameters p) {
        int height = p.height;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.left > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.SW));
            g.fillRect(0, height - corner, insets.left - 2, corner);
        }
        if (insets.bottom > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.SW));
            g.fillRect(0, height - insets.bottom + 2, corner, insets.bottom - 2);
        }
        g.setColor(this.getColor(c, false, false, ScreenDockWindowBorder.Position.SW));
        g.drawLine(insets.left - 2, height - corner, insets.left - 2, height - insets.bottom);
        g.setColor(this.getColor(c, true, false, ScreenDockWindowBorder.Position.SW));
        g.drawLine(insets.left - 1, height - corner, insets.left - 1, height - insets.bottom - 1);
        g.setColor(this.getColor(c, true, true, ScreenDockWindowBorder.Position.SW));
        g.drawLine(insets.left - 1, height - insets.bottom, corner - 1, height - insets.bottom);
        g.setColor(this.getColor(c, false, true, ScreenDockWindowBorder.Position.SW));
        g.drawLine(insets.left - 2, height - insets.bottom + 1, corner - 1, height - insets.bottom + 1);
    }

    private void paintBottomRight(Component c, Graphics g, PaintParameters p) {
        int width = p.width;
        int height = p.height;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.right > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.SE));
            g.fillRect(width - insets.right + 2, height - corner, insets.right - 2, corner);
        }
        if (insets.bottom > 2) {
            g.setColor(this.getColor(c, ScreenDockWindowBorder.Position.SE));
            g.fillRect(width - corner, height - insets.bottom + 2, corner, insets.bottom - 2);
        }
        g.setColor(this.getColor(c, true, true, ScreenDockWindowBorder.Position.SE));
        g.drawLine(width - corner, height - insets.bottom, width - insets.right - 1, height - insets.bottom);
        g.drawLine(width - insets.right, height - corner, width - insets.right, height - insets.bottom);
        g.setColor(this.getColor(c, false, true, ScreenDockWindowBorder.Position.SE));
        g.drawLine(width - corner, height - insets.bottom + 1, width - insets.right, height - insets.bottom + 1);
        g.drawLine(width - insets.right + 1, height - corner, width - insets.right + 1, height - insets.bottom + 1);
    }

    private void paintDividingLines(Component c, Graphics g, PaintParameters p) {
        this.paintTopDividingLines(c, g, p);
        this.paintBottomDividingLines(c, g, p);
        this.paintLeftDividingLines(c, g, p);
        this.paintRightDividingLines(c, g, p);
    }

    private void paintTopDividingLines(Component c, Graphics g, PaintParameters p) {
        if (this.moveSize > 0) {
            this.paintTopDividingLinesWithMove(c, g, p);
        } else {
            this.paintTopDividingLinesWithoutMove(c, g, p);
        }
    }

    private void paintTopDividingLinesWithMove(Component c, Graphics g, PaintParameters p) {
        int width = p.width;
        int corner = p.corner;
        Insets insets = p.insets;
        int titleLeft = p.titleLeft;
        int titleRight = p.titleRight;
        if (insets.top > 2) {
            g.setColor(this.getLine(c));
            g.drawLine(corner, 0, corner, insets.top - 3);
            g.drawLine(titleLeft, 0, titleLeft, insets.top - 3);
            g.drawLine(titleRight - 1, 0, titleRight - 1, insets.top - 3);
            g.drawLine(width - corner - 1, 0, width - corner - 1, insets.top - 3);
        }
        g.setColor(this.getLine(c, true, false));
        g.drawLine(corner, insets.top - 1, corner, insets.top - 1);
        g.drawLine(titleLeft, insets.top - 1, titleLeft, insets.top - 1);
        g.drawLine(titleRight - 1, insets.top - 1, titleRight - 1, insets.top - 1);
        g.drawLine(width - corner - 1, insets.top - 1, width - corner - 1, insets.top - 1);
        g.setColor(this.getLine(c, false, false));
        g.drawLine(corner, insets.top - 2, corner, insets.top - 2);
        g.drawLine(titleLeft, insets.top - 2, titleLeft, insets.top - 2);
        g.drawLine(titleRight - 1, insets.top - 21, titleRight - 1, insets.top - 2);
        g.drawLine(width - corner - 1, insets.top - 2, width - corner - 1, insets.top - 2);
    }

    private void paintTopDividingLinesWithoutMove(Component c, Graphics g, PaintParameters p) {
        int width = p.width;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.top > 2) {
            g.setColor(this.getLine(c));
            g.drawLine(corner, 0, corner, insets.top - 3);
            g.drawLine(width - corner - 1, 0, width - corner - 1, insets.top - 3);
        }
        g.setColor(this.getLine(c, true, false));
        g.drawLine(corner, insets.top - 1, corner, insets.top - 1);
        g.drawLine(width - corner - 1, insets.top - 1, width - corner - 1, insets.top - 1);
        g.setColor(this.getLine(c, false, false));
        g.drawLine(corner, insets.top - 2, corner, insets.top - 2);
        g.drawLine(width - corner - 1, insets.top - 2, width - corner - 1, insets.top - 2);
    }

    private void paintBottomDividingLines(Component c, Graphics g, PaintParameters p) {
        int width = p.width;
        int height = p.height;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.bottom > 2) {
            g.setColor(this.getLine(c));
            g.drawLine(corner, height - insets.bottom + 2, corner, height - 1);
            g.drawLine(width - corner - 1, height - insets.bottom + 2, width - corner - 1, height - 1);
        }
        g.setColor(this.getLine(c, true, false));
        g.drawLine(corner, height - insets.bottom, corner, height - insets.bottom);
        g.drawLine(width - corner - 1, height - insets.bottom, width - corner - 1, height - insets.bottom);
        g.setColor(this.getLine(c, false, false));
        g.drawLine(corner, height - insets.bottom + 1, corner, height - insets.bottom + 1);
        g.drawLine(width - corner - 1, height - insets.bottom + 1, width - corner - 1, height - insets.bottom + 1);
    }

    private void paintLeftDividingLines(Component c, Graphics g, PaintParameters p) {
        int height = p.height;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.left > 2) {
            g.setColor(this.getLine(c));
            g.drawLine(0, corner, insets.left - 3, corner);
            g.drawLine(0, height - corner - 1, insets.left - 3, height - corner - 1);
        }
        g.setColor(this.getLine(c, true, false));
        g.drawLine(insets.left - 1, corner, insets.left - 1, corner);
        g.drawLine(insets.left - 1, height - corner - 1, insets.left - 1, height - corner - 1);
        g.setColor(this.getLine(c, false, false));
        g.drawLine(insets.left - 2, corner, insets.left - 2, corner);
        g.drawLine(insets.left - 2, height - corner - 1, insets.left - 2, height - corner - 1);
    }

    private void paintRightDividingLines(Component c, Graphics g, PaintParameters p) {
        int width = p.width;
        int height = p.height;
        int corner = p.corner;
        Insets insets = p.insets;
        if (insets.right > 2) {
            g.setColor(this.getLine(c));
            g.drawLine(width - insets.right + 2, corner, width - 1, corner);
            g.drawLine(width - insets.right + 2, height - corner - 1, width - 1, height - corner - 1);
        }
        g.setColor(this.getLine(c, true, false));
        g.drawLine(width - insets.right, corner, width - insets.right, corner);
        g.drawLine(width - insets.right, height - corner - 1, width - insets.right, height - corner - 1);
        g.setColor(this.getLine(c, false, false));
        g.drawLine(width - insets.right + 1, corner, width - insets.right + 1, corner);
        g.drawLine(width - insets.right + 1, height - corner - 1, width - insets.right + 1, height - corner - 1);
    }

    protected Color getLine(Component c) {
        Color color = (Color)this.colorLine.value();
        if (color == null) {
            return c.getForeground();
        }
        return color;
    }

    protected Color getLine(Component c, boolean inner, boolean shadow) {
        Color color = inner && shadow ? (Color)this.colorLineShadowInner.value() : (inner && !shadow ? (Color)this.colorLineHighlightInner.value() : (!inner && shadow ? (Color)this.colorLineShadowOuter.value() : (Color)this.colorLineHighlightOuter.value()));
        if (color != null) {
            return color;
        }
        return this.defaultModify(this.getLine(c), inner, shadow);
    }

    private Color getColor(Component c, ScreenDockWindowBorder.Position position) {
        if (position == this.mousePressed) {
            return this.getSelectedColor(c);
        }
        if (position == this.mouseOver) {
            return this.getHoverColor(c);
        }
        return this.getNormalColor(c);
    }

    private Color getColor(Component c, boolean inner, boolean shadow, ScreenDockWindowBorder.Position position) {
        if (position == this.mousePressed) {
            return this.getSelectedColor(c, inner, shadow);
        }
        if (position == this.mouseOver) {
            return this.getHoverColor(c, inner, shadow);
        }
        return this.getNormalColor(c, inner, shadow);
    }

    protected Color getHoverColor(Component c) {
        Color color = (Color)this.colorHover.value();
        if (color == null) {
            return Color.YELLOW;
        }
        return color;
    }

    protected Color getHoverColor(Component c, boolean inner, boolean shadow) {
        Color color = inner && shadow ? (Color)this.colorShadowInnerHover.value() : (inner && !shadow ? (Color)this.colorHighlightInnerHover.value() : (!inner && shadow ? (Color)this.colorShadowOuterHover.value() : (Color)this.colorHighlightOuterHover.value()));
        if (color != null) {
            return color;
        }
        return this.defaultModify(this.getHoverColor(c), inner, shadow);
    }

    protected Color getSelectedColor(Component c) {
        Color color = (Color)this.colorSelected.value();
        if (color == null) {
            return Color.RED;
        }
        return color;
    }

    protected Color getSelectedColor(Component c, boolean inner, boolean shadow) {
        Color color = inner && shadow ? (Color)this.colorShadowInnerSelected.value() : (inner && !shadow ? (Color)this.colorHighlightInnerSelected.value() : (!inner && shadow ? (Color)this.colorShadowOuterSelected.value() : (Color)this.colorHighlightOuterSelected.value()));
        if (color != null) {
            return color;
        }
        return this.defaultModify(this.getSelectedColor(c), inner, shadow);
    }

    protected Color getNormalColor(Component c) {
        Color color = (Color)this.color.value();
        if (color == null) {
            return c.getBackground();
        }
        return color;
    }

    protected Color getNormalColor(Component c, boolean inner, boolean shadow) {
        Color color = inner && shadow ? (Color)this.colorShadowInner.value() : (inner && !shadow ? (Color)this.colorHighlightInner.value() : (!inner && shadow ? (Color)this.colorShadowOuter.value() : (Color)this.colorHighlightOuter.value()));
        if (color != null) {
            return color;
        }
        return this.defaultModify(this.getNormalColor(c), inner, shadow);
    }

    protected Color defaultModify(Color color, boolean inner, boolean shadow) {
        if (inner && shadow) {
            return Colors.darker(color, 0.2);
        }
        if (!inner && shadow) {
            return Colors.darker(color, 0.4);
        }
        if (inner && !shadow) {
            return Colors.brighter(color, 0.2);
        }
        return Colors.brighter(color, 0.4);
    }

    protected class BorderColor
    extends AbstractDockColor
    implements ScreenDockWindowColor {
        public BorderColor(String id) {
            super("station.screen.border." + id, KIND_SCREEN_WINDOW_COLOR);
        }

        public BorderColor() {
            super("station.screen.border", KIND_SCREEN_WINDOW_COLOR);
        }

        @Override
        protected void changed(Color oldValue, Color newValue) {
            DefaultScreenDockWindowBorder.this.target.repaint();
        }

        @Override
        public ScreenDockWindow getWindow() {
            return DefaultScreenDockWindowBorder.this.window;
        }
    }

    private class PaintParameters {
        public final int width;
        public final int height;
        public final int corner;
        public final int titleLeft;
        public final int titleRight;
        public final Insets insets;

        public PaintParameters(int width, int height, Component c) {
            this.width = width;
            this.height = height;
            this.insets = DefaultScreenDockWindowBorder.this.getBorderInsets(c);
            int hWidth = width / 2;
            this.titleLeft = hWidth - DefaultScreenDockWindowBorder.this.moveSize / 2;
            this.titleRight = hWidth + DefaultScreenDockWindowBorder.this.moveSize / 2;
            this.corner = Math.max(DefaultScreenDockWindowBorder.this.cornerSize, Math.max(Math.max(this.insets.top, this.insets.bottom), Math.max(this.insets.left, this.insets.right)));
        }
    }
}

