/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitDropTreeException;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.themes.StationCombinerValue;
import bibliothek.util.Path;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class SplitNode {
    private SplitNode parent;
    protected double x;
    protected double y;
    protected double width;
    protected double height;
    private SplitDockAccess access;
    private Set<Path> placeholders;
    private PlaceholderMap placeholderMap;
    private long id;
    private boolean idChecked = true;

    protected SplitNode(SplitDockAccess access, long id) {
        if (access == null) {
            throw new IllegalArgumentException("Access must not be null");
        }
        this.access = access;
        this.id = id < 0L ? access.uniqueID() : id;
    }

    protected void treeChanged() {
        if (this.parent != null) {
            this.parent.treeChanged();
        }
    }

    public SplitDockStation getStation() {
        return this.access.getOwner();
    }

    public Path[] getPlaceholders() {
        if (this.placeholders == null) {
            return new Path[0];
        }
        return this.placeholders.toArray(new Path[this.placeholders.size()]);
    }

    public void addPlaceholder(Path placeholder) {
        if (this.placeholders == null) {
            this.placeholders = new HashSet<Path>();
        }
        this.placeholders.add(placeholder);
    }

    public boolean hasPlaceholders() {
        return this.placeholders != null && !this.placeholders.isEmpty();
    }

    public boolean hasPlaceholder(Path placeholder) {
        if (this.placeholders == null) {
            return false;
        }
        return this.placeholders.contains(placeholder);
    }

    public void setPlaceholders(Path[] placeholders) {
        if (this.placeholders != null) {
            this.placeholders.clear();
        }
        if (placeholders != null) {
            for (Path placeholder : placeholders) {
                this.addPlaceholder(placeholder);
            }
        }
    }

    public boolean removePlaceholder(Path placeholder) {
        if (this.placeholders != null) {
            return this.placeholders.remove(placeholder);
        }
        return false;
    }

    public void removePlaceholders(Set<Path> placeholders) {
        if (this.placeholders != null) {
            this.placeholders.removeAll(placeholders);
        }
    }

    public void setPlaceholderMap(PlaceholderMap placeholderMap) {
        if (this.placeholderMap != null) {
            this.placeholderMap.setPlaceholderStrategy(null);
        }
        this.placeholderMap = placeholderMap;
        if (this.placeholderMap != null) {
            this.placeholderMap.setPlaceholderStrategy(this.getAccess().getOwner().getPlaceholderStrategy());
            this.getAccess().getPlaceholderSet().removeDoublePlaceholders(this, placeholderMap);
        }
    }

    public void movePlaceholderMap(SplitNode destination) {
        destination.setPlaceholderMap(null);
        destination.placeholderMap = this.placeholderMap;
        this.placeholderMap = null;
    }

    public PlaceholderMap getPlaceholderMap() {
        return this.placeholderMap;
    }

    public abstract boolean isOfUse();

    public void replace(SplitNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        SplitNode parent = this.getParent();
        if (parent != null) {
            int location = parent.getChildLocation(this);
            parent.setChild(node, location);
        }
    }

    public void delete(boolean shrink) {
        SplitNode parent;
        PlaceholderMap map = this.getPlaceholderMap();
        if (map != null) {
            map.setPlaceholderStrategy(null);
        }
        if ((parent = this.getParent()) != null) {
            if (shrink) {
                if (parent instanceof Root) {
                    ((Root)parent).setChild(null);
                } else if (!parent.hasPlaceholders()) {
                    Node node = (Node)parent;
                    SplitNode other = node.getLeft() == this ? node.getRight() : node.getLeft();
                    parent = node.getParent();
                    if (parent != null) {
                        int location = parent.getChildLocation(node);
                        parent.setChild(other, location);
                    }
                }
            } else {
                int location = parent.getChildLocation(this);
                parent.setChild(null, location);
            }
        }
    }

    protected void split(SplitDockPathProperty property, int depth, SplitNode newChild) {
        this.split(property, depth, newChild, -1L);
    }

    protected void split(SplitDockPathProperty property, int depth, SplitNode newChild, long newNodeId) {
        Node split;
        SplitDockPathProperty.Node node = property.getNode(depth);
        SplitDockStation.Orientation orientation = node.getLocation() == SplitDockPathProperty.Location.LEFT || node.getLocation() == SplitDockPathProperty.Location.RIGHT ? SplitDockStation.Orientation.HORIZONTAL : SplitDockStation.Orientation.VERTICAL;
        boolean reverse = node.getLocation() == SplitDockPathProperty.Location.RIGHT || node.getLocation() == SplitDockPathProperty.Location.BOTTOM;
        SplitDockPathProperty.Node lastNode = property.getLastNode();
        if (lastNode != null) {
            newNodeId = lastNode.getId();
        }
        SplitNode parent = this.getParent();
        int location = parent.getChildLocation(this);
        if (reverse) {
            split = this.createNode(newNodeId);
            split.setOrientation(orientation);
            split.setLeft(this);
            split.setRight(newChild);
            split.setDivider(1.0 - node.getSize());
        } else {
            split = this.createNode(newNodeId);
            split.setLeft(newChild);
            split.setRight(this);
            split.setOrientation(orientation);
            split.setDivider(node.getSize());
        }
        parent.setChild(split, location);
    }

    public Leaf createLeaf(long id) {
        return this.access.createLeaf(id);
    }

    public Node createNode(long id) {
        return this.access.createNode(id);
    }

    public Placeholder createPlaceholder(long id) {
        return this.access.createPlaceholder(id);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setParent(SplitNode parent) {
        if (this.parent != null) {
            SplitNode node = this.parent;
            this.parent = null;
            node.setChild(null, node.getChildLocation(this));
        }
        this.parent = parent;
    }

    public SplitNode getParent() {
        return this.parent;
    }

    public long getId() {
        return this.id;
    }

    protected void ensureIdUniqueAsync() {
        if (this.idChecked) {
            this.idChecked = false;
            if (EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!SplitNode.this.idChecked) {
                            SplitNode.this.idChecked = true;
                            Root root = SplitNode.this.getRoot();
                            if (root != null) {
                                root.ensureIdUnique();
                            }
                        }
                    }
                });
            } else {
                this.idChecked = true;
                Root root = this.getRoot();
                if (root != null) {
                    root.ensureIdUnique();
                }
            }
        }
    }

    protected void ensureIdUnique() {
        long[] ids = new long[this.getTotalChildrenCount() + 1];
        this.ensureIdUnique(ids, 0);
    }

    private int ensureIdUnique(long[] ids, int offset) {
        this.idChecked = true;
        int delta = 0;
        ids[offset] = this.getId();
        ++offset;
        int n = this.getMaxChildrenCount();
        for (int i = 0; i < n; ++i) {
            SplitNode child = this.getChild(i);
            if (child == null) continue;
            delta += child.ensureIdUnique(ids, offset + delta);
        }
        boolean issue = true;
        block1: while (issue) {
            issue = false;
            long id = this.getId();
            for (int i = 0; i < delta; ++i) {
                if (ids[offset + i] != id) continue;
                this.id = this.access.uniqueID();
                issue = true;
                continue block1;
            }
        }
        return delta + 1;
    }

    public int getTotalChildrenCount() {
        int max = this.getMaxChildrenCount();
        int sum = 0;
        for (int i = 0; i < max; ++i) {
            SplitNode node = this.getChild(i);
            if (node == null) continue;
            sum += 1 + node.getTotalChildrenCount();
        }
        return sum;
    }

    protected SplitDockAccess getAccess() {
        return this.access;
    }

    public abstract boolean isVisible();

    public abstract SplitNode getVisible();

    public abstract Dimension getMinimumSize();

    public abstract Dimension getPreferredSize();

    public void updateBounds(double x, double y, double width, double height, double factorW, double factorH, boolean updateComponentBounds) {
        this.setBounds(x, y, width, height, factorW, factorH, updateComponentBounds);
    }

    public void setBounds(double x, double y, double width, double height, double factorW, double factorH, boolean updateComponentBounds) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Root getRoot() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getRoot();
    }

    public abstract PutInfo getPut(int var1, int var2, double var3, double var5, Dockable var7);

    public abstract boolean isInOverrideZone(int var1, int var2, double var3, double var5);

    public abstract Leaf getLeaf(Dockable var1);

    public abstract Node getDividerNode(int var1, int var2);

    public abstract int getChildLocation(SplitNode var1);

    public abstract void setChild(SplitNode var1, int var2);

    public abstract int getMaxChildrenCount();

    public abstract SplitNode getChild(int var1);

    public abstract void visit(SplitNodeVisitor var1);

    public abstract void evolve(SplitDockTree.Key var1, boolean var2, Map<Leaf, Dockable> var3);

    public abstract boolean insert(SplitDockPathProperty var1, int var2, Dockable var3);

    public abstract boolean insert(SplitDockPlaceholderProperty var1, Dockable var2);

    public abstract boolean aside(AsideRequest var1);

    public abstract boolean aside(SplitDockPathProperty var1, int var2, AsideRequest var3);

    public SplitNode getPlaceholderNode(Path placeholder) {
        if (this.hasPlaceholder(placeholder)) {
            return this;
        }
        int n = this.getMaxChildrenCount();
        for (int i = 0; i < n; ++i) {
            SplitNode result;
            SplitNode child = this.getChild(i);
            if (child == null || (result = child.getPlaceholderNode(placeholder)) == null) continue;
            return result;
        }
        return null;
    }

    public abstract <N> N submit(SplitTreeFactory<N> var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(0, builder);
        return builder.toString();
    }

    public abstract void toString(int var1, StringBuilder var2);

    public Dimension getSize() {
        Root root = this.getRoot();
        double fw = root.getWidthFactor();
        double fh = root.getHeightFactor();
        return new Dimension((int)(this.width * fw + 0.5), (int)(this.height * fh + 0.5));
    }

    public Rectangle getBounds() {
        Root root = this.getRoot();
        double fw = root.getWidthFactor();
        double fh = root.getHeightFactor();
        Rectangle rec = new Rectangle((int)(this.x * fw + 0.5), (int)(this.y * fh + 0.5), (int)(this.width * fw + 0.5), (int)(this.height * fh + 0.5));
        Rectangle base = root.getBaseBounds();
        rec.x = Math.min(base.width, Math.max(base.x, rec.x));
        rec.y = Math.min(base.height, Math.max(base.y, rec.y));
        rec.width = Math.min(base.width - rec.x + base.x, Math.max(0, rec.width));
        rec.height = Math.min(base.height - rec.y + base.y, Math.max(0, rec.height));
        return rec;
    }

    protected Leaf create(Dockable dockable, long id) {
        MultiDockAcceptance acceptance;
        SplitDockStation split = this.access.getOwner();
        DockController controller = split.getController();
        MultiDockAcceptance multiDockAcceptance = acceptance = controller == null ? null : controller.getAcceptance();
        if (!dockable.accept(split) || !split.accept(dockable)) {
            return null;
        }
        if (acceptance != null && !acceptance.accept(split, dockable)) {
            return null;
        }
        Leaf leaf = this.createLeaf(id);
        return leaf;
    }

    protected SplitNode create(SplitDockTree.Key key, boolean checkValidity, Map<Leaf, Dockable> linksToSet) {
        SplitDockTree tree = key.getTree();
        if (tree.isDockable(key)) {
            Leaf leaf;
            Dockable[] dockables = (Dockable[])tree.getDockables(key);
            if (dockables == null || dockables.length == 0) {
                Path[] placeholders = tree.getPlaceholders(key);
                Placeholder leaf2 = this.createPlaceholder(key.getNodeId());
                leaf2.setPlaceholders(placeholders);
                leaf2.setPlaceholderMap(tree.getPlaceholderMap(key));
                return leaf2;
            }
            SplitDockStation split = this.access.getOwner();
            DockController controller = split.getController();
            MultiDockAcceptance acceptance = controller == null ? null : controller.getAcceptance();
            boolean removePlaceholderMap = false;
            if (dockables.length == 1) {
                if (checkValidity) {
                    if (!dockables[0].accept(split) || !split.accept(dockables[0])) {
                        throw new SplitDropTreeException(split, "No acceptance for " + dockables[0]);
                    }
                    if (acceptance != null && !acceptance.accept(split, dockables[0])) {
                        throw new SplitDropTreeException(split, "DockAcceptance does not allow child " + dockables[0]);
                    }
                }
                leaf = this.createLeaf(key.getNodeId());
                linksToSet.put(leaf, dockables[0]);
            } else {
                if (checkValidity) {
                    if (!dockables[0].accept(split, dockables[1]) || !dockables[1].accept(split, dockables[1])) {
                        throw new SplitDropTreeException(split, "No acceptance for combination of " + dockables[0] + " and " + dockables[1]);
                    }
                    if (acceptance != null && !acceptance.accept(split, dockables[0], dockables[1])) {
                        throw new SplitDropTreeException(split, "DockAcceptance does not allow to combine " + dockables[0] + " and " + dockables[1]);
                    }
                }
                StationCombinerValue combiner = this.access.getOwner().getCombiner();
                NodeCombinerSource source = new NodeCombinerSource(dockables[0], dockables[1], key.getTree().getPlaceholderMap(key));
                CombinerTarget target = combiner.prepare(source, Enforcement.HARD);
                Dockable combination = combiner.combine(source, target);
                removePlaceholderMap = true;
                if (dockables.length == 2) {
                    Dockable selected;
                    leaf = this.createLeaf(key.getNodeId());
                    linksToSet.put(leaf, combination);
                    DockStation station = combination.asDockStation();
                    if (station != null && (selected = (Dockable)key.getTree().getSelected(key)) != null) {
                        station.setFrontDockable(selected);
                    }
                } else {
                    DockStation station = combination.asDockStation();
                    if (station == null) {
                        throw new SplitDropTreeException(this.access.getOwner(), "Combination of two Dockables does not create a new station");
                    }
                    leaf = this.createLeaf(key.getNodeId());
                    linksToSet.put(leaf, combination);
                    for (int i = 2; i < dockables.length; ++i) {
                        Dockable dockable = dockables[i];
                        if (checkValidity) {
                            if (!dockable.accept(station) || !station.accept(dockable)) {
                                throw new SplitDropTreeException(this.access.getOwner(), "No acceptance of " + dockable + " and " + station);
                            }
                            if (acceptance != null && !acceptance.accept(station, dockable)) {
                                throw new SplitDropTreeException(split, "DockAcceptance does not allow " + dockable + " as child of " + station);
                            }
                        }
                        station.drop(dockable);
                    }
                    Dockable selected = (Dockable)key.getTree().getSelected(key);
                    if (selected != null) {
                        station.setFrontDockable(selected);
                    }
                }
            }
            leaf.evolve(key, checkValidity, linksToSet);
            if (removePlaceholderMap) {
                leaf.setPlaceholderMap(null);
            }
            return leaf;
        }
        Node node = this.createNode(key.getNodeId());
        node.evolve(key, checkValidity, linksToSet);
        return node;
    }

    public double intersection(SplitDockProperty property) {
        double rx1 = Math.max(this.x, property.getX());
        double ry1 = Math.max(this.y, property.getY());
        double rx2 = Math.min(this.x + this.width, property.getX() + property.getWidth());
        double ry2 = Math.min(this.y + this.height, property.getY() + property.getHeight());
        if (rx1 > rx2 || ry1 > ry2) {
            return 0.0;
        }
        if (property.getWidth() == 0.0 || property.getHeight() == 0.0) {
            return 0.0;
        }
        double max = Math.max(property.getWidth() * property.getHeight(), this.width * this.height);
        return (rx2 - rx1) * (ry2 - ry1) / max;
    }

    public PutInfo.Put relativeSidePut(double kx, double ky) {
        if (SplitNode.above(this.x, this.y, this.x + this.width, this.y + this.height, kx, ky)) {
            if (SplitNode.above(this.x, this.y + this.height, this.x + this.width, this.y, kx, ky)) {
                return PutInfo.Put.TOP;
            }
            return PutInfo.Put.RIGHT;
        }
        if (SplitNode.above(this.x, this.y + this.height, this.x + this.width, this.y, kx, ky)) {
            return PutInfo.Put.LEFT;
        }
        return PutInfo.Put.BOTTOM;
    }

    public static boolean above(double x1, double y1, double x2, double y2, double x, double y) {
        double a = y1 - y2;
        double b = x2 - x1;
        if (b == 0.0) {
            return false;
        }
        double c = a * x1 + b * y1;
        double sy = (c - a * x) / b;
        return y < sy;
    }

    private class NodeCombinerSource
    implements CombinerSource {
        private Dockable child;
        private Dockable dropping;
        private PlaceholderMap placeholders;

        public NodeCombinerSource(Dockable child, Dockable dropping, PlaceholderMap placeholders) {
            this.child = child;
            this.dropping = dropping;
            this.placeholders = placeholders;
        }

        @Override
        public Point getMousePosition() {
            return null;
        }

        @Override
        public Dockable getNew() {
            return this.dropping;
        }

        @Override
        public Dockable getOld() {
            return this.child;
        }

        @Override
        public DockableDisplayer getOldDisplayer() {
            return null;
        }

        @Override
        public DockStation getParent() {
            return SplitNode.this.access.getOwner();
        }

        @Override
        public PlaceholderMap getPlaceholders() {
            return this.placeholders;
        }

        @Override
        public Dimension getSize() {
            return null;
        }

        @Override
        public boolean isMouseOverTitle() {
            return true;
        }
    }
}

