/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.color;

import bibliothek.gui.DockUI;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.UISchemeListener;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.gui.dock.util.laf.LookAndFeelColorsListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractColorScheme
implements ColorScheme {
    private List<UISchemeListener<Color, DockColor, ColorBridge>> listeners = new ArrayList<UISchemeListener<Color, DockColor, ColorBridge>>();
    private List<ColorManager> managers = new ArrayList<ColorManager>();
    private LookAndFeelColorsListener updateUiListener = new LookAndFeelColorsListener(){

        @Override
        public void colorsChanged() {
            try {
                for (ColorManager manager : AbstractColorScheme.this.managers) {
                    manager.lockUpdate();
                }
                AbstractColorScheme.this.updateUI();
            }
            finally {
                for (ColorManager manager : AbstractColorScheme.this.managers) {
                    manager.unlockUpdate();
                }
            }
        }

        @Override
        public void colorChanged(String key) {
            this.colorsChanged();
        }
    };

    @Override
    public void addListener(UISchemeListener<Color, DockColor, ColorBridge> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        boolean ui = this.shouldListenUI();
        this.listeners.add(listener);
        if (!ui && this.shouldListenUI()) {
            DockUI.getDefaultDockUI().addLookAndFeelColorsListener(this.updateUiListener);
            this.updateUI();
        }
    }

    @Override
    public void removeListener(UISchemeListener<Color, DockColor, ColorBridge> listener) {
        boolean ui = this.shouldListenUI();
        this.listeners.remove(listener);
        if (ui && !this.shouldListenUI()) {
            DockUI.getDefaultDockUI().removeLookAndFeelColorsListener(this.updateUiListener);
        }
    }

    protected UISchemeListener<Color, DockColor, ColorBridge>[] listeners() {
        return this.listeners.toArray(new UISchemeListener[this.listeners.size()]);
    }

    protected boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    protected void fire(UISchemeEvent<Color, DockColor, ColorBridge> event) {
        for (UISchemeListener<Color, DockColor, ColorBridge> listener : this.listeners()) {
            listener.changed(event);
        }
    }

    protected ColorManager[] managers() {
        return this.managers.toArray(new ColorManager[this.managers.size()]);
    }

    @Override
    public void install(UIProperties<Color, DockColor, ColorBridge> properties) {
        boolean ui = this.shouldListenUI();
        this.managers.add((ColorManager)properties);
        if (!ui && this.shouldListenUI()) {
            DockUI.getDefaultDockUI().addLookAndFeelColorsListener(this.updateUiListener);
            this.updateUI();
        }
    }

    @Override
    public void uninstall(UIProperties<Color, DockColor, ColorBridge> properties) {
        boolean ui = this.shouldListenUI();
        this.managers.remove((ColorManager)properties);
        if (ui && !this.shouldListenUI()) {
            DockUI.getDefaultDockUI().removeLookAndFeelColorsListener(this.updateUiListener);
        }
    }

    private boolean shouldListenUI() {
        return this.managers.size() > 0 || this.listeners.size() > 0;
    }

    protected abstract void updateUI();
}

