/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geo.plugin.IApplication;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteothink.trajstat.Main;

public class FrmCreateGridLayer
extends JDialog {
    private final IApplication app;
    private ButtonGroup buttonGroup1;
    private JButton jButton_CreateLayer;
    private JComboBox jComboBox_SameAsLayer;
    private JComboBox jComboBox_Type;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel_Precision;
    private JLabel jLabel_Width;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel_CWTField;
    private JRadioButton jRadioButton_LonLat;
    private JRadioButton jRadioButton_SameAsMap;
    private JSpinner jSpinner_Precision;
    private JSpinner jSpinner_Width;
    private JTextField jTextField_Bottom;
    private JTextField jTextField_CellSize;
    private JTextField jTextField_Left;
    private JTextField jTextField_Right;
    private JTextField jTextField_Top;

    public FrmCreateGridLayer(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (IApplication)parent;
        this.jRadioButton_LonLat.setSelected(true);
        this.jComboBox_Type.removeAllItems();
        this.jComboBox_Type.addItem("PSCF");
        this.jComboBox_Type.addItem("CWT");
        this.jComboBox_Type.setSelectedIndex(0);
        this.jComboBox_SameAsLayer.removeAllItems();
        this.jComboBox_SameAsLayer.addItem("None");
        for (MapLayer layer : this.app.getMapDocument().getActiveMapFrame().getMapView().getLayers()) {
            this.jComboBox_SameAsLayer.addItem(layer.getLayerName());
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox_SameAsLayer = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jTextField_Left = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextField_Right = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextField_CellSize = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextField_Bottom = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextField_Top = new JTextField();
        this.jLabel7 = new JLabel();
        this.jComboBox_Type = new JComboBox();
        this.jPanel_CWTField = new JPanel();
        this.jLabel_Width = new JLabel();
        this.jSpinner_Width = new JSpinner();
        this.jLabel_Precision = new JLabel();
        this.jSpinner_Precision = new JSpinner();
        this.jButton_CreateLayer = new JButton();
        this.jPanel2 = new JPanel();
        this.jRadioButton_LonLat = new JRadioButton();
        this.jRadioButton_SameAsMap = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Setting"));
        this.jLabel1.setText("Extent same as:");
        this.jComboBox_SameAsLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_SameAsLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmCreateGridLayer.this.jComboBox_SameAsLayerActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Left:");
        this.jLabel3.setText("Right:");
        this.jLabel4.setText("Cell Size:");
        this.jLabel5.setText("Bottom:");
        this.jLabel6.setText("Top:");
        this.jLabel7.setText("Type:");
        this.jComboBox_Type.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmCreateGridLayer.this.jComboBox_TypeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_SameAsLayer, 0, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Bottom, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Top, -2, 80, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Left, -2, 80, -2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Right, -2, 80, -2))).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_CellSize, -2, 80, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Type, 0, -1, Short.MAX_VALUE))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_SameAsLayer, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField_Left, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jTextField_Right, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jTextField_CellSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextField_Top, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jComboBox_Type, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextField_Bottom, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel_CWTField.setBorder(BorderFactory.createTitledBorder("CWT Field"));
        this.jLabel_Width.setText("Width:");
        this.jLabel_Precision.setText("Precision:");
        GroupLayout jPanel_CWTFieldLayout = new GroupLayout(this.jPanel_CWTField);
        this.jPanel_CWTField.setLayout(jPanel_CWTFieldLayout);
        jPanel_CWTFieldLayout.setHorizontalGroup(jPanel_CWTFieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_CWTFieldLayout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.jLabel_Width).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_Width, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel_Precision).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_Precision, -2, 123, -2).addGap(33, 33, 33)));
        jPanel_CWTFieldLayout.setVerticalGroup(jPanel_CWTFieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_CWTFieldLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_CWTFieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_CWTFieldLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Precision).addComponent(this.jSpinner_Precision, -2, -1, -2)).addGroup(jPanel_CWTFieldLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Width).addComponent(this.jSpinner_Width, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_CreateLayer.setText("Create Layer");
        this.jButton_CreateLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmCreateGridLayer.this.jButton_CreateLayerActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Projection"));
        this.buttonGroup1.add(this.jRadioButton_LonLat);
        this.jRadioButton_LonLat.setText("Longitude/Latitude");
        this.buttonGroup1.add(this.jRadioButton_SameAsMap);
        this.jRadioButton_SameAsMap.setText("Same as Map");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jRadioButton_LonLat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jRadioButton_SameAsMap).addGap(103, 103, 103)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton_LonLat).addComponent(this.jRadioButton_SameAsMap)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(170, 170, 170).addComponent(this.jButton_CreateLayer, -2, 144, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel_CWTField, -1, -1, Short.MAX_VALUE)))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addGap(14, 14, 14).addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel_CWTField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButton_CreateLayer, -2, 40, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jComboBox_SameAsLayerActionPerformed(ActionEvent evt) {
        String layerName;
        if (this.jComboBox_SameAsLayer.getItemCount() > 0 && !(layerName = this.jComboBox_SameAsLayer.getSelectedItem().toString()).equals("None")) {
            MapLayer layer = this.app.getMapDocument().getActiveMapFrame().getMapView().getLayer(layerName);
            Extent extent = layer.getExtent();
            this.jTextField_Bottom.setText(String.valueOf(extent.minY));
            this.jTextField_Left.setText(String.valueOf(extent.minX));
            this.jTextField_Right.setText(String.valueOf(extent.maxX));
            this.jTextField_Top.setText(String.valueOf(extent.maxY));
        }
    }

    private void jComboBox_TypeActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Type.getItemCount() > 0) {
            String type = this.jComboBox_Type.getSelectedItem().toString();
            if (type.equals("PSCF")) {
                this.jSpinner_Width.setValue(10);
                this.jSpinner_Precision.setValue(4);
                this.jPanel_CWTField.setEnabled(false);
                this.jLabel_Width.setEnabled(false);
                this.jLabel_Precision.setEnabled(false);
                this.jSpinner_Width.setEnabled(false);
                this.jSpinner_Precision.setEnabled(false);
            } else if (type.equals("CWT")) {
                this.jSpinner_Width.setValue(10);
                this.jSpinner_Precision.setValue(2);
                this.jPanel_CWTField.setEnabled(true);
                this.jLabel_Width.setEnabled(true);
                this.jLabel_Precision.setEnabled(true);
                this.jSpinner_Width.setEnabled(true);
                this.jSpinner_Precision.setEnabled(true);
            }
        }
    }

    private void jButton_CreateLayerActionPerformed(ActionEvent evt) {
        if (this.jTextField_Bottom.getText().isEmpty() || this.jTextField_CellSize.getText().isEmpty() || this.jTextField_Left.getText().isEmpty() || this.jTextField_Right.getText().isEmpty() || this.jTextField_Top.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Please finish setting first!");
            return;
        }
        double aLeft = Double.parseDouble(this.jTextField_Left.getText());
        double aRight = Double.parseDouble(this.jTextField_Right.getText());
        double aTop = Double.parseDouble(this.jTextField_Top.getText());
        double aBottom = Double.parseDouble(this.jTextField_Bottom.getText());
        double aCellSize = Double.parseDouble(this.jTextField_CellSize.getText());
        if (aRight <= aLeft | aTop <= aBottom) {
            JOptionPane.showMessageDialog(null, "Invalid extent! Please reinput!");
            return;
        }
        int xNum = (int)((aRight - aLeft) / aCellSize);
        int yNum = (int)((aTop - aBottom) / aCellSize);
        this.setCursor(Cursor.getPredefinedCursor(3));
        String type = this.jComboBox_Type.getSelectedItem().toString();
        ProjectionInfo projInfo = this.jRadioButton_LonLat.isSelected() ? KnownCoordinateSystems.geographic.world.WGS1984 : this.app.getMapView().getProjection().getProjInfo();
        if (type.equals("PSCF")) {
            try {
                this.create_PSCFLayer(xNum, yNum, aLeft, aTop, aCellSize, projInfo);
            }
            catch (IOException ex) {
                Logger.getLogger(FrmCreateGridLayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (type.equals("CWT")) {
            try {
                this.create_CWTLayer(xNum, yNum, aLeft, aTop, aCellSize, projInfo);
            }
            catch (IOException ex) {
                Logger.getLogger(FrmCreateGridLayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void create_PSCFLayer(int xNum, int yNum, double aLeft, double aTop, double aCellSize, ProjectionInfo projInfo) throws IOException {
        String userPath = System.getProperty("user.dir");
        File pathDir = new File(userPath);
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"shp"};
        GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "Shape File (*.shp)");
        aDlg.setFileFilter((FileFilter)pFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog((JFrame)this.app)) {
            File file = aDlg.getSelectedFile();
            String shpfn = file.getCanonicalPath();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            if (!shpfn.substring(shpfn.length() - extent.length()).equals(extent)) {
                shpfn = shpfn + "." + extent;
                file = new File(shpfn);
            }
            VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYGON);
            aLayer.editAddField("ID", DataType.INT);
            aLayer.editAddField("N_Traj", DataType.INT);
            aLayer.editAddField("Nij", DataType.INT);
            aLayer.editAddField("Mij", DataType.INT);
            aLayer.editAddField("PSCF", DataType.DOUBLE);
            aLayer.editAddField("WPSCF", DataType.DOUBLE);
            for (int j = 0; j <= yNum - 1; ++j) {
                for (int i = 0; i <= xNum - 1; ++i) {
                    PolygonShape aPGS = new PolygonShape();
                    ArrayList<PointD> pList = new ArrayList<PointD>();
                    PointD newPt = new PointD();
                    double aX = aLeft + (double)i * aCellSize;
                    double aY = aTop - (double)j * aCellSize;
                    newPt.X = aX;
                    newPt.Y = aY;
                    pList.add(newPt);
                    newPt = new PointD();
                    newPt.X = aX += aCellSize;
                    newPt.Y = aY;
                    pList.add(newPt);
                    newPt = new PointD();
                    newPt.X = aX;
                    newPt.Y = aY -= aCellSize;
                    pList.add(newPt);
                    newPt = new PointD();
                    newPt.X = aX -= aCellSize;
                    newPt.Y = aY;
                    pList.add(newPt);
                    pList.add((PointD)pList.get(0));
                    aPGS.setPoints(pList);
                    aPGS.setExtent(GeometryUtil.getPointsExtent((List)aPGS.getPoints()));
                    int shapeNum = aLayer.getShapeNum();
                    try {
                        if (!aLayer.editInsertShape((Shape)aPGS, shapeNum)) continue;
                        aLayer.editCellValue("ID", shapeNum, (Object)(shapeNum + 1));
                        aLayer.editCellValue("N_Traj", shapeNum, (Object)0);
                        aLayer.editCellValue("Nij", shapeNum, (Object)0);
                        aLayer.editCellValue("Mij", shapeNum, (Object)0);
                        aLayer.editCellValue("PSCF", shapeNum, (Object)0.0);
                        aLayer.editCellValue("WPSCF", shapeNum, (Object)0.0);
                        continue;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(FrmCreateGridLayer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            if (aLayer.getShapeNum() <= 0) {
                JOptionPane.showMessageDialog(null, "No valid shapes created.");
                return;
            }
            aLayer.setLayerName(file.getName());
            LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYGON, (Color)Color.yellow, (float)1.0f);
            aLS.setFieldName("ID");
            aLayer.setLegendScheme(aLS);
            aLayer.setLayerDrawType(LayerDrawType.GRID_FILL);
            aLayer.setFileName(shpfn);
            aLayer.setProjInfo(projInfo);
            aLayer.saveFile(shpfn);
            Main.addLayer(aLayer, this.app.getMapDocument().getActiveMapFrame(), "PSCF");
        }
    }

    private void create_CWTLayer(int xNum, int yNum, double aLeft, double aTop, double aCellSize, ProjectionInfo projInfo) throws IOException {
        String userPath = System.getProperty("user.dir");
        File pathDir = new File(userPath);
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"shp"};
        GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "Shape File (*.shp)");
        aDlg.setFileFilter((FileFilter)pFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog((JFrame)this.app)) {
            File file = aDlg.getSelectedFile();
            String shpfn = file.getCanonicalPath();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            if (!shpfn.substring(shpfn.length() - extent.length()).equals(extent)) {
                shpfn = shpfn + "." + extent;
                file = new File(shpfn);
            }
            VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYGON);
            aLayer.editAddField("ID", DataType.INT);
            aLayer.editAddField("N_Traj", DataType.INT);
            aLayer.editAddField("Nij", DataType.INT);
            aLayer.editAddField("CWT", DataType.DOUBLE);
            aLayer.editAddField("WCWT", DataType.DOUBLE);
            for (int j = 0; j <= yNum - 1; ++j) {
                for (int i = 0; i <= xNum - 1; ++i) {
                    PolygonShape aPGS = new PolygonShape();
                    ArrayList<PointD> pList = new ArrayList<PointD>();
                    PointD newPt = new PointD();
                    double aX = aLeft + (double)i * aCellSize;
                    double aY = aTop - (double)j * aCellSize;
                    newPt.X = aX;
                    newPt.Y = aY;
                    pList.add(newPt);
                    newPt = new PointD();
                    newPt.X = aX += aCellSize;
                    newPt.Y = aY;
                    pList.add(newPt);
                    newPt = new PointD();
                    newPt.X = aX;
                    newPt.Y = aY -= aCellSize;
                    pList.add(newPt);
                    newPt = new PointD();
                    newPt.X = aX -= aCellSize;
                    newPt.Y = aY;
                    pList.add(newPt);
                    pList.add((PointD)pList.get(0));
                    aPGS.setPoints(pList);
                    aPGS.setExtent(GeometryUtil.getPointsExtent((List)aPGS.getPoints()));
                    int shapeNum = aLayer.getShapeNum();
                    try {
                        if (!aLayer.editInsertShape((Shape)aPGS, shapeNum)) continue;
                        aLayer.editCellValue("ID", shapeNum, (Object)(shapeNum + 1));
                        aLayer.editCellValue("N_Traj", shapeNum, (Object)0);
                        aLayer.editCellValue("Nij", shapeNum, (Object)0);
                        aLayer.editCellValue("CWT", shapeNum, (Object)0.0);
                        aLayer.editCellValue("WCWT", shapeNum, (Object)0.0);
                        continue;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(FrmCreateGridLayer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            if (aLayer.getShapeNum() <= 0) {
                JOptionPane.showMessageDialog(null, "No valid shapes created.");
                return;
            }
            aLayer.setLayerName(file.getName());
            LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYGON, (Color)Color.yellow, (float)1.0f);
            aLS.setFieldName("ID");
            aLayer.setLegendScheme(aLS);
            aLayer.setLayerDrawType(LayerDrawType.GRID_FILL);
            aLayer.setFileName(shpfn);
            aLayer.setProjInfo(projInfo);
            aLayer.saveFile(shpfn);
            Main.addLayer(aLayer, this.app.getMapDocument().getActiveMapFrame(), "CWT");
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmCreateGridLayer.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmCreateGridLayer dialog = new FrmCreateGridLayer((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

