/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.radar.BaseRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.IRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.RadarDataType;
import org.meteoinfo.data.meteodata.radar.RadialRecord;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class SABRadarDataInfo
extends BaseRadarDataInfo
implements IRadarDataInfo {
    private boolean isCACB = false;
    private int reflectivityFixSize = 460;
    private int dopplerFixSize = 920;

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    void setScaleOffset(RadialRecord record, int vResolution) {
        switch (record.product) {
            case "dBZ": {
                record.scale = 0.5f;
                record.offset = -33.0f;
                break;
            }
            case "V": {
                if (vResolution == 2) {
                    record.scale = 0.5f;
                    record.offset = -64.5f;
                    break;
                }
                record.scale = 1.0f;
                record.offset = -129.0f;
                break;
            }
            case "W": {
                record.scale = 0.5f;
                record.offset = -64.5f;
            }
        }
    }

    public void setCACB(Boolean value) {
        this.isCACB = value;
        if (this.isCACB) {
            this.reflectivityFixSize = 800;
            this.dopplerFixSize = 1600;
        } else {
            this.reflectivityFixSize = 460;
            this.dopplerFixSize = 1600;
        }
    }

    @Override
    void readDataInfo(InputStream is) {
        try {
            int index = 0;
            byte[] rhBytes = new byte[RadialHeader.length];
            while (is.read(rhBytes) != -1) {
                RadialHeader radialHeader = new RadialHeader(rhBytes);
                if (index == 0) {
                    this.logResolution = radialHeader.gateSizeOfReflectivity;
                    this.dopplerResolution = radialHeader.gateSizeOfDoppler;
                    if (radialHeader.gatesNumberOfReflectivity > 460) {
                        this.setCACB(true);
                    }
                }
                if (!radialHeader.hasReflectivityData()) {
                    is.read(new byte[this.reflectivityFixSize]);
                }
                for (String product : radialHeader.getProducts()) {
                    RadialRecord record;
                    if (this.recordMap.containsKey(product)) {
                        record = (RadialRecord)this.recordMap.get(product);
                    } else {
                        record = new RadialRecord(product);
                        record.setBinLength(1);
                        this.setScaleOffset(record, radialHeader.resolutionOfVelocity);
                        this.recordMap.put(product, record);
                    }
                    if (radialHeader.radialNumber == 1) {
                        record.fixedElevation.add(Float.valueOf(radialHeader.getElevation()));
                        record.elevation.add(new ArrayList());
                        record.azimuth.add(new ArrayList());
                        record.azimuthMinIndex.add(0);
                        if (this.isVelocityGroup(record)) {
                            record.disResolution.add(Float.valueOf(radialHeader.gateSizeOfDoppler));
                            record.distance.add(ArrayUtil.arrayRange1((Number)radialHeader.rangeToFirstGateOfDop, (int)radialHeader.gatesNumberOfDoppler, (Number)radialHeader.gateSizeOfDoppler));
                        } else {
                            record.disResolution.add(Float.valueOf(radialHeader.gateSizeOfReflectivity));
                            record.distance.add(ArrayUtil.arrayRange1((Number)radialHeader.rangeToFirstGateOfRef, (int)radialHeader.gatesNumberOfReflectivity, (Number)radialHeader.gateSizeOfReflectivity));
                        }
                        record.newScanData();
                    }
                    record.elevation.get(record.elevation.size() - 1).add(Float.valueOf(radialHeader.getElevation()));
                    record.addAzimuth(radialHeader.getAzimuth());
                    int dataLength = this.isVelocityGroup(record) ? radialHeader.gatesNumberOfDoppler : radialHeader.gatesNumberOfReflectivity;
                    byte[] bytes = new byte[dataLength];
                    is.read(bytes);
                    record.addDataBytes(bytes);
                    if (this.isVelocityGroup(record)) {
                        if (dataLength >= this.dopplerFixSize) continue;
                        is.read(new byte[this.dopplerFixSize - dataLength]);
                        continue;
                    }
                    if (dataLength >= this.reflectivityFixSize) continue;
                    is.read(new byte[this.reflectivityFixSize - dataLength]);
                }
                if (!radialHeader.hasDopplerData()) {
                    is.read(new byte[this.dopplerFixSize * 2]);
                }
                is.read(new byte[4]);
                ++index;
            }
            is.close();
            this.addAttribute(new Attribute("featureType", "RADIAL"));
            this.addAttribute(new Attribute("DataType", "Radial"));
            String radarDataTypeStr = "SA/SB";
            if (this.isCACB) {
                radarDataTypeStr = "CA/CB";
            }
            this.addAttribute(new Attribute("RadarDataType", radarDataTypeStr));
            RadialRecord refRadialRecord = (RadialRecord)this.recordMap.get("dBZ");
            this.radialDim = new Dimension();
            this.radialDim.setName("radial");
            this.radialDim.setLength(refRadialRecord.getMaxRadials());
            this.addDimension(this.radialDim);
            this.scanDim = new Dimension();
            this.scanDim.setName("scan");
            this.scanDim.setLength(refRadialRecord.getScanNumber());
            this.addDimension(this.scanDim);
            this.gateRDim = new Dimension();
            this.gateRDim.setName("gateR");
            this.gateRDim.setLength(refRadialRecord.getGateNumber(0));
            this.addDimension(this.gateRDim);
            this.makeRefVariables(refRadialRecord);
            RadialRecord velRadialRecord = (RadialRecord)this.recordMap.get("V");
            this.gateVDim = new Dimension();
            this.gateVDim.setName("gateV");
            this.gateVDim.setLength(velRadialRecord.getGateNumber(0));
            this.addDimension(this.gateVDim);
            this.makeVelVariables(velRadialRecord);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RadarDataType getRadarDataType() {
        return RadarDataType.SAB;
    }

    static class RadialHeader {
        public static int length = 128;
        public short messageType;
        public int mSecond;
        public short julianDate;
        public short uRange;
        public int azimuth;
        public short radialNumber;
        public short radialStatus;
        public short elevation;
        public short elNumber;
        public int rangeToFirstGateOfRef;
        public int rangeToFirstGateOfDop;
        public int gateSizeOfReflectivity;
        public int gateSizeOfDoppler;
        public int gatesNumberOfReflectivity;
        public int gatesNumberOfDoppler;
        public short cutSectorNumber;
        public int calibrationConst;
        public short ptrOfReflectivity;
        public short ptrOfVelocity;
        public short ptrOfSpectrumWidth;
        public int resolutionOfVelocity;
        public short vcpNumber;
        public short nyquist;

        public RadialHeader(byte[] inBytes) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(inBytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(14);
            this.messageType = byteBuffer.getShort();
            byteBuffer.position(28);
            this.mSecond = byteBuffer.getInt();
            this.julianDate = byteBuffer.getShort();
            this.uRange = byteBuffer.getShort();
            this.azimuth = DataType.unsignedShortToInt((short)byteBuffer.getShort());
            this.radialNumber = byteBuffer.getShort();
            this.radialStatus = byteBuffer.getShort();
            this.elevation = byteBuffer.getShort();
            this.elNumber = byteBuffer.getShort();
            this.rangeToFirstGateOfRef = byteBuffer.getShort();
            this.rangeToFirstGateOfDop = byteBuffer.getShort();
            this.gateSizeOfReflectivity = byteBuffer.getShort();
            this.gateSizeOfDoppler = byteBuffer.getShort();
            this.gatesNumberOfReflectivity = byteBuffer.getShort();
            this.gatesNumberOfDoppler = byteBuffer.getShort();
            this.cutSectorNumber = byteBuffer.getShort();
            this.calibrationConst = byteBuffer.getShort();
            this.ptrOfReflectivity = byteBuffer.getShort();
            this.ptrOfVelocity = byteBuffer.getShort();
            this.ptrOfSpectrumWidth = byteBuffer.getShort();
            this.resolutionOfVelocity = byteBuffer.getShort();
            this.vcpNumber = byteBuffer.getShort();
            byteBuffer.position(byteBuffer.position() + 14);
            this.nyquist = byteBuffer.getShort();
        }

        public LocalDateTime getDateTime() {
            long total = (long)(this.julianDate - 1) * 24L * 3600L * 1000L + (long)this.mSecond;
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(total), ZoneId.systemDefault());
        }

        public boolean hasReflectivityData() {
            return this.gatesNumberOfReflectivity > 0;
        }

        public boolean hasDopplerData() {
            return this.gatesNumberOfDoppler > 0;
        }

        public List<String> getProducts() {
            ArrayList<String> products = new ArrayList<String>();
            if (this.hasReflectivityData()) {
                products.add("dBZ");
            }
            if (this.hasDopplerData()) {
                products.add("V");
                products.add("W");
            }
            return products;
        }

        public float getAzimuth() {
            return (float)this.azimuth / 8.0f * 180.0f / 4096.0f;
        }

        public float getElevation() {
            return (float)this.elevation / 8.0f * 180.0f / 4096.0f;
        }
    }
}

