/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.util;

import java.util.ArrayList;
import org.meteoinfo.data.dimarray.DimArray;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;

public class WRFUtil {
    public static DimArray deStagger(DimArray array, int axis) {
        try {
            Dimension sDim = array.getDimension(axis);
            Range range1 = new Range(0, sDim.getLength() - 2);
            Range range2 = new Range(1, sDim.getLength() - 1);
            Array sDimValue = sDim.getDimValue();
            Array sDimValue1 = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{sDim.getLength() - 1});
            int i = 0;
            while ((long)i < sDimValue1.getSize()) {
                sDimValue1.setDouble(i, 0.5 * (sDimValue.getDouble(i) + sDimValue.getDouble(i + 1)));
                ++i;
            }
            Dimension sDim1 = new Dimension(sDim);
            sDim1.setDimValue(sDimValue1);
            sDim1.setStagger(false);
            ArrayList<Range> rangeList1 = new ArrayList<Range>();
            ArrayList<Range> rangeList2 = new ArrayList<Range>();
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
            for (int i2 = 0; i2 < array.getDimensions().size(); ++i2) {
                if (i2 == axis) {
                    rangeList1.add(range1);
                    rangeList2.add(range2);
                    dimensions.add(sDim1);
                    continue;
                }
                Dimension dimension = array.getDimension(i2);
                rangeList1.add(new Range(dimension.getLength()));
                rangeList2.add(new Range(dimension.getLength()));
                dimensions.add(dimension);
            }
            Array array1 = array.getArray().section(rangeList1);
            Array array2 = array.getArray().section(rangeList2);
            Array r = ArrayMath.mul((Array)ArrayMath.add((Array)array1, (Array)array2), (Number)0.5);
            return new DimArray(r, dimensions);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            return array;
        }
    }

    public static DimArray deStagger(DimArray array) {
        int idx = array.getStaggerDimIndex();
        if (idx >= 0) {
            return WRFUtil.deStagger(array, idx);
        }
        return array;
    }

    public static DimArray getGPM(DataInfo dataInfo) {
        DimArray ph = dataInfo.readDimArray("PH");
        ph = WRFUtil.deStagger(ph);
        DimArray phb = dataInfo.readDimArray("PHB");
        phb = WRFUtil.deStagger(phb);
        Array gpm = ArrayMath.div((Array)ArrayMath.add((Array)ph.getArray(), (Array)phb.getArray()), (Number)9.81);
        return new DimArray(gpm, ph.getDimensions());
    }

    public static DimArray getGPM1D(DataInfo dataInfo) {
        Variable variable = dataInfo.getVariable("PH");
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Dimension dimension : variable.getDimensions()) {
            if (dimension.isStagger()) {
                ranges.add(new Range(dimension.getLength()));
                continue;
            }
            ranges.add(new Range(1));
        }
        DimArray ph = dataInfo.readDimArray("PH", ranges);
        ph = WRFUtil.deStagger(ph);
        DimArray phb = dataInfo.readDimArray("PHB", ranges);
        phb = WRFUtil.deStagger(phb);
        Array gpm = ArrayMath.div((Array)ArrayMath.add((Array)ph.getArray(), (Array)phb.getArray()), (Number)9.81);
        return new DimArray(gpm, ph.getDimensions());
    }
}

