/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.console;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.text.JTextComponent;

public class Popup
extends JWindow {
    private static final int MAX_HEIGHT = 300;
    private static final int MIN_WIDTH = 200;
    private static final int MAX_WIDTH = 400;
    private final JTextComponent textComponent;
    private int dotPosition;
    private final JList list;
    private String[] originalData;
    private String[] data;
    private String typed;

    public Popup(JFrame frame, JTextComponent textComponent) {
        super(frame);
        this.textComponent = textComponent;
        this.setSize(200, 200);
        this.list = new JList();
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Popup.this.type(e);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Popup.this.chooseSelected();
                }
            }
        });
        this.list.setBackground(new Color(255, 255, 225));
        this.list.setForeground(Color.BLACK);
        this.getContentPane().add(new JScrollPane(this.list));
        this.list.setSelectedIndex(0);
        this.typed = "";
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Popup.this.typed = "";
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
    }

    public void setMethods(String[] methodList) {
        this.data = methodList;
        this.originalData = methodList;
        this.list.setListData(methodList);
    }

    public void showMethodCompletionList(String[] list, Point displayPoint) {
        Dimension size = this.getPreferredSize();
        this.setLocation(displayPoint);
        this.setBounds(displayPoint.x, displayPoint.y, size.width, size.height);
        this.setMethods(list);
        if (this.textComponent != null) {
            this.dotPosition = this.textComponent.getCaretPosition();
        }
        this.setVisible(true);
        this.list.setSelectedIndex(0);
    }

    public void showPopup(Point displayPoint) {
        Dimension size = this.getPreferredSize();
        this.setLocation(displayPoint);
        this.setBounds(displayPoint.x, displayPoint.y, size.width, size.height);
        if (this.textComponent != null) {
            this.dotPosition = this.textComponent.getCaretPosition();
        }
        this.setVisible(true);
        this.list.setSelectedIndex(0);
    }

    @Override
    public Dimension getPreferredSize() {
        int MAGIC = 20;
        Dimension size = this.list.getPreferredScrollableViewportSize();
        int height = size.height + MAGIC;
        int width = size.width + MAGIC;
        if (height > 300) {
            height = 300;
        }
        if (width > 400) {
            width = 400;
        }
        if (width < 200) {
            width = 200;
        }
        return new Dimension(width, height);
    }

    public synchronized void type(KeyEvent e) {
        if (!this.isVisible()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 27: {
                this.setVisible(false);
                break;
            }
            case 9: 
            case 10: {
                this.chooseSelected();
                e.consume();
                break;
            }
            case 32: {
                this.chooseSelected();
                break;
            }
            case 46: {
                this.chooseSelected();
                break;
            }
            case 519: {
                this.chooseSelected();
                break;
            }
            case 38: {
                this.up();
                e.consume();
                break;
            }
            case 40: {
                this.down();
                e.consume();
                break;
            }
            case 33: {
                this.pageUp();
                e.consume();
                break;
            }
            case 34: {
                this.pageDown();
                e.consume();
                break;
            }
            case 8: {
                if (this.typed.isEmpty()) {
                    this.setVisible(false);
                    break;
                }
                this.typed = this.typed.substring(0, this.typed.length() - 1);
                this.data = this.filter(this.originalData, this.typed);
                this.list.setListData(this.data);
                this.list.setSelectedIndex(0);
                break;
            }
            default: {
                char c = e.getKeyChar();
                if (!Character.isJavaIdentifierPart(c)) break;
                this.typed = this.typed + c;
                this.data = this.filter(this.data, this.typed);
                this.list.setListData(this.data);
                this.list.setSelectedIndex(0);
            }
        }
    }

    private void chooseSelected() {
        Object value = this.list.getSelectedValue();
        if (value != null) {
            int startPosition = this.dotPosition;
            int caretPosition = this.textComponent.getCaretPosition();
            this.textComponent.select(startPosition, caretPosition);
            this.textComponent.replaceSelection(value.toString());
            caretPosition = startPosition + value.toString().length();
            try {
                this.textComponent.setCaretPosition(caretPosition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setVisible(false);
    }

    private void down() {
        int max;
        int index = this.list.getSelectedIndex();
        if (index < (max = this.getListSize() - 1)) {
            this.setSelected(++index);
        } else if (index == max) {
            index = 0;
            this.setSelected(index);
        }
    }

    private void up() {
        int index = this.list.getSelectedIndex();
        if (index == 0) {
            index = this.getListSize() - 1;
            this.setSelected(index);
        } else if (index > 0) {
            this.setSelected(--index);
        }
    }

    private void pageUp() {
        int index = this.list.getSelectedIndex();
        int visibleRows = this.list.getVisibleRowCount();
        index = Math.max(index - visibleRows, 0);
        this.setSelected(index);
    }

    private void pageDown() {
        int index = this.list.getSelectedIndex();
        int visibleRows = this.list.getVisibleRowCount();
        index = Math.min(index + visibleRows, this.getListSize() - 1);
        this.setSelected(index);
    }

    private void setSelected(int index) {
        this.list.setSelectedIndex(index);
        this.list.ensureIndexIsVisible(index);
    }

    private int getListSize() {
        return this.list.getModel().getSize();
    }

    private String[] filter(String[] list, String prefix) {
        prefix = prefix.toLowerCase();
        ArrayList<String> nlist = new ArrayList<String>();
        for (String str : list) {
            if (!str.toLowerCase().startsWith(prefix)) continue;
            nlist.add(str);
        }
        return nlist.toArray(new String[nlist.size()]);
    }
}

