/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.freehep.graphicsio.test.TestingPanel;

public class TestLabels
extends TestingPanel {
    public TestLabels(String[] args) throws Exception {
        super(args);
        this.setName("Labels");
        TestLabels testPanel = this;
        JLabel label1 = new JLabel("TestLabel1");
        testPanel.add(label1);
        JLabel label2 = new JLabel("TestLabel2");
        testPanel.add(label2);
        label2.setBorder(BorderFactory.createEtchedBorder());
        JLabel label3 = new JLabel("TestLabel3");
        testPanel.add(label3);
        label3.setBorder(BorderFactory.createBevelBorder(1));
        SpecialLabel label4 = new SpecialLabel("TestLabel4", "Prefix");
        testPanel.add(label4);
        JButton button1 = new JButton("TestButton1");
        testPanel.add(button1);
        JButton button2 = new JButton("TestButton2");
        testPanel.add(button2);
        button2.setBorder(BorderFactory.createEtchedBorder());
        JButton button3 = new JButton("TestButton3");
        testPanel.add(button3);
        button3.setBorder(BorderFactory.createBevelBorder(1));
    }

    public static void main(String[] args) throws Exception {
        new TestLabels(args).runTest();
    }

    class SpecialLabel
    extends JComponent {
        private String sourceText;
        private JLabel label;
        private JTextField textField;

        public SpecialLabel(String text, String prefix, int align) {
            this.sourceText = text;
            this.setLayout(new BorderLayout());
            this.label = new JLabel(text, align);
            this.label.setForeground(this.getForeground());
            this.add((Component)this.label, "Center");
        }

        public SpecialLabel(String text, String prefix) {
            this(text, prefix, 0);
        }

        void edit() {
            this.textField = new JTextField(this.sourceText);
            this.textField.setFont(this.label.getFont());
            this.textField.setBorder(null);
            this.textField.setHorizontalAlignment(this.label.getHorizontalAlignment());
            this.textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    SpecialLabel.this.finishTextEdit();
                }
            });
            this.textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent fe) {
                    SpecialLabel.this.finishTextEdit();
                }
            });
            this.remove(this.label);
            this.add((Component)this.textField, "Center");
            this.textField.requestFocus();
            this.revalidate();
            this.textField.getCaret().setVisible(true);
        }

        public void mouseEventNotify(MouseEvent me) {
            if (me.getID() == 500 && this.textField == null && me.getClickCount() == 2) {
                this.edit();
            }
        }

        private void finishTextEdit() {
            if (this.textField != null) {
                JTextField text = this.textField;
                this.textField = null;
                this.setText(text.getText());
                this.remove(text);
                this.add((Component)this.label, "Center");
                this.invalidate();
                this.getParent().validate();
                this.repaint();
            }
        }

        @Override
        public Font getFont() {
            return this.label.getFont();
        }

        @Override
        public void setFont(Font f) {
            this.label.setFont(f);
        }

        public String getText() {
            return this.label.getText();
        }

        public void setText(String text) {
            this.sourceText = text;
            this.label.setText(text);
        }
    }
}

