datadir = 'D:/Temp/grib'
st = datetime.datetime(2017,1,1,0)
et = datetime.datetime(2017,1,1,18)
fns = []
while st <= et:
    fn = os.path.join(datadir, 'fnl_' + st.strftime('%Y%m%d_%H') + \
        '_00.grib2')
    print fn
    fns.append(fn)
    st = st + datetime.timedelta(hours=6)

fs = addfiles(fns)
v = fs['v-component_of_wind_tropopause']
data = v[:,::-1,:]
data = mean(data, axis=0)

geoshow('continent')
layer = imshow(data, interpolation='bilinear')
colorbar(layer)
xlim(0, 360)
ylim(-90, 90)
title('Mutiple grid data files example\nMean V (' + st.strftime('%Y-%m-%d %H') + ' - ' + \
    et.strftime('%Y-%m-%d %H') + ')')

#savefig('D:/Temp/figure/addfiles.png', 600, 350, dpi=300)