import time

#Relief data
fn = 'D:/Temp/nc/elev.0.25-deg.nc'
f = addfile(fn)
elev = f['data'][0,'15:65','65:155']
elev[elev<0] = -1
lon = elev.dimvalue(1)
lat = elev.dimvalue(0)
lon, lat = meshgrid(lon, lat)

#Plot
st = time.clock()
lighting(position=[0,0,1,0], ambient=[1,1,1,1])
#lighting(position=[0,0,1,0], mat_specular=[1,1,1,1], ambient=[0.5,0.5,0.5,1])
levs = arange(0, 6000, 200)
cols = makecolors(len(levs) + 1, cmap='MPL_gist_yarg')
surf(lon, lat, elev, 20, colors=cols, facecolor='interp', edgecolor=None)
zlim(0, 20000)
title('Surface 3D plot example')
et = time.clock()
print(et - st)