fn = os.path.join(migl.get_sample_folder(), 'NetCDF', 'cone.nc')
ncf = addfile(fn)
var = ncf['u']
udata = var[4,:,:]
levs = arange(0, 10, 1)
print levs

#Plot
layer = contourf(udata, levs, cmap='BlAqGrYeOrRe')
ls = layer.getLegendScheme()
lb = ls.getLegendBreaks()[-1]
lb.setStyle('+')
lb.setBackColor(miutil.getcolor([220,220,220]))
lb = ls.getLegendBreaks()[1]
lb.setStyle('x')
title('Cone amplitude')
left_title('Left title test')
right_title('right title test')
ylabel('Y')
xlabel('X')
colorbar(layer, label=r'$\mathbf{Label \ Test \ (km^2)}$', \
    tickfont={'name':'Verdana','bold':True,'italic':True}, \
    labelfont={'name':'Arial','size':16,'bold':False}, \
    orientation='vertical', shrink=1, labelloc='top')
print 'Finish.'