/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.layer;

import org.meteoinfo.common.Extent;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.VisibleScale;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;

public abstract class MapLayer
implements Cloneable {
    protected LayerTypes _layerType;
    protected ShapeTypes _shapeType;
    protected int _handle;
    protected String _layerName = "layer";
    protected String _fileName = "";
    protected ProjectionInfo _projInfo;
    protected Extent _extent;
    protected boolean _visible;
    protected LayerDrawType _layerDrawType;
    protected boolean _isMaskout;
    protected LegendScheme legendScheme;
    protected boolean _expanded;
    protected int _transparencyPerc;
    private String _tag;
    private VisibleScale _visibleScale;

    public MapLayer() {
        this._projInfo = KnownCoordinateSystems.geographic.world.WGS1984;
        this._handle = -1;
        this._extent = new Extent();
        this._visible = true;
        this._isMaskout = false;
        this._expanded = false;
        this._transparencyPerc = 0;
        this._layerDrawType = LayerDrawType.MAP;
        this._tag = "";
        this._visibleScale = new VisibleScale();
    }

    public LayerTypes getLayerType() {
        return this._layerType;
    }

    public ShapeTypes getShapeType() {
        return this._shapeType;
    }

    public void setShapeType(ShapeTypes st) {
        this._shapeType = st;
    }

    public LayerDrawType getLayerDrawType() {
        return this._layerDrawType;
    }

    public void setLayerDrawType(LayerDrawType ldt) {
        this._layerDrawType = ldt;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fn) {
        this._fileName = fn;
    }

    public int getHandle() {
        return this._handle;
    }

    public void setHandle(int handle) {
        this._handle = handle;
    }

    public String getLayerName() {
        return this._layerName;
    }

    public void setLayerName(String lName) {
        this._layerName = lName;
    }

    public Extent getExtent() {
        return this._extent;
    }

    public void setExtent(Extent extent) {
        this._extent = extent;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean isTrue) {
        this._visible = isTrue;
    }

    public LegendScheme getLegendScheme() {
        return this.legendScheme;
    }

    public boolean isMaskout() {
        return this._isMaskout;
    }

    public void setMaskout(boolean istrue) {
        this._isMaskout = istrue;
    }

    public void setLegendScheme(LegendScheme ls) {
        this.legendScheme = ls;
    }

    public int getTransparency() {
        return this._transparencyPerc;
    }

    public void setTransparency(int trans) {
        this._transparencyPerc = trans;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void setExpanded(boolean istrue) {
        this._expanded = istrue;
    }

    public ProjectionInfo getProjInfo() {
        return this._projInfo;
    }

    public void setProjInfo(ProjectionInfo projInfo) {
        this._projInfo = projInfo;
    }

    public String getTag() {
        return this._tag;
    }

    public void setTag(String value) {
        this._tag = value;
    }

    public VisibleScale getVisibleScale() {
        return this._visibleScale;
    }

    public void setVisibleScale(VisibleScale value) {
        this._visibleScale = value;
    }

    public boolean hasLegendScheme() {
        return this.legendScheme != null;
    }

    public Object clone() throws CloneNotSupportedException {
        MapLayer aLayer = (MapLayer)super.clone();
        if (this.legendScheme != null) {
            aLayer.legendScheme = (LegendScheme)this.legendScheme.clone();
        }
        return aLayer;
    }

    public String toString() {
        return this.getLayerName();
    }

    public String getLayerInfo() {
        String str = "Layer name: " + this.getLayerName();
        str = str + System.getProperty("line.separator") + "Layer file: " + this.getFileName();
        str = str + System.getProperty("line.separator") + "Layer type: " + (Object)((Object)this.getLayerType());
        str = str + System.getProperty("line.separator") + "Shape type: " + this.getShapeType();
        return str;
    }

    public void saveFile() {
    }

    public void saveFile(String fileName) {
    }
}

