/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.legend;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.meteoinfo.geo.legend.LegendView;
import org.meteoinfo.geometry.legend.ColorBreak;

public class FrmColorSymbolSet
extends JDialog {
    private Object _parent = null;
    private ColorBreak _colorBreak = null;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JLabel jLabel_FillColor;
    private JSpinner jSpinner_TransParency;

    public FrmColorSymbolSet(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public FrmColorSymbolSet(Dialog parent, boolean modal, Object tparent) {
        super(parent, modal);
        this.initComponents();
        this._parent = tparent;
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.jSpinner_TransParency = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jLabel_FillColor = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel5.setText("TransParency:");
        this.jSpinner_TransParency.setModel(new SpinnerNumberModel(0, 0, 100, 10));
        this.jSpinner_TransParency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmColorSymbolSet.this.jSpinner_TransParencyStateChanged(evt);
            }
        });
        this.jLabel1.setText("Fill Color:");
        this.jLabel_FillColor.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_FillColor.setOpaque(true);
        this.jLabel_FillColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmColorSymbolSet.this.jLabel_FillColorMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_FillColor, -2, 59, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_TransParency, -2, 59, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_FillColor, -2, 19, -2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jSpinner_TransParency, -2, -1, -2)).addContainerGap(24, Short.MAX_VALUE)));
        this.pack();
    }

    private void jSpinner_TransParencyStateChanged(ChangeEvent evt) {
        int alpha = Integer.parseInt(this.jSpinner_TransParency.getValue().toString());
        alpha = (int)((1.0 - (double)alpha / 100.0) * 255.0);
        Color c = this._colorBreak.getColor();
        this._colorBreak.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_Color_Transparency(alpha);
        }
    }

    private void jLabel_FillColorMouseClicked(MouseEvent evt) {
        Color c = JColorChooser.showDialog(this.rootPane, null, this.jLabel_FillColor.getBackground());
        int trans = Integer.parseInt(this.jSpinner_TransParency.getValue().toString());
        trans = (int)((1.0 - (double)trans / 100.0) * 255.0);
        Color aColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), trans);
        this.jLabel_FillColor.setBackground(aColor);
        this._colorBreak.setColor(aColor);
        if (this._parent.getClass() == LegendView.class) {
            ((LegendView)this._parent).setLegendBreak_Color(aColor);
        }
    }

    public void setColorBreak(ColorBreak cb) {
        this._colorBreak = cb;
        this.updateProperties();
    }

    private void updateProperties() {
        this.jLabel_FillColor.setBackground(this._colorBreak.getColor());
        int trans = (int)((1.0 - (double)this._colorBreak.getColor().getAlpha() / 255.0) * 100.0);
        this.jSpinner_TransParency.setValue(trans);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmColorSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmColorSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmColorSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmColorSymbolSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmColorSymbolSet dialog = new FrmColorSymbolSet((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

