/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.mapdata;

import com.formdev.flatlaf.extras.FlatSVGUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.mapdata.FrmAddField;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataTable;
import org.meteoinfo.table.DataTableModel;
import org.meteoinfo.table.Field;
import org.meteoinfo.table.MyCellEditor;
import org.meteoinfo.table.RowHeaderTable;

public class FrmAttriData
extends JFrame {
    private VectorLayer _layer;
    private DataTable _dataTable;
    private boolean _isEditing = false;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem_AddField;
    private JMenuItem jMenuItem_RemoveField;
    private JMenuItem jMenuItem_RenameField;
    private JMenuItem jMenuItem_StartEdit;
    private JMenuItem jMenuItem_StopEdit;
    private JMenu jMenu_Edit;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JTable jTable1;

    public FrmAttriData() {
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.setIconImages(FlatSVGUtils.createWindowIconImages((String)"/org/meteoinfo/icons/table.svg"));
        final JTableHeader header = this.jTable1.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isShiftDown()) {
                    FrmAttriData.this.jTable1.clearSelection();
                }
                int pick = header.columnAtPoint(e.getPoint());
                FrmAttriData.this.jTable1.setColumnSelectionAllowed(true);
                FrmAttriData.this.jTable1.setRowSelectionAllowed(false);
                FrmAttriData.this.jTable1.setColumnSelectionInterval(pick, pick);
                if (FrmAttriData.this._isEditing) {
                    FrmAttriData.this.jMenuItem_RemoveField.setEnabled(true);
                    FrmAttriData.this.jMenuItem_RenameField.setEnabled(true);
                }
            }
        });
        this.jTable1.setDefaultEditor(Object.class, (TableCellEditor)new MyCellEditor());
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                FrmAttriData.this.jTable1.clearSelection();
                int pick = FrmAttriData.this.jTable1.rowAtPoint(e.getPoint());
                FrmAttriData.this.jTable1.setColumnSelectionAllowed(false);
                FrmAttriData.this.jTable1.setRowSelectionAllowed(true);
                FrmAttriData.this.jTable1.setRowSelectionInterval(pick, pick);
                if (FrmAttriData.this.jMenuItem_RemoveField.isEnabled()) {
                    FrmAttriData.this.jMenuItem_RemoveField.setEnabled(false);
                }
                if (FrmAttriData.this.jMenuItem_RenameField.isEnabled()) {
                    FrmAttriData.this.jMenuItem_RenameField.setEnabled(false);
                }
            }
        });
        this.jMenuItem_AddField.setEnabled(false);
        this.jMenuItem_RemoveField.setEnabled(false);
        this.jMenuItem_RenameField.setEnabled(false);
        this.jMenuItem_StopEdit.setEnabled(false);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu_Edit = new JMenu();
        this.jMenuItem_StartEdit = new JMenuItem();
        this.jMenuItem_StopEdit = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem_AddField = new JMenuItem();
        this.jMenuItem_RemoveField = new JMenuItem();
        this.jMenuItem_RenameField = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jMenu_Edit.setText("Edit");
        this.jMenuItem_StartEdit.setText("Start Edit");
        this.jMenuItem_StartEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAttriData.this.jMenuItem_StartEditActionPerformed(evt);
            }
        });
        this.jMenu_Edit.add(this.jMenuItem_StartEdit);
        this.jMenuItem_StopEdit.setText("Stop Edit");
        this.jMenuItem_StopEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAttriData.this.jMenuItem_StopEditActionPerformed(evt);
            }
        });
        this.jMenu_Edit.add(this.jMenuItem_StopEdit);
        this.jMenu_Edit.add(this.jSeparator1);
        this.jMenuItem_AddField.setText("Add Field");
        this.jMenuItem_AddField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAttriData.this.jMenuItem_AddFieldActionPerformed(evt);
            }
        });
        this.jMenu_Edit.add(this.jMenuItem_AddField);
        this.jMenuItem_RemoveField.setText("Remove Field");
        this.jMenuItem_RemoveField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAttriData.this.jMenuItem_RemoveFieldActionPerformed(evt);
            }
        });
        this.jMenu_Edit.add(this.jMenuItem_RemoveField);
        this.jMenuItem_RenameField.setText("Rename Field");
        this.jMenuItem_RenameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAttriData.this.jMenuItem_RenameFieldActionPerformed(evt);
            }
        });
        this.jMenu_Edit.add(this.jMenuItem_RenameField);
        this.jMenuBar1.add(this.jMenu_Edit);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 580, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 347, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.pack();
    }

    private void jMenuItem_StartEditActionPerformed(ActionEvent evt) {
        this.jMenuItem_StartEdit.setEnabled(false);
        this.jMenuItem_AddField.setEnabled(true);
        this.jMenuItem_StopEdit.setEnabled(true);
        if (this.jTable1.getSelectedColumnCount() > 0) {
            this.jMenuItem_RemoveField.setEnabled(true);
            this.jMenuItem_RenameField.setEnabled(true);
        }
        this._isEditing = true;
        DataTableModel dataTableModel = new DataTableModel(this._dataTable){

            public boolean isCellEditable(int row, int column) {
                return true;
            }
        };
        this.jTable1.setModel((TableModel)dataTableModel);
    }

    private void jMenuItem_StopEditActionPerformed(ActionEvent evt) {
        this.jMenuItem_StartEdit.setEnabled(true);
        this.jMenuItem_AddField.setEnabled(false);
        this.jMenuItem_RemoveField.setEnabled(false);
        this.jMenuItem_RenameField.setEnabled(false);
        this.jMenuItem_StopEdit.setEnabled(false);
        this._isEditing = false;
        int result = JOptionPane.showConfirmDialog(null, "If save the edition?", "Confirm", 0);
        if (result == 0) {
            this.saveDataTable();
        } else {
            this._dataTable = this._layer.getAttributeTable().getTable().cloneTable_Field();
        }
        DataTableModel dataTableModel = new DataTableModel(this._dataTable){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable1.setModel((TableModel)dataTableModel);
    }

    private void jMenuItem_AddFieldActionPerformed(ActionEvent evt) {
        FrmAddField frmField = new FrmAddField(null, true);
        frmField.setLocationRelativeTo(this);
        frmField.setVisible(true);
        if (frmField.isOK()) {
            String fieldName = frmField.getFieldName();
            if (fieldName.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Field name is empty!");
                return;
            }
            List<String> fieldNames = this._layer.getFieldNames();
            if (fieldNames.contains(fieldName)) {
                JOptionPane.showMessageDialog(null, "Field name has exist in the data table!");
                return;
            }
            DataType dataType = frmField.getDataType();
            try {
                this._dataTable.addColumn((DataColumn)new Field(fieldName, dataType));
                DataTableModel dataTableModel = new DataTableModel(this._dataTable){

                    public boolean isCellEditable(int row, int column) {
                        return true;
                    }
                };
                this.jTable1.setModel((TableModel)dataTableModel);
            }
            catch (Exception ex) {
                Logger.getLogger(FrmAttriData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jMenuItem_RemoveFieldActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedColumnCount() == 0) {
            JOptionPane.showMessageDialog(null, "Please select one field firstly!");
            return;
        }
        int fieldIdx = this.jTable1.getSelectedColumn();
        String fieldName = this.jTable1.getColumnName(fieldIdx);
        int result = JOptionPane.showConfirmDialog(null, "If remove the field: " + fieldName + "?", "Confirm", 0);
        if (result == 0) {
            this._dataTable.removeColumn(this._dataTable.getColumns().get(fieldName));
            DataTableModel dataTableModel = new DataTableModel(this._dataTable){

                public boolean isCellEditable(int row, int column) {
                    return true;
                }
            };
            this.jTable1.setModel((TableModel)dataTableModel);
        }
    }

    private void jMenuItem_RenameFieldActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedColumnCount() == 0) {
            JOptionPane.showMessageDialog(null, "Please select one field firstly!");
            return;
        }
        int fieldIdx = this.jTable1.getSelectedColumn();
        String fieldName = this.jTable1.getColumnName(fieldIdx);
        String result = JOptionPane.showInputDialog(this, "Please input new field name:", fieldName);
        if (result != null) {
            if (result.isEmpty()) {
                JOptionPane.showMessageDialog(null, "The field name is empty!");
                return;
            }
            List fieldNames = this._dataTable.getColumnNames();
            if (fieldNames.contains(result)) {
                JOptionPane.showMessageDialog(null, "The field name is exist!");
                return;
            }
            this._dataTable.renameColumn(this._dataTable.getColumns().get(fieldName), result);
            DataTableModel dataTableModel = new DataTableModel(this._dataTable){

                public boolean isCellEditable(int row, int column) {
                    return true;
                }
            };
            this.jTable1.setModel((TableModel)dataTableModel);
        }
    }

    public void setLayer(VectorLayer aLayer) {
        this._layer = aLayer;
        this._dataTable = this._layer.getAttributeTable().getTable();
        this.setTitle("Attribute Data - " + this._layer.getLayerName());
        DataTableModel dataTableModel = new DataTableModel(this._dataTable);
        this.jTable1.setModel((TableModel)dataTableModel);
        this.jScrollPane1.setRowHeaderView((Component)new RowHeaderTable(this.jTable1, 40));
    }

    private void saveDataTable() {
        this._layer.getAttributeTable().setTable(this._dataTable.cloneTable_Field());
        if (new File(this._layer.getFileName()).exists()) {
            this._layer.getAttributeTable().save();
        } else {
            this._layer.saveFile();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmAttriData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmAttriData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmAttriData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmAttriData.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmAttriData dialog = new FrmAttriData();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

