/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.GroupNode;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.plugin.IApplication;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.table.Field;
import org.meteoinfo.ui.CheckTreeManager;
import org.meteoinfo.ui.CheckTreeSelectionModel;

public class FrmCWT
extends JDialog {
    private IApplication app;
    CheckTreeManager checkTreeManager;
    private JButton jButton_CalCWT;
    private JButton jButton_GetNij;
    private JButton jButton_Weight;
    private JButton jButton_WeightCWT;
    private JComboBox jComboBox_CWTLayer;
    private JComboBox jComboBox_Field;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JTextField jTextField_EndPoint;
    private JTextField jTextField_Missing;
    private JTextField jTextField_ReduceRatio;
    private JTextField jTextField_ReduceRatio_Traj;
    private JTextField jTextField_TrajNum;
    private JTree jTree_TrajLayers;

    public FrmCWT(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (IApplication)parent;
        DefaultMutableTreeNode layersTN = new DefaultMutableTreeNode("Trajectory", true);
        GroupNode gNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        for (LayerNode lNode : gNode.getLayers()) {
            layersTN.insert(new DefaultMutableTreeNode(lNode.getMapLayer()), 0);
        }
        DefaultTreeModel model = new DefaultTreeModel(layersTN);
        this.jTree_TrajLayers.setModel(model);
        this.checkTreeManager = new CheckTreeManager(this.jTree_TrajLayers);
        TreePath path = this.jTree_TrajLayers.getPathForRow(1);
        CheckTreeSelectionModel selModel = this.checkTreeManager.getSelectionModel();
        selModel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FrmCWT.this.onSelectionValueChanged(e);
            }
        });
        selModel.addSelectionPath(path);
        this.getFileds();
        GroupNode pNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("CWT");
        this.jComboBox_CWTLayer.removeAllItems();
        for (LayerNode lNode : pNode.getLayers()) {
            this.jComboBox_CWTLayer.addItem(lNode.getMapLayer());
        }
    }

    private void getFileds() {
        TreePath[] checkedPaths = this.checkTreeManager.getSelectionModel().getSelectionPaths();
        if (checkedPaths == null) {
            return;
        }
        VectorLayer layer = null;
        for (TreePath path : checkedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getChildCount() <= 0) {
                layer = (VectorLayer)node.getUserObject();
                break;
            }
            DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)node.getChildAt(0);
            layer = (VectorLayer)cnode.getUserObject();
        }
        if (layer != null) {
            this.jComboBox_Field.removeAllItems();
            for (Field field : layer.getFields()) {
                if (!field.isNumeric()) continue;
                this.jComboBox_Field.addItem(field.getColumnName());
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox_CWTLayer = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox_Field = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jTextField_Missing = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButton_GetNij = new JButton();
        this.jButton_CalCWT = new JButton();
        this.jButton_WeightCWT = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTree_TrajLayers = new JTree();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextField_EndPoint = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextField_ReduceRatio = new JTextField();
        this.jButton_Weight = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jTextField_TrajNum = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextField_ReduceRatio_Traj = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("CWT Analysis");
        this.jLabel1.setText("CWT Layer:");
        this.jComboBox_CWTLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Field:");
        this.jComboBox_Field.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel4.setText("Missing:");
        this.jTextField_Missing.setText("0");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("PSCF Calculation"));
        this.jButton_GetNij.setText("Get Nij");
        this.jButton_GetNij.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmCWT.this.jButton_GetNijActionPerformed(evt);
            }
        });
        this.jButton_CalCWT.setText("Cal CWT");
        this.jButton_CalCWT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmCWT.this.jButton_CalCWTActionPerformed(evt);
            }
        });
        this.jButton_WeightCWT.setText("Weight CWT");
        this.jButton_WeightCWT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmCWT.this.jButton_WeightCWTActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton_WeightCWT, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton_GetNij, -2, 106, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton_CalCWT, -2, 104, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_GetNij).addComponent(this.jButton_CalCWT)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.jButton_WeightCWT).addContainerGap()));
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("colors");
        DefaultMutableTreeNode treeNode2 = new DefaultMutableTreeNode("blue");
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("violet");
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("red");
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("yellow");
        treeNode1.add(treeNode2);
        this.jTree_TrajLayers.setModel(new DefaultTreeModel(treeNode1));
        this.jScrollPane2.setViewportView(this.jTree_TrajLayers);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Weighting Method"));
        this.jLabel5.setText("End Point:");
        this.jTextField_EndPoint.setText("80;20;10");
        this.jLabel6.setText("Reduce Ratio:");
        this.jTextField_ReduceRatio.setText("0.7;0.42;0.05");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_EndPoint).addComponent(this.jTextField_ReduceRatio, -1, 141, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextField_EndPoint, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextField_ReduceRatio, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_Weight.setText("Weight");
        this.jButton_Weight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmCWT.this.jButton_WeightActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Weight by trajectory number"));
        this.jLabel7.setText("Trajectory:");
        this.jTextField_TrajNum.setText("3;1");
        this.jLabel8.setText("Reduce Ratio:");
        this.jTextField_ReduceRatio_Traj.setText("0.5;0.2");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_TrajNum).addComponent(this.jTextField_ReduceRatio_Traj)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextField_TrajNum, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextField_ReduceRatio_Traj, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 82, -2).addComponent(this.jButton_Weight, -2, 110, -2).addGap(86, 86, 86)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBox_CWTLayer, -2, 164, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Field, -2, 204, -2).addGap(12, 12, 12)).addGroup(layout.createSequentialGroup().addComponent(this.jTextField_Missing, -2, 125, -2).addGap(98, 98, 98).addComponent(this.jScrollPane2, -2, 268, -2).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_CWTLayer, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jComboBox_Field, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextField_Missing, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 126, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton_Weight))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void jButton_GetNijActionPerformed(ActionEvent evt) {
        double missingValue = Double.parseDouble(this.jTextField_Missing.getText());
        this.getEndPointsInCell("Nij", 0.0, missingValue);
    }

    private void jButton_CalCWTActionPerformed(ActionEvent evt) {
        double missingValue = Double.parseDouble(this.jTextField_Missing.getText());
        this.calCWT(missingValue);
    }

    private void calCWT(final double aNData) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                int i;
                VectorLayer CWTLayer = (VectorLayer)FrmCWT.this.jComboBox_CWTLayer.getSelectedItem();
                TreePath[] checkedPaths = FrmCWT.this.checkTreeManager.getSelectionModel().getSelectionPaths();
                if (checkedPaths == null) {
                    JOptionPane.showMessageDialog(null, "There is no trajectory layer was selected!");
                    return "";
                }
                ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
                for (TreePath path : checkedPaths) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getChildCount() > 0) {
                        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                            DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)node.getChildAt(i2);
                            layers.add((VectorLayer)cnode.getUserObject());
                        }
                        continue;
                    }
                    layers.add((VectorLayer)node.getUserObject());
                    break;
                }
                FrmCWT.this.setCursor(Cursor.getPredefinedCursor(3));
                FrmCWT.this.app.getProgressBar().setVisible(true);
                FrmCWT.this.app.getProgressBar().setValue(0);
                FrmCWT.this.app.getProgressBarLabel().setVisible(true);
                FrmCWT.this.app.getProgressBarLabel().setText("...");
                double[] cwts = new double[CWTLayer.getShapeNum()];
                int[] Nijs = new int[CWTLayer.getShapeNum()];
                for (i = 0; i < Nijs.length; ++i) {
                    cwts[i] = 0.0;
                    Nijs[i] = 0;
                }
                String fieldName = FrmCWT.this.jComboBox_Field.getSelectedItem().toString();
                for (VectorLayer tLayer : layers) {
                    FrmCWT.this.app.getProgressBarLabel().setText(tLayer.getLayerName());
                    int dataFldIdx = tLayer.getFieldIdxByName(fieldName);
                    for (i = 0; i < tLayer.getShapeNum(); ++i) {
                        double aData = Double.parseDouble(tLayer.getCellValue(dataFldIdx, i).toString());
                        if (MIMath.doubleEquals((double)aData, (double)aNData)) continue;
                        PolylineZShape aPLZ = (PolylineZShape)tLayer.getShapes().get(i);
                        block5: for (int p = 0; p < aPLZ.getPointNum(); ++p) {
                            PointD aPoint = new PointD(((PointD)aPLZ.getPoints().get((int)p)).X, ((PointD)aPLZ.getPoints().get((int)p)).Y);
                            for (int s = 0; s < CWTLayer.getShapeNum(); ++s) {
                                PolygonShape aPGS = (PolygonShape)CWTLayer.getShapes().get(s);
                                if (!GeoComputation.pointInPolygon((List)aPGS.getPoints(), (PointD)aPoint)) continue;
                                int n = s;
                                cwts[n] = cwts[n] + aData;
                                int n2 = s;
                                Nijs[n2] = Nijs[n2] + 1;
                                continue block5;
                            }
                        }
                        FrmCWT.this.app.getProgressBar().setValue((int)((float)(i + 1) / (float)tLayer.getShapeNum() * 100.0f));
                    }
                }
                for (i = 0; i < CWTLayer.getShapeNum(); ++i) {
                    if (Nijs[i] > 0) {
                        cwts[i] = cwts[i] / (double)Nijs[i];
                    }
                    CWTLayer.editCellValue("CWT", i, (Object)cwts[i]);
                }
                CWTLayer.getAttributeTable().save();
                return "";
            }

            @Override
            protected void done() {
                FrmCWT.this.app.getProgressBar().setVisible(false);
                FrmCWT.this.app.getProgressBarLabel().setVisible(false);
                FrmCWT.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        worker.execute();
    }

    private void jButton_WeightCWTActionPerformed(ActionEvent evt) {
        VectorLayer aLayer = (VectorLayer)this.jComboBox_CWTLayer.getSelectedItem();
        String[] endPoints = this.jTextField_EndPoint.getText().split(";");
        String[] reduceRatios = this.jTextField_ReduceRatio.getText().split(";");
        int epNum = endPoints.length;
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            double cwt;
            int Nij = Integer.parseInt(aLayer.getCellValue("Nij", i).toString());
            double wcwt = cwt = Double.parseDouble(aLayer.getCellValue("CWT", i).toString());
            for (int j = 0; j <= epNum - 1; ++j) {
                if (j == epNum - 1) {
                    if (Nij > Integer.parseInt(endPoints[j])) continue;
                    wcwt = cwt * Double.parseDouble(reduceRatios[j]);
                    continue;
                }
                if (Nij > Integer.parseInt(endPoints[j]) || Nij <= Integer.parseInt(endPoints[j + 1])) continue;
                wcwt = cwt * Double.parseDouble(reduceRatios[j]);
            }
            aLayer.editCellValue("WCWT", i, (Object)wcwt);
        }
        aLayer.getAttributeTable().save();
        aLayer.updateLegendIndexes();
        this.app.getMapView().paintLayers();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton_WeightActionPerformed(ActionEvent evt) {
        VectorLayer aLayer = (VectorLayer)this.jComboBox_CWTLayer.getSelectedItem();
        String[] endPoints = this.jTextField_TrajNum.getText().split(";");
        String[] reduceRatios = this.jTextField_ReduceRatio_Traj.getText().split(";");
        int epNum = endPoints.length;
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            double cwt;
            int tNij = Integer.parseInt(aLayer.getCellValue("N_Traj", i).toString());
            double wcwt = cwt = Double.parseDouble(aLayer.getCellValue("WCWT", i).toString());
            for (int j = 0; j <= epNum - 1; ++j) {
                if (j == epNum - 1) {
                    if (tNij > Integer.parseInt(endPoints[j])) continue;
                    wcwt = cwt * Double.parseDouble(reduceRatios[j]);
                    continue;
                }
                if (tNij > Integer.parseInt(endPoints[j]) || tNij <= Integer.parseInt(endPoints[j + 1])) continue;
                wcwt = cwt * Double.parseDouble(reduceRatios[j]);
            }
            aLayer.editCellValue("WCWT", i, (Object)wcwt);
        }
        aLayer.getAttributeTable().save();
        aLayer.updateLegendIndexes();
        this.app.getMapView().paintLayers();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void getEndPointsInCell(final String aType, final double aCriterion, final double aNData) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                int i;
                VectorLayer PSCFLayer = (VectorLayer)FrmCWT.this.jComboBox_CWTLayer.getSelectedItem();
                TreePath[] checkedPaths = FrmCWT.this.checkTreeManager.getSelectionModel().getSelectionPaths();
                if (checkedPaths == null) {
                    JOptionPane.showMessageDialog(null, "There is no trajectory layer was selected!");
                    return "";
                }
                ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
                for (TreePath path : checkedPaths) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getChildCount() > 0) {
                        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                            DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)node.getChildAt(i2);
                            layers.add((VectorLayer)cnode.getUserObject());
                        }
                        continue;
                    }
                    layers.add((VectorLayer)node.getUserObject());
                    break;
                }
                FrmCWT.this.setCursor(Cursor.getPredefinedCursor(3));
                FrmCWT.this.app.getProgressBar().setVisible(true);
                FrmCWT.this.app.getProgressBar().setValue(0);
                FrmCWT.this.app.getProgressBarLabel().setVisible(true);
                FrmCWT.this.app.getProgressBarLabel().setText("...");
                boolean usingCriterion = false;
                if (aType.equals("Mij")) {
                    usingCriterion = true;
                }
                int[] Nijs = new int[PSCFLayer.getShapeNum()];
                int[] TNijs = new int[PSCFLayer.getShapeNum()];
                for (i = 0; i < Nijs.length; ++i) {
                    Nijs[i] = 0;
                    TNijs[i] = 0;
                }
                ArrayList<Integer> cellIdx = new ArrayList<Integer>();
                String fieldName = FrmCWT.this.jComboBox_Field.getSelectedItem().toString();
                for (VectorLayer tLayer : layers) {
                    FrmCWT.this.app.getProgressBarLabel().setText(tLayer.getLayerName());
                    int dataFldIdx = tLayer.getFieldIdxByName(fieldName);
                    for (i = 0; i < tLayer.getShapeNum(); ++i) {
                        double value = Double.parseDouble(tLayer.getCellValue(dataFldIdx, i).toString());
                        if (MIMath.doubleEquals((double)value, (double)aNData) || usingCriterion && value < aCriterion) continue;
                        cellIdx.clear();
                        PolylineZShape aPLZ = (PolylineZShape)tLayer.getShapes().get(i);
                        block5: for (int p = 0; p < aPLZ.getPointNum(); ++p) {
                            PointD aPoint = new PointD(((PointD)aPLZ.getPoints().get((int)p)).X, ((PointD)aPLZ.getPoints().get((int)p)).Y);
                            for (int s = 0; s < PSCFLayer.getShapeNum(); ++s) {
                                PolygonShape aPGS = (PolygonShape)PSCFLayer.getShapes().get(s);
                                if (!GeoComputation.pointInPolygon((List)aPGS.getPoints(), (PointD)aPoint)) continue;
                                int n = s;
                                Nijs[n] = Nijs[n] + 1;
                                if (cellIdx.contains(s)) continue block5;
                                int n2 = s;
                                TNijs[n2] = TNijs[n2] + 1;
                                cellIdx.add(s);
                                continue block5;
                            }
                        }
                        FrmCWT.this.app.getProgressBar().setValue((int)((float)(i + 1) / (float)tLayer.getShapeNum() * 100.0f));
                    }
                }
                for (i = 0; i < PSCFLayer.getShapeNum(); ++i) {
                    PSCFLayer.editCellValue(aType, i, (Object)Nijs[i]);
                    if (usingCriterion) continue;
                    PSCFLayer.editCellValue("N_Traj", i, (Object)TNijs[i]);
                }
                PSCFLayer.getAttributeTable().save();
                return "";
            }

            @Override
            protected void done() {
                FrmCWT.this.app.getProgressBar().setVisible(false);
                FrmCWT.this.app.getProgressBarLabel().setVisible(false);
                FrmCWT.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        worker.execute();
    }

    private void onSelectionValueChanged(TreeSelectionEvent evt) {
        this.getFileds();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmCWT.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmCWT.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmCWT.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmCWT.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmCWT dialog = new FrmCWT((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

