/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.trajectory;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.common.util.JDateUtil;
import org.meteothink.trajstat.trajectory.TrajControl;
import org.meteothink.trajstat.trajectory.TrajUtil;

public class TrajConfig
extends TrajControl {
    private List<Integer> _startHours = new ArrayList<Integer>();
    private int _startDay = 1;
    private int _endDay = 30;
    private String _trajExcuteFileName;

    public TrajConfig() {
        this._startHours.add(6);
        String pluginDir = GlobalUtil.getAppPath(TrajUtil.class);
        String workDir = pluginDir + File.separator + "working";
        this._trajExcuteFileName = workDir + File.separator + "hyts_std.exe";
    }

    public List<Integer> getStartHours() {
        return this._startHours;
    }

    public void setStartHours(List<Integer> value) {
        this._startHours = value;
    }

    public int getStartDay() {
        return this._startDay;
    }

    public void setStartDay(int value) {
        this._startDay = value;
    }

    public int getEndDay() {
        return this._endDay;
    }

    public void setEndDay(int value) {
        this._endDay = value;
    }

    public String getTrajExcuteFileName() {
        return this._trajExcuteFileName;
    }

    public void setTrajExcuteFileName(String value) {
        this._trajExcuteFileName = value;
    }

    public String getStartHoursString() {
        String str = "";
        for (int hour : this._startHours) {
            str = str + " " + String.format("%1$2d", hour);
        }
        str = str.trim();
        return str;
    }

    public void setStartHours(String value) {
        String[] strs = value.trim().split("\\s+");
        this._startHours.clear();
        for (String str : strs) {
            this._startHours.add(Integer.parseInt(str));
        }
    }

    public void upateStartEndDays() {
        this._startDay = 1;
        this._endDay = JDateUtil.getDaysOfMonth((int)this.getStartTime().getYear(), (int)this.getStartTime().getMonthValue());
    }

    @Override
    public void loadControlFile(String fileName) {
        super.loadControlFile(fileName);
        this._startHours = new ArrayList<Integer>();
        this._startHours.add(this.getStartTime().getHour());
        this.upateStartEndDays();
    }

    public int getStartHoursNum() {
        return this._startHours.size();
    }

    public int getDayNum() {
        return this._endDay - this._startDay + 1;
    }

    public int getTimeNum() {
        return this.getDayNum() * this.getStartHoursNum();
    }

    public void upateStartTime(int dayIdx, int hourIdx) {
        LocalDateTime dt = this.getStartTime();
        dt = dt.withDayOfMonth(this._startDay + dayIdx);
        dt = dt.withHour(this._startHours.get(hourIdx));
        this.setStartTime(dt);
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyMMddHH");
        this.setTrajFileName(format.format(dt));
    }

    public void initStartTime(int year, int month) {
        LocalDateTime dt = LocalDateTime.of(year, month, this._startDay, (int)this._startHours.get(0), 0, 0);
        this.setStartTime(dt);
    }
}

