/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.trajectory;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.geo.analysis.DistanceType;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.Field;
import org.meteothink.trajstat.trajectory.TrajConfig;

public class TrajUtil {
    public static void trajCal(TrajConfig trajConfig) throws IOException, InterruptedException {
        String pluginDir = GlobalUtil.getAppPath(TrajUtil.class);
        String workDir = pluginDir + File.separator + "working";
        String cfn = workDir + File.separator + "CONTROL";
        int dayNum = trajConfig.getDayNum();
        int hourNum = trajConfig.getStartHoursNum();
        for (int i = 0; i < dayNum; ++i) {
            for (int j = 0; j < hourNum; ++j) {
                String s;
                trajConfig.upateStartTime(i, j);
                trajConfig.saveControlFile(cfn);
                ProcessBuilder pb = new ProcessBuilder(trajConfig.getTrajExcuteFileName());
                pb.directory(new File(workDir));
                Process process = pb.start();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((s = bufferedReader.readLine()) != null) {
                    System.out.println(s);
                }
                process.waitFor();
            }
        }
    }

    public static void trajToTGS(String trajfn, String tgsfn) throws IOException {
        int n;
        int m;
        if (!new File(trajfn).exists()) {
            return;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(tgsfn)));
        bw.write("start_year,start_month,start_day,start_hour,year,month,day,hour,age_hour,latitude,longitude,height,press");
        bw.newLine();
        BufferedReader sr = new BufferedReader(new FileReader(new File(trajfn)));
        String aLine = sr.readLine().trim();
        String[] dataArray = aLine.split("\\s+");
        int meteoFileNum = Integer.parseInt(dataArray[0]);
        for (m = 0; m < meteoFileNum; ++m) {
            sr.readLine();
        }
        aLine = sr.readLine().trim();
        dataArray = aLine.split("\\s+");
        int trajNum = Integer.parseInt(dataArray[0]);
        String[] sDates = new String[trajNum];
        for (m = 0; m < trajNum; ++m) {
            aLine = sr.readLine().trim();
            dataArray = aLine.split("\\s+");
            aLine = "";
            for (n = 0; n <= 3; ++n) {
                if (dataArray[n].length() < 2) {
                    dataArray[n] = "0" + dataArray[n];
                }
                aLine = aLine + dataArray[n] + ",";
            }
            sDates[m] = aLine;
        }
        sr.readLine();
        ArrayList[] trajLines = new ArrayList[trajNum];
        for (m = 0; m < trajLines.length; ++m) {
            trajLines[m] = new ArrayList();
        }
        while ((aLine = sr.readLine()) != null) {
            if (aLine.isEmpty()) continue;
            dataArray = aLine.trim().split("\\s+");
            if (dataArray.length < 13) {
                JOptionPane.showMessageDialog(null, "Wrong file format! Please Check!" + System.getProperty("line.separator") + "Line: " + aLine);
                sr.close();
                if (new File(tgsfn).exists()) {
                    new File(tgsfn).delete();
                }
                return;
            }
            int id = Integer.parseInt(dataArray[0]);
            String wYear = dataArray[2];
            String wMonth = dataArray[3];
            String wDay = dataArray[4];
            String wHour = dataArray[5];
            String ageHour = dataArray[8];
            String lat = dataArray[9];
            String lon = dataArray[10];
            String Height = dataArray[11];
            String press = dataArray[12];
            aLine = sDates[id - 1] + wYear + "," + wMonth + "," + wDay + "," + wHour + "," + ageHour + "," + lat + "," + lon + "," + Height + "," + press;
            trajLines[id - 1].add(aLine);
        }
        sr.close();
        for (m = 0; m < trajNum; ++m) {
            for (n = 0; n < trajLines[m].size(); ++n) {
                bw.write((String)trajLines[m].get(n));
                bw.newLine();
            }
        }
        bw.close();
    }

    public static void trajToTGS(List<String> trajfns, String tgsfn) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(tgsfn)));
        bw.write("start_year,start_month,start_day,start_hour,year,month,day,hour,age_hour,latitude,longitude,height,press");
        bw.newLine();
        for (String trajfn : trajfns) {
            int n;
            int m;
            if (!new File(trajfn).exists()) continue;
            BufferedReader sr = new BufferedReader(new FileReader(new File(trajfn)));
            String aLine = sr.readLine().trim();
            String[] dataArray = aLine.split("\\s+");
            int meteoFileNum = Integer.parseInt(dataArray[0]);
            for (m = 0; m < meteoFileNum; ++m) {
                sr.readLine();
            }
            aLine = sr.readLine().trim();
            dataArray = aLine.split("\\s+");
            int trajNum = Integer.parseInt(dataArray[0]);
            String[] sDates = new String[trajNum];
            for (m = 0; m < trajNum; ++m) {
                aLine = sr.readLine().trim();
                dataArray = aLine.split("\\s+");
                aLine = "";
                for (n = 0; n <= 3; ++n) {
                    if (dataArray[n].length() < 2) {
                        dataArray[n] = "0" + dataArray[n];
                    }
                    aLine = aLine + dataArray[n] + ",";
                }
                sDates[m] = aLine;
            }
            sr.readLine();
            ArrayList[] trajLines = new ArrayList[trajNum];
            for (m = 0; m < trajLines.length; ++m) {
                trajLines[m] = new ArrayList();
            }
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                dataArray = aLine.trim().split("\\s+");
                if (dataArray.length < 13) {
                    JOptionPane.showMessageDialog(null, "Wrong file format! Please Check!" + System.getProperty("line.separator") + "Line: " + aLine);
                    sr.close();
                    if (new File(tgsfn).exists()) {
                        new File(tgsfn).delete();
                    }
                    return;
                }
                int id = Integer.parseInt(dataArray[0]);
                String wYear = dataArray[2];
                String wMonth = dataArray[3];
                String wDay = dataArray[4];
                String wHour = dataArray[5];
                String ageHour = dataArray[8];
                String lat = dataArray[9];
                String lon = dataArray[10];
                String Height = dataArray[11];
                String press = dataArray[12];
                aLine = sDates[id - 1] + wYear + "," + wMonth + "," + wDay + "," + wHour + "," + ageHour + "," + lat + "," + lon + "," + Height + "," + press;
                trajLines[id - 1].add(aLine);
            }
            sr.close();
            for (m = 0; m < trajNum; ++m) {
                for (n = 0; n < trajLines[m].size(); ++n) {
                    bw.write((String)trajLines[m].get(n));
                    bw.newLine();
                }
            }
        }
        bw.close();
    }

    public static void trajToTGS(TrajConfig trajConfig) throws IOException {
        int dayNum = trajConfig.getDayNum();
        int hourNum = trajConfig.getStartHoursNum();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
        for (int i = 0; i < dayNum; ++i) {
            trajConfig.upateStartTime(i, 0);
            String tgsfn = trajConfig.getOutPath() + format.format(trajConfig.getStartTime()) + ".tgs";
            ArrayList<String> trajfns = new ArrayList<String>();
            for (int j = 0; j < hourNum; ++j) {
                trajConfig.upateStartTime(i, j);
                String trajfn = trajConfig.getOutPath() + trajConfig.getTrajFileName();
                trajfns.add(trajfn);
            }
            TrajUtil.trajToTGS(trajfns, tgsfn);
        }
    }

    public static String joinTGSFiles(TrajConfig trajConfig) throws IOException {
        int dayNum = trajConfig.getDayNum();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMM");
        String monthfn = trajConfig.getOutPath() + format.format(trajConfig.getStartTime()) + ".tgs";
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(monthfn)));
        bw.write("start_year,start_month,start_day,start_hour,year,month,day,hour,age_hour,latitude,longitude,height,press");
        bw.newLine();
        format = DateTimeFormatter.ofPattern("yyyyMMdd");
        for (int i = 0; i < dayNum; ++i) {
            trajConfig.upateStartTime(i, 0);
            String tgsfn = trajConfig.getOutPath() + format.format(trajConfig.getStartTime()) + ".tgs";
            if (!new File(tgsfn).exists()) continue;
            BufferedReader sr = new BufferedReader(new FileReader(new File(tgsfn)));
            sr.readLine();
            String aLine = sr.readLine();
            while (aLine != null) {
                if (aLine.isEmpty()) {
                    aLine = sr.readLine();
                }
                bw.write(aLine);
                bw.newLine();
                aLine = sr.readLine();
            }
            sr.close();
        }
        bw.close();
        return monthfn;
    }

    public static void joinTGSFiles(List<String> tgsfns, String joinedfn) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(joinedfn)));
        bw.write("start_year,start_month,start_day,start_hour,year,month,day,hour,age_hour,latitude,longitude,height,press");
        bw.newLine();
        for (int i = 0; i < tgsfns.size(); ++i) {
            String tgsfn = tgsfns.get(i);
            if (!new File(tgsfn).exists()) continue;
            BufferedReader sr = new BufferedReader(new FileReader(new File(tgsfn)));
            sr.readLine();
            String aLine = sr.readLine();
            while (aLine != null) {
                if (aLine.isEmpty()) {
                    aLine = sr.readLine();
                }
                bw.write(aLine);
                bw.newLine();
                aLine = sr.readLine();
            }
            sr.close();
        }
        bw.close();
    }

    public static VectorLayer convertToShapeFile(String tgsFile, String shpFile) throws FileNotFoundException, IOException, Exception {
        String aLine;
        LocalDateTime sDate = LocalDateTime.now();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH");
        float height = 0.0f;
        BufferedReader sr = new BufferedReader(new FileReader(new File(tgsFile)));
        sr.readLine();
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE_Z);
        aLayer.editAddField("ID", DataType.INT);
        aLayer.editAddField("Date", DataType.DATE);
        aLayer.editAddField("Year", DataType.INT);
        aLayer.editAddField("Month", DataType.INT);
        aLayer.editAddField("Day", DataType.INT);
        aLayer.editAddField("Hour", DataType.INT);
        aLayer.editAddField("Height", DataType.FLOAT);
        int i = 0;
        ArrayList<PointZ> pList = new ArrayList<PointZ>();
        while ((aLine = sr.readLine()) != null) {
            String[] lineArray = aLine.split(",");
            if (lineArray.length < 13) continue;
            String sYear = lineArray[0];
            sYear = Integer.parseInt(sYear) < 40 ? "20" + sYear : "19" + sYear;
            String ageHour = lineArray[8];
            float lat = Float.parseFloat(lineArray[9]);
            float lon = Float.parseFloat(lineArray[10]);
            float alt = Float.parseFloat(lineArray[11]);
            float press = Float.parseFloat(lineArray[12]);
            if (ageHour.equals("0.0")) {
                if (i > 0 && pList.size() > 1) {
                    PolylineZShape aPolylineZ = new PolylineZShape();
                    aPolylineZ.setPoints(pList);
                    aPolylineZ.setValue(0.0);
                    aPolylineZ.setExtent(GeometryUtil.getPointsExtent(pList));
                    int shapeNum = aLayer.getShapeNum();
                    if (aLayer.editInsertShape((Shape)aPolylineZ, shapeNum)) {
                        aLayer.editCellValue("ID", shapeNum, (Object)(shapeNum + 1));
                        aLayer.editCellValue("Date", shapeNum, (Object)sDate);
                        aLayer.editCellValue("Year", shapeNum, (Object)sDate.getYear());
                        aLayer.editCellValue("Month", shapeNum, (Object)sDate.getMonthValue());
                        aLayer.editCellValue("Day", shapeNum, (Object)sDate.getDayOfMonth());
                        aLayer.editCellValue("Hour", shapeNum, (Object)sDate.getHour());
                        aLayer.editCellValue("Height", shapeNum, (Object)Float.valueOf(height));
                    }
                }
                String sMonth = lineArray[1];
                String sDay = lineArray[2];
                String sHour = lineArray[3];
                height = Float.parseFloat(lineArray[11]);
                sDate = LocalDateTime.parse(sYear + "-" + sMonth + "-" + sDay + " " + sHour, format);
                pList = new ArrayList();
            }
            PointZ aPoint = new PointZ();
            aPoint.X = lon;
            aPoint.Y = lat;
            aPoint.Z = alt;
            aPoint.M = press;
            if (pList.size() > 1) {
                PointZ oldPoint = (PointZ)pList.get(pList.size() - 1);
                if (Math.abs(aPoint.X - oldPoint.X) > 100.0) {
                    aPoint.X = aPoint.X > oldPoint.X ? (aPoint.X -= 360.0) : (aPoint.X += 360.0);
                }
            }
            pList.add(aPoint);
            ++i;
        }
        sr.close();
        if (i > 1 && pList.size() > 0) {
            PolylineZShape aPolylineZ = new PolylineZShape();
            aPolylineZ.setPoints(pList);
            aPolylineZ.setValue(0.0);
            aPolylineZ.setExtent(GeometryUtil.getPointsExtent(pList));
            int shapeNum = aLayer.getShapeNum();
            if (aLayer.editInsertShape((Shape)aPolylineZ, shapeNum)) {
                aLayer.editCellValue("ID", shapeNum, (Object)(shapeNum + 1));
                aLayer.editCellValue("Date", shapeNum, (Object)sDate);
                aLayer.editCellValue("Year", shapeNum, (Object)sDate.getYear());
                aLayer.editCellValue("Month", shapeNum, (Object)sDate.getMonthValue());
                aLayer.editCellValue("Day", shapeNum, (Object)sDate.getDayOfMonth());
                aLayer.editCellValue("Hour", shapeNum, (Object)sDate.getHour());
                aLayer.editCellValue("Height", shapeNum, (Object)Float.valueOf(height));
            }
        }
        if (aLayer.getShapeNum() > 0) {
            aLayer.setLayerName(new File(shpFile).getName());
            LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYLINE, (Color)Color.black, (float)1.0f);
            aLS.setFieldName("Year");
            aLayer.setLegendScheme(aLS);
            aLayer.setLayerDrawType(LayerDrawType.TRAJECTORY_LINE);
            aLayer.setFileName(shpFile);
            aLayer.saveFile(shpFile);
            return aLayer;
        }
        return null;
    }

    public static void removeTrajFiles(TrajConfig trajConfig) {
        int dayNum = trajConfig.getDayNum();
        int hourNum = trajConfig.getStartHoursNum();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
        for (int i = 0; i < dayNum; ++i) {
            trajConfig.upateStartTime(i, 0);
            String tgsfn = trajConfig.getOutPath() + format.format(trajConfig.getStartTime()) + ".tgs";
            File tgsf = new File(tgsfn);
            if (tgsf.exists()) {
                tgsf.delete();
            }
            for (int j = 0; j < hourNum; ++j) {
                trajConfig.upateStartTime(i, j);
                String trajfn = trajConfig.getOutPath() + trajConfig.getTrajFileName();
                File trajf = new File(trajfn);
                if (!trajf.exists()) continue;
                trajf.delete();
            }
        }
    }

    public static double[][] calMeanTrajs(List<Integer> clusters, int CLev, int pointNum, List<VectorLayer> layers) {
        int j;
        int i;
        int M = pointNum * 3;
        double[][] trajDataArray = new double[CLev][M];
        int[] trajNumArray = new int[CLev];
        for (i = 0; i < CLev; ++i) {
            trajNumArray[i] = 0;
            for (j = 0; j < M; ++j) {
                trajDataArray[i][j] = 0.0;
            }
        }
        i = 0;
        for (VectorLayer layer : layers) {
            for (int s = 0; s < layer.getShapeNum(); ++s) {
                PolylineZShape shape = (PolylineZShape)layer.getShapes().get(s);
                if (shape.getPointNum() != pointNum) continue;
                int cluster = clusters.get(i);
                int m = 0;
                for (j = 0; j < pointNum; ++j) {
                    PointZ point = (PointZ)shape.getPoints().get(j);
                    double[] dArray = trajDataArray[cluster - 1];
                    int n = m++;
                    dArray[n] = dArray[n] + point.Y;
                    double[] dArray2 = trajDataArray[cluster - 1];
                    int n2 = m++;
                    dArray2[n2] = dArray2[n2] + point.X;
                    double[] dArray3 = trajDataArray[cluster - 1];
                    int n3 = m++;
                    dArray3[n3] = dArray3[n3] + point.Z;
                }
                int n = cluster - 1;
                trajNumArray[n] = trajNumArray[n] + 1;
                ++i;
            }
        }
        for (i = 0; i < CLev; ++i) {
            for (j = 0; j < M; ++j) {
                trajDataArray[i][j] = trajDataArray[i][j] / (double)trajNumArray[i];
            }
        }
        return trajDataArray;
    }

    public static double calTSV(List<Integer> clusters, int CLev, int pointNum, List<VectorLayer> layers, DistanceType disType) throws IOException {
        double[][] trajDataArray = TrajUtil.calMeanTrajs(clusters, CLev, pointNum, layers);
        double tsv = 0.0;
        int i = 0;
        for (VectorLayer layer : layers) {
            for (int s = 0; s < layer.getShapeNum(); ++s) {
                PolylineZShape shape = (PolylineZShape)layer.getShapes().get(s);
                if (shape.getPointNum() != pointNum) continue;
                int cluster = clusters.get(i);
                int m = 0;
                PointD[] trajA = new PointD[pointNum];
                PointD[] trajB = new PointD[pointNum];
                for (int j = 0; j < pointNum; ++j) {
                    PointZ point = (PointZ)shape.getPoints().get(j);
                    trajA[j] = new PointD(point.X, point.Y);
                    double y = trajDataArray[cluster - 1][m];
                    double x = trajDataArray[cluster - 1][++m];
                    m += 2;
                    trajB[j] = new PointD(x, y);
                }
                double dist = disType == DistanceType.EUCLIDEAN ? TrajUtil.calDistance_Euclidean(trajA, trajB) : TrajUtil.calDistance_Angle(trajA, trajB);
                tsv += dist;
                ++i;
            }
        }
        return tsv;
    }

    public static double calDistance_Euclidean(PointD[] trajA, PointD[] trajB) {
        double dist = 0.0;
        int n = trajA.length;
        for (int j = 0; j < n; ++j) {
            PointD pA = trajA[j];
            PointD pB = trajB[j];
            dist += (pA.X - pB.X) * (pA.X - pB.X) + (pA.Y - pB.Y) * (pA.Y - pB.Y);
        }
        dist = Math.sqrt(dist);
        return dist;
    }

    public static double calDistance_Angle(PointD[] trajA, PointD[] trajB) {
        double dist = 0.0;
        int n = trajA.length;
        double X0 = trajA[0].X;
        double Y0 = trajB[0].Y;
        for (int j = 1; j < n; ++j) {
            PointD pA = trajA[j];
            PointD pB = trajB[j];
            double A = Math.pow(pA.X - X0, 2.0) + Math.pow(pA.Y - Y0, 2.0);
            double B = Math.pow(pB.X - X0, 2.0) + Math.pow(pB.Y - Y0, 2.0);
            double C = Math.pow(pB.X - pA.X, 2.0) + Math.pow(pB.Y - pA.Y, 2.0);
            double angle = A == 0.0 | B == 0.0 ? 0.0 : 0.5 * (A + B - C) / Math.sqrt(A * B);
            if (Math.abs(angle) > 1.0) {
                angle = 1.0;
            }
            dist += Math.acos(angle);
        }
        return dist /= (double)n;
    }

    public static int getTimeZone(String timeZoneStr) {
        String str = (timeZoneStr = timeZoneStr.trim()).substring(3);
        if (str.charAt(0) == '+') {
            str = str.substring(1);
        }
        int tz = Integer.parseInt(str);
        return tz;
    }

    public static void addDataToTraj(File dataFile, int sDateFldIdx, String formatStr, int timeZone, int dataFldIdx, double undef, List<VectorLayer> layers, String fldName, DataType dataType, int fLen, int fDec) throws IOException {
        DateTimeFormatter format = DateTimeFormatter.ofPattern(formatStr);
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        BufferedReader sr = new BufferedReader(new FileReader(dataFile));
        sr.readLine();
        String aDataStr = sr.readLine();
        while (aDataStr != null) {
            String[] aDataArray = aDataStr.split(",");
            if (aDataArray.length > Math.max(sDateFldIdx, dataFldIdx)) {
                String[] theData = new String[]{aDataArray[sDateFldIdx], aDataArray[dataFldIdx]};
                dataList.add(theData);
            }
            aDataStr = sr.readLine();
        }
        sr.close();
        int N = dataList.size();
        for (VectorLayer layer : layers) {
            int j;
            String aDateStr;
            LocalDateTime dt;
            int i;
            int CFldIdx = layer.getFieldIdxByName(fldName);
            if (CFldIdx == -1) {
                Field fld = new Field(fldName, dataType, fLen, fDec);
                layer.editAddField(fld);
                CFldIdx = layer.getFieldNumber() - 1;
            }
            int sNum = layer.getShapeNum();
            int dateIdx = layer.getFieldIdxByName("Date");
            if (dateIdx > -1) {
                block10: for (i = 0; i < sNum; ++i) {
                    dt = (LocalDateTime)layer.getCellValue("Date", i);
                    int hour = Integer.parseInt(layer.getCellValue("Hour", i).toString());
                    dt = dt.withHour(hour);
                    dt = dt.plusHours(timeZone);
                    aDateStr = format.format(dt);
                    Object value = undef;
                    switch (dataType) {
                        case INT: {
                            value = (int)undef;
                            break;
                        }
                        case STRING: {
                            value = "Null";
                        }
                    }
                    layer.editCellValue(CFldIdx, i, value);
                    for (j = 0; j < N; ++j) {
                        int tlen = ((String[])dataList.get(j))[0].length();
                        String dstr = tlen <= aDateStr.length() ? aDateStr.substring(0, tlen) : aDateStr;
                        if (!dstr.equals(((String[])dataList.get(j))[0])) continue;
                        String dStr = ((String[])dataList.get(j))[1];
                        value = dStr;
                        switch (dataType) {
                            case INT: {
                                if (dStr.isEmpty()) {
                                    value = (int)undef;
                                    break;
                                }
                                value = Integer.parseInt(dStr);
                                break;
                            }
                            case DOUBLE: {
                                value = dStr.isEmpty() ? Double.valueOf(undef) : Double.valueOf(Double.parseDouble(dStr));
                            }
                        }
                        layer.editCellValue(CFldIdx, i, value);
                        continue block10;
                    }
                }
            } else {
                block12: for (i = 0; i < sNum; ++i) {
                    int aYear = Integer.parseInt(layer.getCellValue("Year", i).toString());
                    int aMonth = Integer.parseInt(layer.getCellValue("Month", i).toString());
                    int aDay = Integer.parseInt(layer.getCellValue("Day", i).toString());
                    int aHour = Integer.parseInt(layer.getCellValue("Hour", i).toString());
                    dt = LocalDateTime.of(aYear, aMonth, dateIdx, aDay, aHour);
                    dt = dt.plusHours(timeZone);
                    aDateStr = format.format(dt);
                    for (j = 0; j <= N - 1; ++j) {
                        int tlen = ((String[])dataList.get(j))[0].length();
                        String dstr = tlen <= aDateStr.length() ? aDateStr.substring(0, tlen) : aDateStr;
                        if (!dstr.equals(((String[])dataList.get(j))[0])) continue;
                        layer.editCellValue(CFldIdx, i, (Object)((String[])dataList.get(j))[1]);
                        continue block12;
                    }
                }
            }
            layer.getAttributeTable().save();
        }
    }
}

