/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grads;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.grads.GradsAttribute;
import ucar.nc2.iosp.grads.GradsDataDescriptorFile;
import ucar.nc2.iosp.grads.GradsDimension;
import ucar.nc2.iosp.grads.GradsEnsembleDimension;
import ucar.nc2.iosp.grads.GradsTimeDimension;
import ucar.nc2.iosp.grads.GradsVariable;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class GradsBinaryGridServiceProvider
extends AbstractIOServiceProvider {
    protected GradsDataDescriptorFile gradsDDF;
    private RandomAccessFile dataFile;
    private NetcdfFile ncFile;
    private int sizeX;
    private int sizeY;
    private int xyHeaderBytes;
    private int sequentialRecordBytes;
    private int fileHeaderBytes;
    private int timeHeaderBytes;
    private int timeTrailerBytes;
    private static final String ENS_VAR = "ensemble";
    private static final String TIME_VAR = "time";
    private static final String Z_VAR = "level";
    private static final String Y_VAR = "latitude";
    private static final String X_VAR = "longitude";
    private String[] dimNames = new String[]{"EDEF", "TDEF", "ZDEF", "YDEF", "XDEF"};
    private String[] dimVarNames = new String[]{"ensemble", "time", "level", "latitude", "longitude"};
    private int wordSize = 4;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        if (GradsDataDescriptorFile.failFast(raf)) {
            return false;
        }
        raf.seek(0L);
        try {
            this.gradsDDF = new GradsDataDescriptorFile(raf.getLocation(), 5000);
            if (this.gradsDDF.error) {
                return false;
            }
            GradsDimension x = this.gradsDDF.getXDimension();
            GradsDimension y = this.gradsDDF.getYDimension();
            return this.gradsDDF.getDataType() == null && this.gradsDDF.getDataFile() != null && !this.gradsDDF.hasProjection() && !this.gradsDDF.getVariables().isEmpty() && !this.gradsDDF.getDimensions().isEmpty() && x.getSize() > 1 && y.getSize() > 1;
        }
        catch (Exception ioe) {
            return false;
        }
    }

    public String getFileTypeId() {
        return "GradsBinaryGrid";
    }

    public String getFileTypeDescription() {
        return "GrADS Binary Gridded Data";
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.ncFile = ncfile;
        if (this.gradsDDF == null) {
            this.gradsDDF = new GradsDataDescriptorFile(raf.getLocation(), 1000);
        }
        this.xyHeaderBytes = this.gradsDDF.getXYHeaderBytes();
        this.fileHeaderBytes = this.gradsDDF.getFileHeaderBytes();
        this.timeHeaderBytes = this.gradsDDF.getTimeHeaderBytes();
        this.timeTrailerBytes = this.gradsDDF.getTimeTrailerBytes();
        this.dataFile = this.getDataFile(0, 0);
        this.dataFile.order(this.getByteOrder());
        if (this.gradsDDF.isSequential()) {
            int numtimes;
            GradsEnsembleDimension ensDim = this.gradsDDF.getEnsembleDimension();
            int numens = ensDim != null && !this.gradsDDF.isTemplate() ? ensDim.getSize() : 1;
            GradsTimeDimension timeDim = this.gradsDDF.getTimeDimension();
            if (this.gradsDDF.isTemplate()) {
                int[] timesPerFile = this.gradsDDF.getTimeStepsPerFile(this.dataFile.getLocation());
                numtimes = timesPerFile[0];
            } else {
                numtimes = timeDim.getSize();
            }
            int gridsPerTimeStep = this.gradsDDF.getGridsPerTimeStep();
            int numrecords = numens * numtimes * gridsPerTimeStep;
            int xlen = this.gradsDDF.getXDimension().getSize();
            int ylen = this.gradsDDF.getYDimension().getSize();
            long fileSize = this.dataFile.length();
            long dataSize = (long)this.fileHeaderBytes + ((long)(xlen * ylen) * 4L + (long)this.xyHeaderBytes) * (long)numrecords;
            int leftovers = (int)(fileSize - (dataSize += (long)(numtimes * (this.timeHeaderBytes + this.timeTrailerBytes))));
            this.sequentialRecordBytes = leftovers / numrecords / 2;
            if (this.sequentialRecordBytes < 0) {
                throw new IOException("Incorrect sequential record byte size: " + this.sequentialRecordBytes);
            }
        }
        this.buildNCFile();
    }

    private int getByteOrder() {
        return this.gradsDDF.isBigEndian() ? 0 : 1;
    }

    protected void buildNCFile() {
        this.ncFile.empty();
        this.fillNCFile();
        this.ncFile.finish();
    }

    private String getVarName(GradsDimension dim) {
        for (int i = 0; i < this.dimNames.length; ++i) {
            if (!dim.getName().equalsIgnoreCase(this.dimNames[i])) continue;
            return this.dimVarNames[i];
        }
        return dim.getName();
    }

    private void fillNCFile() {
        Variable v;
        List<GradsVariable> vars = this.gradsDDF.getVariables();
        List<GradsAttribute> attrs = this.gradsDDF.getAttributes();
        List<GradsDimension> dims = this.gradsDDF.getDimensions();
        int numZ = 0;
        HashMap<Object, Dimension> zDims = new HashMap<Object, Dimension>();
        for (GradsDimension dim : dims) {
            String[] name = this.getVarName(dim);
            int size = dim.getSize();
            Dimension ncDim = new Dimension((String)name, size);
            this.ncFile.addDimension(null, ncDim);
            if (name.equals(ENS_VAR)) {
                v = new Variable(this.ncFile, null, null, (String)name, DataType.STRING, (String)name);
                v.addAttribute(new Attribute("standard_name", ENS_VAR));
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
                List<String> names = this.gradsDDF.getEnsembleDimension().getEnsembleNames();
                String[] nameArray = new String[names.size()];
                for (int i = 0; i < nameArray.length; ++i) {
                    nameArray[i] = names.get(i);
                }
                Array dataArray = Array.factory((DataType)DataType.STRING, (int[])new int[]{nameArray.length}, (Object)nameArray);
                v.setCachedData(dataArray, false);
            } else {
                double[] vals = dim.getValues();
                v = new Variable(this.ncFile, null, null, (String)name, DataType.DOUBLE, (String)name);
                v.addAttribute(new Attribute("units", dim.getUnit()));
                switch (name) {
                    case "latitude": {
                        v.addAttribute(new Attribute("long_name", Y_VAR));
                        v.addAttribute(new Attribute("standard_name", Y_VAR));
                        v.addAttribute(new Attribute("axis", "Y"));
                        this.sizeY = dim.getSize();
                        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                        break;
                    }
                    case "longitude": {
                        v.addAttribute(new Attribute("long_name", X_VAR));
                        v.addAttribute(new Attribute("standard_name", X_VAR));
                        v.addAttribute(new Attribute("axis", "X"));
                        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                        this.sizeX = dim.getSize();
                        break;
                    }
                    case "level": {
                        numZ = size;
                        zDims.put(name, ncDim);
                        v.addAttribute(new Attribute("long_name", Z_VAR));
                        this.addZAttributes(dim, v);
                        break;
                    }
                    case "time": {
                        v.addAttribute(new Attribute("long_name", TIME_VAR));
                        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
                    }
                }
                ArrayDouble.D1 varArray = new ArrayDouble.D1(size);
                for (int i = 0; i < vals.length; ++i) {
                    varArray.set(i, vals[i]);
                }
                v.setCachedData((Array)varArray, false);
            }
            this.ncFile.addVariable(null, v);
        }
        if (numZ > 0) {
            GradsDimension zDim = this.gradsDDF.getZDimension();
            double[] vals = zDim.getValues();
            for (GradsVariable var : vars) {
                String name;
                int nl = var.getNumLevels();
                if (nl <= 0 || nl == numZ || zDims.get(name = Z_VAR + nl) != null) continue;
                Dimension ncDim = new Dimension(name, nl);
                this.ncFile.addDimension(null, ncDim);
                Variable vz = new Variable(this.ncFile, null, null, name, DataType.DOUBLE, name);
                vz.addAttribute(new Attribute("long_name", name));
                vz.addAttribute(new Attribute("units", zDim.getUnit()));
                this.addZAttributes(zDim, vz);
                ArrayDouble.D1 varArray = new ArrayDouble.D1(nl);
                for (int i = 0; i < nl; ++i) {
                    varArray.set(i, vals[i]);
                }
                vz.setCachedData((Array)varArray, false);
                this.ncFile.addVariable(null, vz);
                zDims.put(name, ncDim);
            }
        }
        for (GradsVariable var : vars) {
            String coords = "latitude longitude";
            int nl = var.getNumLevels();
            if (nl > 0) {
                coords = nl == numZ ? "level " + coords : Z_VAR + nl + " " + coords;
            }
            coords = "time " + coords;
            if (this.gradsDDF.getEnsembleDimension() != null) {
                coords = "ensemble " + coords;
            }
            v = new Variable(this.ncFile, null, null, var.getName(), DataType.FLOAT, coords);
            v.addAttribute(new Attribute("long_name", var.getDescription()));
            if (var.getUnitName() != null) {
                v.addAttribute(new Attribute("units", var.getUnitName()));
            }
            v.addAttribute(new Attribute("_FillValue", (Number)Float.valueOf((float)this.gradsDDF.getMissingValue())));
            v.addAttribute(new Attribute("missing_value", (Number)Float.valueOf((float)this.gradsDDF.getMissingValue())));
            for (GradsAttribute attr : attrs) {
                if (!attr.getVariable().equalsIgnoreCase(var.getName())) continue;
                if (attr.getType().equalsIgnoreCase("String")) {
                    v.addAttribute(new Attribute(attr.getName(), attr.getValue()));
                    continue;
                }
                if (attr.getType().equalsIgnoreCase("Byte")) {
                    try {
                        v.addAttribute(new Attribute(attr.getName(), (Number)new Byte(attr.getValue())));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (attr.getType().equalsIgnoreCase("Int16")) {
                    try {
                        v.addAttribute(new Attribute(attr.getName(), (Number)new Short(attr.getValue())));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (attr.getType().equalsIgnoreCase("Int32")) {
                    try {
                        v.addAttribute(new Attribute(attr.getName(), (Number)new Integer(attr.getValue())));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (attr.getType().equalsIgnoreCase("Float32")) {
                    try {
                        v.addAttribute(new Attribute(attr.getName(), (Number)new Float(attr.getValue())));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (!attr.getType().equalsIgnoreCase("Float64")) continue;
                try {
                    v.addAttribute(new Attribute(attr.getName(), (Number)new Double(attr.getValue())));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.ncFile.addVariable(null, v);
        }
        this.ncFile.addAttribute(null, new Attribute("Conventions", "CF-1.0"));
        this.ncFile.addAttribute(null, new Attribute("history", "Direct read of GrADS binary grid into NetCDF-Java 4 API"));
        String title = this.gradsDDF.getTitle();
        if (title != null && !title.isEmpty()) {
            this.ncFile.addAttribute(null, new Attribute("title", title));
        }
        for (GradsAttribute attr : attrs) {
            if (!attr.getVariable().equalsIgnoreCase("global")) continue;
            this.ncFile.addAttribute(null, new Attribute(attr.getName(), attr.getValue()));
        }
    }

    private void addZAttributes(GradsDimension zDim, Variable v) {
        if (zDim.getUnit().contains("Pa")) {
            v.addAttribute(new Attribute("positive", "down"));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
        } else {
            v.addAttribute(new Attribute("positive", "up"));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
        }
    }

    private float[] readGrid(int index) throws IOException {
        long offset = 0L;
        this.dataFile.seek(offset);
        offset += (long)this.fileHeaderBytes;
        offset += ((long)(this.sizeX * this.sizeY * this.wordSize + this.xyHeaderBytes) + 2L * (long)this.sequentialRecordBytes) * (long)index;
        int curTimeStep = index / this.gradsDDF.getGridsPerTimeStep();
        offset += (long)((curTimeStep + 1) * this.timeHeaderBytes);
        offset += (long)(curTimeStep * this.timeTrailerBytes);
        this.dataFile.seek(offset += (long)(this.xyHeaderBytes + this.sequentialRecordBytes));
        float[] data = new float[this.sizeX * this.sizeY];
        this.dataFile.readFloat(data, 0, this.sizeX * this.sizeY);
        if (this.gradsDDF.isYReversed()) {
            int newLoc = 0;
            float[] temp = new float[this.sizeX * this.sizeY];
            for (int y = this.sizeY - 1; y >= 0; --y) {
                for (int x = 0; x < this.sizeX; ++x) {
                    int oldLoc = y * this.sizeX + x;
                    temp[newLoc++] = data[oldLoc];
                }
            }
            data = temp;
        }
        return data;
    }

    public void close() throws IOException {
        if (this.dataFile != null) {
            this.dataFile.close();
        }
        this.dataFile = null;
        super.close();
    }

    private GradsVariable findVar(Variable v2) {
        List<GradsVariable> vars = this.gradsDDF.getVariables();
        String varName = v2.getFullName();
        for (GradsVariable var : vars) {
            if (!var.getName().equals(varName)) continue;
            return var;
        }
        return null;
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Array dataArray = Array.factory((DataType)DataType.FLOAT, (int[])section.getShape());
        GradsVariable gradsVar = this.findVar(v2);
        if (gradsVar == null) {
            throw new IOException();
        }
        int rangeIdx = 0;
        Range ensRange = this.gradsDDF.getEnsembleDimension() != null ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range levRange = gradsVar.getNumLevels() > 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range yRange = section.getRange(rangeIdx++);
        Range xRange = section.getRange(rangeIdx);
        IndexIterator ii = dataArray.getIndexIterator();
        Iterator iterator = ensRange.iterator();
        while (iterator.hasNext()) {
            int ensIdx = (Integer)iterator.next();
            Iterator iterator2 = timeRange.iterator();
            while (iterator2.hasNext()) {
                int timeIdx = (Integer)iterator2.next();
                Iterator iterator3 = levRange.iterator();
                while (iterator3.hasNext()) {
                    int levelIdx = (Integer)iterator3.next();
                    this.readXY(v2, ensIdx, timeIdx, levelIdx, yRange, xRange, ii);
                }
            }
        }
        return dataArray;
    }

    private void readXY(Variable v2, int ensIdx, int timeIdx, int levIdx, Range yRange, Range xRange, IndexIterator ii) throws IOException {
        this.dataFile = this.getDataFile(ensIdx, timeIdx);
        List<GradsVariable> vars = this.gradsDDF.getVariables();
        int numEns = this.gradsDDF.getTemplateType() == 2 || this.gradsDDF.getTemplateType() == 3 ? 0 : ensIdx;
        int numTimes = this.gradsDDF.getTimeDimension().getSize();
        if (this.gradsDDF.getTemplateType() == 1 || this.gradsDDF.getTemplateType() == 3) {
            int[] tpf = this.gradsDDF.getTimeStepsPerFile(this.dataFile.getLocation());
            numTimes = tpf[0];
            timeIdx = (timeIdx - tpf[1]) % numTimes;
        }
        int gridNum = numEns * numTimes * this.gradsDDF.getGridsPerTimeStep();
        for (int t = 0; t < timeIdx; ++t) {
            for (GradsVariable var : vars) {
                int numVLevels = var.getNumLevels();
                if (numVLevels == 0) {
                    numVLevels = 1;
                }
                for (int l = 0; l < numVLevels; ++l) {
                    ++gridNum;
                }
            }
        }
        for (GradsVariable var : vars) {
            int numVLevels = var.getNumLevels();
            if (numVLevels == 0) {
                numVLevels = 1;
            }
            if (var.getName().equals(v2.getFullName())) {
                gridNum += levIdx;
                break;
            }
            for (int l = 0; l < numVLevels; ++l) {
                ++gridNum;
            }
        }
        float[] data = this.readGrid(gridNum);
        Iterator iterator = yRange.iterator();
        while (iterator.hasNext()) {
            int y = (Integer)iterator.next();
            Iterator iterator2 = xRange.iterator();
            while (iterator2.hasNext()) {
                int x = (Integer)iterator2.next();
                ii.setFloatNext(data[y * this.sizeX + x]);
            }
        }
    }

    private RandomAccessFile getDataFile(int eIndex, int tIndex) throws IOException {
        String dataFilePath = this.gradsDDF.getFileName(eIndex, tIndex);
        if (!this.gradsDDF.isTemplate() && this.dataFile != null) {
            return this.dataFile;
        }
        if (this.dataFile != null) {
            String path = this.dataFile.getLocation();
            if (path.equals(dataFilePath)) {
                return this.dataFile;
            }
            this.dataFile.close();
        }
        this.dataFile = RandomAccessFile.acquire((String)dataFilePath);
        this.dataFile.order(this.getByteOrder());
        return this.dataFile;
    }
}

