/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.util.stream.Stream;
import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.LongJumpableUniformRandomProvider;
import org.apache.commons.rng.SplittableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.source32.LXMSupport;
import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.core.util.RandomStreams;

public final class L32X64Mix
extends IntProvider
implements LongJumpableUniformRandomProvider,
SplittableUniformRandomProvider {
    private static final int M = -1380669139;
    private static final int SEED_SIZE = 4;
    private int la;
    private int ls;
    private int x0;
    private int x1;

    public L32X64Mix(int[] seed) {
        this.setState(L32X64Mix.extendSeed(seed, 4));
    }

    public L32X64Mix(int seed0, int seed1, int seed2, int seed3) {
        this.la = seed0 | 1;
        this.ls = seed1;
        this.x0 = seed2;
        this.x1 = seed3;
    }

    private L32X64Mix(L32X64Mix source) {
        super(source);
        this.la = source.la;
        this.ls = source.ls;
        this.x0 = source.x0;
        this.x1 = source.x1;
    }

    private void setState(int[] state) {
        this.la = state[0] | 1;
        this.ls = state[1];
        this.x0 = state[2];
        this.x1 = state[3];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new int[]{this.la, this.ls, this.x0, this.x1}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        this.setState(NumberFactory.makeIntArray(c[0]));
        super.setStateInternal(c[1]);
    }

    @Override
    public int next() {
        int s0 = this.x0;
        int s = this.ls;
        int z = LXMSupport.lea32(s + s0);
        this.ls = -1380669139 * s + this.la;
        int s1 = this.x1;
        this.x0 = Integer.rotateLeft(s0, 26) ^ (s1 ^= s0) ^ s1 << 9;
        this.x1 = Integer.rotateLeft(s1, 13);
        return z;
    }

    public UniformRandomProvider jump() {
        L32X64Mix copy = new L32X64Mix(this);
        this.ls = -1380669139 * this.ls + this.la;
        this.resetCachedState();
        return copy;
    }

    public JumpableUniformRandomProvider longJump() {
        L32X64Mix copy = new L32X64Mix(this);
        this.ls = 1701052417 * this.ls + 74121216 * this.la;
        this.resetCachedState();
        return copy;
    }

    public SplittableUniformRandomProvider split(UniformRandomProvider source) {
        return L32X64Mix.create(source.nextInt(), source);
    }

    public Stream<SplittableUniformRandomProvider> splits(long streamSize, SplittableUniformRandomProvider source) {
        return RandomStreams.generateWithSeed(streamSize, source, L32X64Mix::create);
    }

    private static SplittableUniformRandomProvider create(long seed, UniformRandomProvider source) {
        int x1;
        int s0 = (int)seed << 1;
        int s1 = source.nextInt();
        int x0 = source.nextInt();
        if ((x0 | (x1 = source.nextInt())) == 0) {
            x0 = LXMSupport.lea32(s1);
            x1 = LXMSupport.lea32(s1 + -1640531527);
        }
        return new L32X64Mix(s0, s1, x0, x1);
    }
}

