/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.dataframe.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class BlockManager<V> {
    private final List<List<V>> blocks = new LinkedList<List<V>>();

    public BlockManager() {
        this(Collections.emptyList());
    }

    public BlockManager(Collection<? extends Collection<? extends V>> data) {
        for (Collection<V> collection : data) {
            this.add(new ArrayList<V>(collection));
        }
    }

    public void reshape(int cols, int rows) {
        for (int c = this.blocks.size(); c < cols; ++c) {
            this.add(new ArrayList(rows));
        }
        for (List<V> block : this.blocks) {
            for (int r = block.size(); r < rows; ++r) {
                block.add(null);
            }
        }
    }

    public V get(int col, int row) {
        return this.blocks.get(col).get(row);
    }

    public void set(V value, int col, int row) {
        this.blocks.get(col).set(row, value);
    }

    public void add(List<V> col) {
        int len = this.length();
        for (int r = col.size(); r < len; ++r) {
            col.add(null);
        }
        this.blocks.add(col);
    }

    public int size() {
        return this.blocks.size();
    }

    public int length() {
        return this.blocks.isEmpty() ? 0 : this.blocks.get(0).size();
    }
}

