/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.awx;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Extent;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.Reproject;

public class AWXDataInfo
extends DataInfo
implements IGridDataInfo,
IStationDataInfo {
    private String _dataFileName;
    private int _orderOfInt;
    private int _lenHeadP1;
    private int _lenHeadP2;
    private int _lenFillingData;
    private int _lenRecord;
    private int _numHeadRecord;
    private int _numDataRecord;
    private int _productType;
    private int _zipModel;
    private String _illumination;
    private int _qualityMark;
    private int channelNumber;
    private int _byteGridData;
    private int _baseData = 0;
    private int _scaleFactor = 1;
    private int _startYear;
    private int _startMonth;
    private int _startDay;
    private int _startHour;
    private int _startMinute;
    private int _endYear;
    private int _endMonth;
    private int _endDay;
    private int _endHour;
    private int _endMinute;
    private double _ulLatitude;
    private double _ulLongitude;
    private double _lrLatitude;
    private double _lrLongitude;
    private int _unitGrid;
    private int _spaceLatGrid;
    private int _spaceLonGrid;
    private int _numLatGrid;
    private int _numLonGrid;
    private double _width;
    private double _height;
    private double _lonCenter;
    private double _latCenter;
    private double _xDelt;
    private double _yDelt;
    private double _xLB;
    private double _yLB;
    private int lenColorTable;
    private int lenCalibration;
    private int lenLocation;
    public LocalDateTime STime;
    public LocalDateTime ETime;
    public byte[] ImageBytes;
    public double xUL;
    public double yUL;
    public double xScale;
    public double yScale;
    public List<String> VarList;
    public List<String> FieldList;
    ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;

    public AWXDataInfo() {
        this.setDataType(MeteoDataType.AWX);
    }

    public int getXNum() {
        int xNum = 0;
        switch (this._productType) {
            case 1: {
                xNum = (int)this._width;
                break;
            }
            case 3: {
                xNum = this._numLonGrid;
            }
        }
        return xNum;
    }

    public int getYNum() {
        int yNum = 0;
        switch (this._productType) {
            case 1: {
                yNum = (int)this._height;
                break;
            }
            case 3: {
                yNum = this._numLatGrid;
            }
        }
        return yNum;
    }

    public int getProductType() {
        return this._productType;
    }

    public void setProuectType(int value) {
        this._productType = value;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    @Override
    public void readDataInfo(String fileName) {
        this.setFileName(fileName);
        try {
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            byte[] bytes = new byte[12];
            br.read(bytes);
            this._dataFileName = new String(bytes).trim();
            bytes = new byte[2];
            br.read(bytes);
            this._orderOfInt = DataConvert.bytes2Int2((byte[])bytes);
            if (this._orderOfInt != 0) {
                this.byteOrder = ByteOrder.BIG_ENDIAN;
            }
            br.read(bytes);
            this._lenHeadP1 = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
            br.read(bytes);
            this._lenHeadP2 = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
            br.read(bytes);
            this._lenFillingData = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
            br.read(bytes);
            this._lenRecord = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
            br.read(bytes);
            this._numHeadRecord = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
            br.read(bytes);
            this._numDataRecord = DataConvert.bytes2UShort((byte[])bytes, (ByteOrder)this.byteOrder);
            br.read(bytes);
            this._productType = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
            br.read(bytes);
            this._zipModel = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
            bytes = new byte[8];
            br.read(bytes);
            this._illumination = new String(bytes).trim();
            bytes = new byte[2];
            br.read(bytes);
            this._qualityMark = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
            br.seek(0L);
            bytes = new byte[this._lenHeadP1 + this._lenHeadP2];
            br.read(bytes);
            byte[] tbytes = new byte[2];
            if (this._productType == 3) {
                tbytes = Arrays.copyOfRange(bytes, 50, 52);
                this._byteGridData = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, 52, 54);
                this._baseData = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, 54, 56);
                this._scaleFactor = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            }
            int yearIdx = 58;
            switch (this._productType) {
                case 1: {
                    yearIdx = 48;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    yearIdx = 58;
                    break;
                }
                case 4: {
                    yearIdx = 54;
                }
            }
            tbytes = Arrays.copyOfRange(bytes, yearIdx, yearIdx + 2);
            this._startYear = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, yearIdx + 2, yearIdx + 4);
            this._startMonth = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, yearIdx + 4, yearIdx + 6);
            this._startDay = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, yearIdx + 6, yearIdx + 8);
            this._startHour = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, yearIdx + 8, yearIdx + 10);
            this._startMinute = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            this.STime = LocalDateTime.of(this._startYear, this._startMonth, this._startDay, this._startHour, this._startMinute, 0);
            if (this._productType == 3 || this._productType == 4) {
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 10, yearIdx + 12);
                this._endYear = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 12, yearIdx + 14);
                this._endMonth = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 14, yearIdx + 16);
                this._endDay = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 16, yearIdx + 18);
                this._endHour = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 18, yearIdx + 20);
                this._endMinute = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                if (this._endYear > 0) {
                    if (this._endMinute < 60) {
                        this.ETime = LocalDateTime.of(this._endYear, this._endMonth, this._endDay, this._endHour, this._endMinute, 0);
                    } else {
                        this.ETime = LocalDateTime.of(this._endYear, this._endMonth, this._endDay, this._endHour, 0, 0);
                        this.ETime = this.ETime.plusMinutes(this._endMinute);
                    }
                }
            }
            tbytes = Arrays.copyOfRange(bytes, yearIdx + 10, yearIdx + 12);
            this.channelNumber = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            if (this._productType == 3) {
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 20, yearIdx + 22);
                this._ulLatitude = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                this._ulLatitude /= 100.0;
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 22, yearIdx + 24);
                this._ulLongitude = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                this._ulLongitude /= 100.0;
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 24, yearIdx + 26);
                this._lrLatitude = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                this._lrLatitude /= 100.0;
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 26, yearIdx + 28);
                this._lrLongitude = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                this._lrLongitude /= 100.0;
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 28, yearIdx + 30);
                this._unitGrid = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 30, yearIdx + 32);
                this._spaceLonGrid = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 32, yearIdx + 34);
                this._spaceLatGrid = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 34, yearIdx + 36);
                this._numLonGrid = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 36, yearIdx + 38);
                this._numLatGrid = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                this.calCoordinate_3();
            }
            if (this._productType == 1) {
                this.getProjection(bytes);
            }
            if (this._productType != 4) {
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 48, yearIdx + 50);
                this.lenColorTable = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 50, yearIdx + 52);
                this.lenCalibration = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
                tbytes = Arrays.copyOfRange(bytes, yearIdx + 52, yearIdx + 54);
                this.lenLocation = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            }
            br.close();
            this.addAttribute(new Attribute("Data type", "AWX"));
            this.addAttribute(new Attribute("Product type", this._productType));
            this.VarList = new ArrayList<String>();
            switch (this._productType) {
                case 1: 
                case 2: 
                case 3: {
                    this.VarList.add("var");
                    Variable var = new Variable();
                    var.setName("var");
                    var.setDimension(this.getYDimension());
                    var.setDimension(this.getXDimension());
                    this.addVariable(var);
                    break;
                }
                case 4: {
                    Variable var;
                    this.VarList.add("Latitude");
                    this.VarList.add("Longitude");
                    this.VarList.add("Pressure");
                    this.VarList.add("WindDirection");
                    this.VarList.add("WindSpeed");
                    this.VarList.add("Temperature");
                    this.VarList.add("Slope");
                    this.VarList.add("Correlation");
                    this.VarList.add("MiddleRow");
                    this.VarList.add("MiddleCol");
                    this.VarList.add("FirstRow");
                    this.VarList.add("FirstCol");
                    this.VarList.add("LastRow");
                    this.VarList.add("LastCol");
                    this.VarList.add("BrightTemp");
                    Dimension stdim = new Dimension(DimensionType.OTHER);
                    stdim.setName("stations");
                    double[] values = new double[this._numDataRecord];
                    stdim.setValues(values);
                    this.addDimension(stdim);
                    for (String vName : this.VarList) {
                        var = new Variable();
                        var.setName(vName);
                        var.setStation(true);
                        var.setDimension(stdim);
                        this.addVariable(var);
                    }
                    this.FieldList = new ArrayList<String>();
                    this.FieldList.add("Stid");
                    this.FieldList.addAll(this.VarList);
                }
            }
            for (Dimension dim : this.dimensions) {
                Variable variable = new Variable(dim.getName());
                variable.setDimVar(true);
                variable.setCachedData(dim.getDimValue());
                variable.addDimension(dim);
                this.addCoordinate(variable);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void getProjection(byte[] bytes) {
        byte[] tbytes = new byte[2];
        if (this._productType == 1) {
            tbytes = Arrays.copyOfRange(bytes, 58, 60);
            int channel = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 60, 62);
            int projType = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 62, 64);
            this._width = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 64, 66);
            this._height = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 66, 68);
            int ulLineNum = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 68, 70);
            int ulPixelNum = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 70, 72);
            int ratio = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 72, 74);
            this._ulLatitude = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            this._ulLatitude /= 100.0;
            tbytes = Arrays.copyOfRange(bytes, 74, 76);
            this._lrLatitude = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            this._lrLatitude /= 100.0;
            tbytes = Arrays.copyOfRange(bytes, 76, 78);
            this._ulLongitude = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            this._ulLongitude /= 100.0;
            tbytes = Arrays.copyOfRange(bytes, 78, 80);
            this._lrLongitude = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            this._lrLongitude /= 100.0;
            tbytes = Arrays.copyOfRange(bytes, 80, 82);
            this._latCenter = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            this._latCenter /= 100.0;
            tbytes = Arrays.copyOfRange(bytes, 82, 84);
            this._lonCenter = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            this._lonCenter /= 100.0;
            tbytes = Arrays.copyOfRange(bytes, 84, 86);
            float lat1 = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            lat1 /= 100.0f;
            tbytes = Arrays.copyOfRange(bytes, 86, 88);
            float lat2 = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            lat2 /= 100.0f;
            tbytes = Arrays.copyOfRange(bytes, 88, 90);
            this._xDelt = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            this._xDelt /= 100.0;
            tbytes = Arrays.copyOfRange(bytes, 90, 92);
            this._yDelt = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            this._yDelt /= 100.0;
            tbytes = Arrays.copyOfRange(bytes, 92, 94);
            int hasGeoGrid = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 94, 96);
            int geoGridValue = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 96, 98);
            int lenPallate = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 98, 100);
            int lenVef = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            tbytes = Arrays.copyOfRange(bytes, 100, 102);
            int lenGeo = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
            String projStr = this.getProjectionInfo().toProj4String();
            switch (projType) {
                case 0: {
                    break;
                }
                case 1: {
                    projStr = "+proj=lcc+lon_0=" + String.valueOf(this._lonCenter) + "+lat_0=" + String.valueOf(this._latCenter) + "+lat_1=" + String.valueOf(lat1) + "+lat_2=" + String.valueOf(lat2);
                    break;
                }
                case 2: {
                    projStr = "+proj=merc+lon_0=" + String.valueOf(this._lonCenter) + "+lat_ts=" + String.valueOf(lat1);
                    break;
                }
                case 3: {
                    projStr = "+proj=stere+lat_0=" + String.valueOf(this._latCenter) + "+lon_0=" + String.valueOf(this._lonCenter);
                    double k0 = ProjectionInfo.calScaleFactorFromStandardParallel((double)lat1);
                    projStr = projStr + "+k=" + String.valueOf(k0);
                    break;
                }
                case 4: {
                    break;
                }
            }
            if (!projStr.equals(this.getProjectionInfo().toProj4String())) {
                this.setProjectionInfo(ProjectionInfo.factory((String)projStr));
            }
            this.calCoordinate_1(projType);
        }
    }

    private void calCoordinate_1(int projType) {
        int i;
        int xNum = (int)this._width;
        int yNum = (int)this._height;
        switch (projType) {
            case 4: {
                this._xDelt = (this._lrLongitude - this._ulLongitude) / (double)xNum;
                this._yDelt = (this._ulLatitude - this._lrLatitude) / (double)yNum;
                this._xLB = this._ulLongitude + this._xDelt / 2.0;
                this._yLB = this._lrLatitude + this._yDelt / 2.0;
                break;
            }
            default: {
                ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
                double[][] points = new double[][]{{this._lonCenter, this._latCenter}};
                Reproject.reprojectPoints((double[][])points, (ProjectionInfo)fromProj, (ProjectionInfo)this.getProjectionInfo(), (int)0, (int)1);
                double X_Center = points[0][0];
                double Y_Center = points[0][1];
                this._xDelt *= 1000.0;
                this._yDelt *= 1000.0;
                this._xLB = X_Center - this._xDelt * this._width / 2.0;
                this._yLB = Y_Center - this._yDelt * this._height / 2.0;
            }
        }
        double[] x = new double[xNum];
        double[] y = new double[yNum];
        for (i = 0; i < xNum; ++i) {
            x[i] = this._xLB + this._xDelt * (double)i;
        }
        for (i = 0; i < yNum; ++i) {
            y[i] = this._yLB + this._yDelt * (double)i;
        }
        Dimension xdim = new Dimension(DimensionType.X);
        xdim.setShortName(this.getXCoordVariableName());
        xdim.setValues(x);
        this.setXDimension(xdim);
        this.addDimension(xdim);
        Dimension ydim = new Dimension(DimensionType.Y);
        ydim.setShortName(this.getYCoordVariableName());
        ydim.setValues(y);
        this.setYDimension(ydim);
        this.addDimension(ydim);
    }

    private void calCoordinate_3() {
        int i;
        double width = this._lrLongitude - this._ulLongitude;
        double height = this._ulLatitude - this._lrLatitude;
        this.xUL = this._ulLongitude;
        this.yUL = this._ulLatitude;
        this.xScale = width / (double)this._numLonGrid;
        this.yScale = -height / (double)this._numLatGrid;
        double[] x = new double[this._numLonGrid];
        double[] y = new double[this._numLatGrid];
        double xDelt = (this._lrLongitude - this._ulLongitude) / (double)this._numLonGrid;
        double yDelt = (this._ulLatitude - this._lrLatitude) / (double)this._numLatGrid;
        for (i = 0; i < this._numLonGrid; ++i) {
            x[i] = this._ulLongitude + xDelt * (double)i;
        }
        for (i = 0; i < this._numLatGrid; ++i) {
            y[i] = this._lrLatitude + yDelt * (double)i;
        }
        Dimension xdim = new Dimension(DimensionType.X);
        xdim.setShortName(this.getXCoordVariableName());
        xdim.setValues(x);
        this.setXDimension(xdim);
        this.addDimension(xdim);
        Dimension ydim = new Dimension(DimensionType.Y);
        ydim.setShortName(this.getYCoordVariableName());
        ydim.setValues(y);
        this.setYDimension(ydim);
        this.addDimension(ydim);
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public Array realRead(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.realRead(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array realRead(String varName, int[] origin, int[] size, int[] stride) {
        try {
            if (this._productType == 4) {
                Array dataArray = this.read_4(varName);
                dataArray = dataArray.section(origin, size, stride);
                return dataArray;
            }
            Section section = new Section(origin, size, stride);
            Array dataArray = Array.factory((DataType)DataType.FLOAT, (int[])section.getShape());
            int rangeIdx = 0;
            Range yRange = section.getRange(rangeIdx++);
            Range xRange = section.getRange(rangeIdx);
            IndexIterator ii = dataArray.getIndexIterator();
            switch (this._productType) {
                case 1: {
                    try {
                        this.readXY_1(yRange, xRange, ii);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case 3: {
                    try {
                        this.readXY_3(yRange, xRange, ii);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    return null;
                }
            }
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readXY_1(Range yRange, Range xRange, IndexIterator ii) throws IOException {
        int j;
        int i;
        Object[] rawData = this.getImageData();
        byte[] imageBytes = (byte[])rawData[0];
        int[] calibration = (int[])rawData[1];
        int xNum = (int)this._width;
        int yNum = (int)this._height;
        float[] data = new float[yNum * xNum];
        if (calibration.length > 0) {
            if (this.channelNumber < 4) {
                for (i = 0; i < yNum; ++i) {
                    for (j = 0; j < xNum; ++j) {
                        data[(yNum - i - 1) * xNum + j] = (float)calibration[DataConvert.byte2Int((byte)imageBytes[i * xNum + j]) * 4] * 0.01f;
                    }
                }
            } else {
                int n = 256;
                int[] cali = new int[n];
                for (i = 0; i < 64; ++i) {
                    for (j = 0; j < 4; ++j) {
                        cali[i * 4 + j] = calibration[i];
                    }
                }
                for (i = 0; i < yNum; ++i) {
                    for (j = 0; j < xNum; ++j) {
                        data[(yNum - i - 1) * xNum + j] = (float)cali[DataConvert.byte2Int((byte)imageBytes[i * xNum + j])] * 1.0E-4f;
                    }
                }
            }
        } else {
            for (i = 0; i < yNum; ++i) {
                for (j = 0; j < xNum; ++j) {
                    data[(yNum - i - 1) * xNum + j] = DataConvert.byte2Int((byte)imageBytes[i * xNum + j]);
                }
            }
        }
        for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
            for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                int index = y * xNum + x;
                ii.setFloatNext(data[index]);
            }
        }
    }

    private void readXY_3(Range yRange, Range xRange, IndexIterator ii) throws FileNotFoundException, IOException {
        RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
        br.seek(this._lenRecord * this._numHeadRecord);
        int length = (int)(br.length() - br.getFilePointer());
        byte[] imageBytes = new byte[length];
        br.read(imageBytes);
        br.close();
        int bi = 0;
        int value = 0;
        byte[] vbytes = new byte[this._byteGridData];
        float[] data = new float[this._numLatGrid * this._numLonGrid];
        for (int i = 0; i < this._numLatGrid; ++i) {
            for (int j = 0; j < this._numLonGrid; ++j) {
                vbytes = Arrays.copyOfRange(imageBytes, bi, bi + this._byteGridData);
                if (this._byteGridData == 1) {
                    value = DataConvert.byte2Int((byte)vbytes[0]);
                } else if (this._byteGridData == 2) {
                    value = DataConvert.bytes2Int((byte[])vbytes, (ByteOrder)this.byteOrder);
                } else if (this._byteGridData == 4) {
                    value = DataConvert.bytes2Int((byte[])vbytes, (ByteOrder)this.byteOrder);
                }
                int idx = (this._numLatGrid - i - 1) * this._numLonGrid + j;
                data[idx] = (float)(value + this._baseData) / (float)this._scaleFactor;
                bi += this._byteGridData;
            }
        }
        for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
            for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                int index = y * this._numLonGrid + x;
                ii.setFloatNext(data[index]);
            }
        }
    }

    private Array read_4(String varName) {
        try {
            Array a = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{this._numDataRecord});
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            br.seek((long)this._lenRecord * (long)this._numHeadRecord);
            long bP = br.getFilePointer();
            byte[] bytes = new byte[2];
            int varIdx = this.VarList.indexOf(varName);
            for (int i = 0; i < this._numDataRecord; ++i) {
                br.seek(bP);
                if (br.getFilePointer() + (long)this._lenRecord > br.length()) break;
                if (varIdx <= 4) {
                    br.skipBytes(2 * varIdx);
                } else {
                    br.skipBytes(2 * varIdx + 2);
                }
                br.read(bytes);
                float t = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
                switch (varIdx) {
                    case 0: 
                    case 1: 
                    case 5: 
                    case 14: {
                        t /= 100.0f;
                        break;
                    }
                    case 6: 
                    case 7: {
                        t /= 1000.0f;
                    }
                }
                a.setFloat(i, t);
                bP += (long)this._lenRecord;
            }
            br.close();
            return a;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        GridData gData = null;
        switch (this._productType) {
            case 1: {
                try {
                    gData = this.getGridData_1();
                }
                catch (IOException ex) {
                    Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            case 3: {
                try {
                    gData = this.getGridData_3();
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return gData;
    }

    private GridData getGridData_3() throws FileNotFoundException, IOException {
        int i;
        RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
        br.seek(this._lenRecord * this._numHeadRecord);
        int length = (int)(br.length() - br.getFilePointer());
        byte[] imageBytes = new byte[length];
        br.read(imageBytes);
        br.close();
        double[] x = new double[this._numLonGrid];
        double[] y = new double[this._numLatGrid];
        double xDelt = (this._lrLongitude - this._ulLongitude) / (double)this._numLonGrid;
        double yDelt = (this._ulLatitude - this._lrLatitude) / (double)this._numLatGrid;
        for (i = 0; i < this._numLonGrid; ++i) {
            x[i] = this._ulLongitude + xDelt * (double)i;
        }
        for (i = 0; i < this._numLatGrid; ++i) {
            y[i] = this._lrLatitude + yDelt * (double)i;
        }
        double[][] gData = new double[this._numLatGrid][this._numLonGrid];
        int bi = 0;
        int value = 0;
        byte[] vbytes = new byte[this._byteGridData];
        for (i = 0; i < this._numLatGrid; ++i) {
            for (int j = 0; j < this._numLonGrid; ++j) {
                vbytes = Arrays.copyOfRange(imageBytes, bi, bi + this._byteGridData);
                if (this._byteGridData == 1) {
                    value = DataConvert.byte2Int((byte)vbytes[0]);
                } else if (this._byteGridData == 2) {
                    value = DataConvert.bytes2Int((byte[])vbytes, (ByteOrder)this.byteOrder);
                } else if (this._byteGridData == 4) {
                    value = DataConvert.bytes2Int((byte[])vbytes, (ByteOrder)this.byteOrder);
                }
                gData[this._numLatGrid - i - 1][j] = (double)(value + this._baseData) / (double)this._scaleFactor;
                bi += this._byteGridData;
            }
        }
        return new GridData(gData, x, y);
    }

    private GridData getGridData_1() throws IOException {
        int i;
        Object[] rawData = this.getImageData();
        byte[] imageBytes = (byte[])rawData[0];
        int[] calibration = (int[])rawData[1];
        int xNum = (int)this._width;
        int yNum = (int)this._height;
        double[] x = new double[xNum];
        double[] y = new double[yNum];
        for (i = 0; i < xNum; ++i) {
            x[i] = this._xLB + this._xDelt * (double)i;
        }
        for (i = 0; i < yNum; ++i) {
            y[i] = this._yLB + this._yDelt * (double)i;
        }
        double[][] gData = new double[yNum][xNum];
        if (calibration.length > 0) {
            for (i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    gData[yNum - i - 1][j] = (float)calibration[DataConvert.byte2Int((byte)imageBytes[i * xNum + j]) * 4] * 0.01f;
                }
            }
        } else {
            for (i = 0; i < yNum; ++i) {
                for (int j = 0; j < xNum; ++j) {
                    gData[yNum - i - 1][j] = DataConvert.byte2Int((byte)imageBytes[i * xNum + j]);
                }
            }
        }
        return new GridData(gData, x, y);
    }

    public Object[] getImageData() throws FileNotFoundException, IOException {
        RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
        byte[] bytes = new byte[this._lenHeadP1 + this._lenHeadP2];
        br.read(bytes);
        byte[] tbytes = new byte[2];
        tbytes = Arrays.copyOfRange(bytes, 96, 98);
        int lenPallate = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
        tbytes = Arrays.copyOfRange(bytes, 98, 100);
        int lenVef = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
        tbytes = Arrays.copyOfRange(bytes, 100, 102);
        int lenGeo = DataConvert.bytes2Int((byte[])tbytes, (ByteOrder)this.byteOrder);
        int[] calibration = new int[lenVef / 2];
        if (lenVef > 0) {
            br.seek(104L);
            br.skipBytes(lenPallate);
            bytes = new byte[lenVef];
            br.read(bytes);
            for (int i = 0; i < lenVef / 2; ++i) {
                calibration[i] = DataConvert.bytes2UShort((byte[])Arrays.copyOfRange(bytes, i * 2, i * 2 + 2));
            }
        }
        br.seek(this._lenRecord * this._numHeadRecord);
        int length = (int)(br.length() - br.getFilePointer());
        byte[] imageBytes = new byte[length];
        br.read(imageBytes);
        br.close();
        return new Object[]{imageBytes, calibration};
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        try {
            StationData stationData = new StationData();
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            ArrayList<String> stations = new ArrayList<String>();
            ArrayList<double[]> disDataList = new ArrayList<double[]>();
            float minX = 0.0f;
            float maxX = 0.0f;
            float minY = 0.0f;
            float maxY = 0.0f;
            br.seek(this._lenRecord * this._numHeadRecord);
            long bP = br.getFilePointer();
            byte[] bytes = new byte[2];
            int varIdx = this.getVariableIndex(varName);
            for (int i = 0; i < this._numDataRecord; ++i) {
                float t;
                br.seek(bP);
                if (br.getFilePointer() + (long)this._lenRecord > br.length()) break;
                stations.add(String.valueOf(i));
                br.read(bytes);
                float lat = (float)DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder) / 100.0f;
                br.read(bytes);
                float lon = (float)DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder) / 100.0f;
                block1 : switch (varIdx) {
                    case 0: {
                        t = lat;
                        break;
                    }
                    case 1: {
                        t = lon;
                        break;
                    }
                    default: {
                        int idx = varIdx - 2;
                        if (idx <= 2) {
                            br.skipBytes(2 * idx);
                        } else {
                            br.skipBytes(2 * idx + 2);
                        }
                        br.read(bytes);
                        t = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
                        switch (idx) {
                            case 3: 
                            case 12: {
                                t /= 100.0f;
                                break block1;
                            }
                            case 4: 
                            case 5: {
                                t /= 1000.0f;
                            }
                        }
                    }
                }
                disDataList.add(new double[]{lon, lat, t});
                if (i == 0) {
                    maxX = minX = lon;
                    maxY = minY = lat;
                } else {
                    if (minX > lon) {
                        minX = lon;
                    } else if (maxX < lon) {
                        maxX = lon;
                    }
                    if (minY > lat) {
                        minY = lat;
                    } else if (maxY < lat) {
                        maxY = lat;
                    }
                }
                bP += (long)this._lenRecord;
            }
            Extent dataExtent = new Extent();
            dataExtent.minX = minX;
            dataExtent.maxX = maxX;
            dataExtent.minY = minY;
            dataExtent.maxY = maxY;
            br.close();
            double[][] discreteData = new double[disDataList.size()][3];
            for (int i = 0; i < disDataList.size(); ++i) {
                discreteData[i][0] = ((double[])disDataList.get(i))[0];
                discreteData[i][1] = ((double[])disDataList.get(i))[1];
                discreteData[i][2] = ((double[])disDataList.get(i))[2];
            }
            stationData.data = discreteData;
            stationData.dataExtent = dataExtent;
            stationData.stations = stations;
            return stationData;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private List<List<String>> getStationInfoDataList() throws FileNotFoundException, IOException {
        ArrayList<List<String>> stInfoData = new ArrayList<List<String>>();
        RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
        br.seek(this._lenRecord * 2);
        long bP = br.getFilePointer();
        byte[] bytes = new byte[2];
        for (int i = 0; i < this._numDataRecord; ++i) {
            br.seek(bP);
            if (br.getFilePointer() + (long)this._lenRecord > br.length()) break;
            ArrayList<String> stData = new ArrayList<String>();
            stData.add(String.valueOf(i));
            br.read(bytes);
            float lat = (float)DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder) / 100.0f;
            br.read(bytes);
            float lon = (float)DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder) / 100.0f;
            stData.add(String.valueOf(lon));
            stData.add(String.valueOf(lat));
            for (int j = 0; j < this.VarList.size(); ++j) {
                br.read(bytes);
                float t = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)this.byteOrder);
                switch (j) {
                    case 2: {
                        br.skipBytes(2);
                        break;
                    }
                    case 3: 
                    case 12: {
                        t /= 100.0f;
                        break;
                    }
                    case 4: 
                    case 5: {
                        t /= 1000.0f;
                    }
                }
                stData.add(String.valueOf(t));
            }
            stInfoData.add(stData);
            bP += (long)this._lenRecord;
        }
        br.close();
        return stInfoData;
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        try {
            StationInfoData stInfoData = new StationInfoData();
            stInfoData.setDataList(this.getStationInfoDataList());
            stInfoData.setFields(this.FieldList);
            stInfoData.setVariables(this.VarList);
            return stInfoData;
        }
        catch (IOException ex) {
            Logger.getLogger(AWXDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

