/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.bandraster;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.mapdata.geotiff.GeoTiff;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;

public class GeoTiffDataInfo
extends DataInfo
implements IGridDataInfo {
    private GeoTiff geoTiff;
    private int bandNum;

    public GeoTiffDataInfo() {
        this.setDataType(MeteoDataType.GEOTIFF);
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            this.setFileName(fileName);
            this.geoTiff = new GeoTiff(fileName);
            this.geoTiff.read();
            this.setProjectionInfo(this.geoTiff.readProj());
            List<double[]> xy = this.geoTiff.readXY();
            double[] X = xy.get(0);
            double[] Y = xy.get(1);
            Dimension xDim = new Dimension(DimensionType.X);
            xDim.setName(this.getXCoordVariableName());
            xDim.setValues(X);
            this.setXDimension(xDim);
            this.addDimension(xDim);
            Dimension yDim = new Dimension(DimensionType.Y);
            yDim.setName(this.getYCoordVariableName());
            yDim.setValues(Y);
            yDim.setReverse(true);
            this.setYDimension(yDim);
            this.addDimension(yDim);
            this.bandNum = this.geoTiff.getBandNum();
            Dimension bDim = null;
            if (this.bandNum > 1) {
                bDim = new Dimension(DimensionType.OTHER);
                bDim.setName("band");
                bDim.setValues(new double[this.bandNum]);
                this.addDimension(bDim);
            }
            ArrayList<Variable> variables = new ArrayList<Variable>();
            Variable aVar = new Variable();
            aVar.setName("var");
            aVar.addDimension(yDim);
            aVar.addDimension(xDim);
            if (this.bandNum > 1) {
                aVar.addDimension(bDim);
            }
            variables.add(aVar);
            this.setVariables(variables);
            for (Dimension dim : this.dimensions) {
                Variable variable = new Variable(dim.getName());
                variable.setDimVar(true);
                variable.setCachedData(dim.getDimValue());
                variable.addDimension(dim);
                this.addCoordinate(variable);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(GeoTiffDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "Data Type: GeoTiff";
        dataInfo = dataInfo + System.getProperty("line.separator") + super.generateInfoText();
        return dataInfo;
    }

    @Override
    public Array realRead(String varName) {
        Array r = null;
        try {
            r = this.geoTiff.readArray();
        }
        catch (IOException ex) {
            Logger.getLogger(GeoTiffDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return r;
    }

    @Override
    public Array realRead(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Section section = new Section(origin, size, stride);
            int rangeIdx = 0;
            Range yRange = section.getRange(rangeIdx++);
            Range xRange = section.getRange(rangeIdx);
            Array array = this.geoTiff.readArray(yRange, xRange);
            return array;
        }
        catch (IOException | InvalidRangeException ex) {
            Logger.getLogger(GeoTiffDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readXY(Range yRange, Range xRange, IndexIterator ii) {
        int[][] data = this.geoTiff.readData();
        for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
            for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                ii.setFloatNext((float)data[y][x]);
            }
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        GridData gdata = this.geoTiff.getGridData_Value();
        gdata.setXArray(this.getXDimension().getValues());
        gdata.setYArray(this.getYDimension().getValues());
        gdata.setProjInfo(this.getProjectionInfo());
        return gdata;
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

