/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModel;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.dataframe.Column;
import org.meteoinfo.dataframe.ColumnIndex;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.dataframe.Index;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.table.DataTable;

public class MICAPS1DataInfo
extends DataInfo
implements IStationDataInfo {
    private String _description;
    private boolean _isAutoStation = false;
    private List<String> _varList = new ArrayList<String>();
    private int _stNum;
    private boolean _hasAllCols = false;
    private int _varNum;
    private final List<String> _fieldList = new ArrayList<String>();

    public MICAPS1DataInfo() {
        String[] items = new String[]{"Altitude", "Grade", "CloudCover", "WindDirection", "WindSpeed", "Pressure", "PressVar3h", "WeatherPast1", "WeatherPast2", "Precipitation6h", "LowCloudShape", "LowCloudAmount", "LowCloudHeight", "DewPoint", "Visibility", "WeatherNow", "Temperature", "MiddleCloudShape", "HighCloudShape"};
        this._varList = Arrays.asList(items);
        this._fieldList.addAll(Arrays.asList("Stid", "Longitude", "Latitude"));
        this._fieldList.addAll(this._varList);
        this.setMissingValue(9999.0);
        this.setDataType(MeteoDataType.MICAPS_1);
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataInfo(String fileName) {
        BufferedReader sr = null;
        try {
            String[] dataArray;
            int year;
            String aLine;
            this.setFileName(fileName);
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "gbk"));
            this.addAttribute(new Attribute("data_format", "MICAPS 1"));
            this._description = aLine = sr.readLine().trim();
            if (aLine.contains("\u81ea\u52a8")) {
                this._isAutoStation = true;
            }
            if ((aLine = sr.readLine().trim()).isEmpty()) {
                aLine = sr.readLine();
            }
            if ((year = Integer.parseInt((dataArray = aLine.split("\\s+"))[0])) < 100) {
                year = year < 50 ? 2000 + year : 1900 + year;
            }
            LocalDateTime time = LocalDateTime.of(year, Integer.parseInt(dataArray[1]), Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[3]), 0, 0);
            this.addAttribute(new Attribute("time", time));
            Dimension tdim = new Dimension(DimensionType.T);
            tdim.setName("time");
            tdim.setValue(time);
            this.setTimeDimension(tdim);
            if (dataArray.length >= 5) {
                this._stNum = Integer.parseInt(dataArray[4]);
            } else {
                aLine = sr.readLine().trim();
                if (aLine.isEmpty()) {
                    aLine = sr.readLine();
                }
                if ((dataArray = aLine.split("\\s+")).length == 1) {
                    this._stNum = Integer.parseInt(dataArray[0]);
                }
            }
            Dimension stdim = new Dimension(DimensionType.OTHER);
            stdim.setShortName("station");
            double[] values = new double[this._stNum];
            Array stations = this.readStid();
            stdim.setDimValue(stations);
            this.addDimension(stdim);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            for (String vName : this._fieldList) {
                Variable var = new Variable();
                var.setName(vName);
                DataType dt = DataType.FLOAT;
                switch (vName) {
                    case "Stid": {
                        dt = DataType.STRING;
                        break;
                    }
                    case "Grade": 
                    case "CloudCover": 
                    case "WeatherPast1": 
                    case "WeatherPast2": 
                    case "WeatherNow": 
                    case "MiddleCloudShape": 
                    case "HighCloudShape": {
                        dt = DataType.INT;
                    }
                }
                var.setDataType(dt);
                var.setStation(true);
                var.setDimension(stdim);
                variables.add(var);
            }
            this.setVariables(variables);
            for (Dimension dim : this.dimensions) {
                Variable variable = new Variable(dim.getName());
                variable.setDimVar(true);
                variable.setCachedData(dim.getDimValue());
                variable.addDimension(dim);
                this.addCoordinate(variable);
            }
            int dataNum = 0;
            do {
                if ((aLine = sr.readLine()) == null) {
                } else {
                    int n;
                    if ((aLine = aLine.trim()).isEmpty()) continue;
                    dataArray = aLine.split("\\s+");
                    ArrayList<String> aList = new ArrayList<String>();
                    aList.addAll(Arrays.asList(dataArray));
                    for (n = 0; n <= 10 && aList.size() < 24 && (aLine = sr.readLine()) != null; ++n) {
                        for (String str : dataArray = aLine.split("\\s+")) {
                            if (str.isEmpty()) continue;
                            aList.add(str);
                        }
                    }
                    if (aList.size() < 24) {
                    } else {
                        for (n = 0; n < 10; ++n) {
                            aList.remove(aList.size() - 1);
                            if (aList.size() == 22) break;
                        }
                        if (dataNum == 0) {
                            boolean bl = this._hasAllCols = dataArray.length == 26;
                        }
                        if (++dataNum != 1) continue;
                        this._varNum = aList.size();
                    }
                }
                break;
            } while (aLine != null);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<String>> readData() {
        BufferedReader sr = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFileName()), "gbk"));
            String[] dataList = new ArrayList();
            sr.readLine();
            String aLine = sr.readLine().trim();
            if (aLine.isEmpty()) {
                sr.readLine();
            }
            while ((aLine = sr.readLine()) != null) {
                if (!(aLine = aLine.trim()).isEmpty()) {
                    int n;
                    String[] dataArray = aLine.split("\\s+");
                    ArrayList<String> aList = new ArrayList<String>();
                    aList.addAll(Arrays.asList(dataArray));
                    for (n = 0; n <= 10 && aList.size() < 24 && (aLine = sr.readLine()) != null; ++n) {
                        for (String str : dataArray = aLine.split("\\s+")) {
                            if (str.isEmpty()) continue;
                            aList.add(str);
                        }
                    }
                    if (aList.size() < 24) break;
                    for (n = 0; n < 10; ++n) {
                        aList.remove(aList.size() - 1);
                        if (aList.size() == 22) break;
                    }
                    dataList.add(aList);
                }
                if (aLine != null) continue;
            }
            String[] stringArray = dataList;
            return stringArray;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            List<List<String>> list = null;
            return list;
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            List<List<String>> list = null;
            return list;
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Array readStid() {
        BufferedReader sr = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFileName()), "gbk"));
            Array data = Array.factory((DataType)DataType.STRING, (int[])new int[]{this._stNum});
            IndexIterator iter = data.getIndexIterator();
            sr.readLine();
            String aLine = sr.readLine().trim();
            if (aLine.isEmpty()) {
                sr.readLine();
            }
            while ((aLine = sr.readLine()) != null) {
                if (!(aLine = aLine.trim()).isEmpty()) {
                    String[] dataArray = aLine.split("\\s+");
                    if (!iter.hasNext()) break;
                    iter.setStringNext(dataArray[0]);
                    for (int n = 0; n <= 10 && dataArray.length < 24 && (aLine = sr.readLine()) != null; ++n) {
                    }
                }
                if (aLine != null) continue;
            }
            Array array = data;
            return array;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            Array array = null;
            return array;
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            Array array = null;
            return array;
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "Description: " + this._description;
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00");
        dataInfo = dataInfo + System.getProperty("line.separator") + "Time: " + format.format(this.getTimes().getDate(0));
        dataInfo = dataInfo + System.getProperty("line.separator") + super.generateInfoText();
        return dataInfo;
    }

    @Override
    public Array realRead(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.realRead(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array realRead(String varName, int[] origin, int[] size, int[] stride) {
        int varIdx = this._fieldList.indexOf(varName);
        if (varIdx < 0) {
            return null;
        }
        DataType dt = DataType.FLOAT;
        switch (varName) {
            case "Stid": {
                dt = DataType.STRING;
                break;
            }
            case "Grade": 
            case "CloudCover": 
            case "WeatherPast1": 
            case "WeatherPast2": 
            case "WeatherNow": 
            case "MiddleCloudShape": 
            case "HighCloudShape": {
                dt = DataType.INT;
            }
        }
        int[] shape = new int[]{this._stNum};
        Array r = Array.factory((DataType)dt, (int[])shape);
        List<List<String>> allDataList = this.readData();
        block23: for (int i = 0; i < allDataList.size(); ++i) {
            List<String> dataList = allDataList.get(i);
            switch (dt) {
                case STRING: {
                    r.setObject(i, (Object)dataList.get(varIdx));
                    continue block23;
                }
                case INT: {
                    int vi = Integer.parseInt(dataList.get(varIdx));
                    r.setInt(i, vi);
                    continue block23;
                }
                case FLOAT: {
                    try {
                        float v = Float.parseFloat(dataList.get(varIdx));
                        if (varIdx == 8 && !MIMath.doubleEquals((double)v, (double)this.getMissingValue())) {
                            v = v > 800.0f ? v / 10.0f + 900.0f : v / 10.0f + 1000.0f;
                        }
                        r.setFloat(i, v);
                        continue block23;
                    }
                    catch (Exception e) {
                        r.setFloat(i, Float.NaN);
                    }
                }
            }
        }
        try {
            r = r.section(origin, shape, stride);
            if (r.getDataType().isNumeric()) {
                ArrayMath.missingToNaN((Array)r, (Number)this.missingValue);
            }
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return r;
    }

    public DataFrame readDataFrame() {
        List<List<String>> allDataList = this.readData();
        ArrayList<Array> data = new ArrayList<Array>();
        ColumnIndex columns = new ColumnIndex();
        Iterator<String> iterator = this._fieldList.iterator();
        block20: while (iterator.hasNext()) {
            DataType dtype;
            String vName;
            switch (vName = iterator.next()) {
                case "Stid": {
                    continue block20;
                }
                case "Grade": 
                case "CloudCover": 
                case "WeatherPast1": 
                case "WeatherPast2": 
                case "WeatherNow": 
                case "MiddleCloudShape": 
                case "HighCloudShape": {
                    dtype = DataType.INT;
                    break;
                }
                default: {
                    dtype = DataType.FLOAT;
                }
            }
            columns.add((Object)new Column(vName, dtype));
            data.add(Array.factory((DataType)dtype, (int[])new int[]{allDataList.size()}));
        }
        ArrayList<String> idxList = new ArrayList<String>();
        for (int i = 0; i < allDataList.size(); ++i) {
            List<String> dataList = allDataList.get(i);
            idxList.add(dataList.get(0));
            block22: for (int j = 0; j < data.size(); ++j) {
                Array dd = (Array)data.get(j);
                switch (dd.getDataType()) {
                    case INT: {
                        dd.setInt(i, Integer.parseInt(dataList.get(j + 1)));
                        continue block22;
                    }
                    case FLOAT: {
                        try {
                            float v = Float.parseFloat(dataList.get(j + 1));
                            if (j + 1 == 8 && !MIMath.doubleEquals((double)v, (double)this.getMissingValue())) {
                                v = v > 800.0f ? v / 10.0f + 900.0f : v / 10.0f + 1000.0f;
                            }
                            dd.setFloat(i, v);
                            continue block22;
                        }
                        catch (Exception e) {
                            dd.setFloat(i, Float.NaN);
                        }
                    }
                }
            }
        }
        for (Array a : data) {
            ArrayMath.missingToNaN((Array)a, (Number)9999);
        }
        Index index = Index.factory(idxList);
        DataFrame df = new DataFrame(data, index, columns);
        return df;
    }

    public DataTable readTable() {
        List<List<String>> allDataList = this.readData();
        DataTable dTable = new DataTable();
        Iterator<String> iterator = this._fieldList.iterator();
        while (iterator.hasNext()) {
            DataType dtype;
            String vName;
            switch (vName = iterator.next()) {
                case "Stid": {
                    dtype = DataType.STRING;
                    break;
                }
                case "Grade": 
                case "CloudCover": 
                case "WeatherPast1": 
                case "WeatherPast2": 
                case "WeatherNow": 
                case "MiddleCloudShape": 
                case "HighCloudShape": {
                    dtype = DataType.INT;
                    break;
                }
                default: {
                    dtype = DataType.FLOAT;
                }
            }
            try {
                dTable.addColumn(vName, dtype);
            }
            catch (Exception ex) {
                Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        int nCol = dTable.getColumnCount();
        for (int i = 0; i < allDataList.size(); ++i) {
            List<String> dataList = allDataList.get(i);
            try {
                dTable.addRow();
                for (int j = 0; j < nCol; ++j) {
                    dTable.setValue(i, j, (Object)dataList.get(j));
                }
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(MICAPS1DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return dTable;
    }

    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        int varIdx = this.getVariableIndex(varName);
        List<List<String>> allDataList = this.readData();
        double[][] discreteData = new double[allDataList.size()][3];
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        ArrayList<String> stations = new ArrayList<String>();
        for (int i = 0; i < allDataList.size(); ++i) {
            float t;
            List<String> dataList = allDataList.get(i);
            String aStid = dataList.get(0);
            float lon = Float.parseFloat(dataList.get(1));
            float lat = Float.parseFloat(dataList.get(2));
            try {
                t = Float.parseFloat(dataList.get(varIdx));
                if (varIdx == 8 && !MIMath.doubleEquals((double)t, (double)this.getMissingValue())) {
                    t = t > 800.0f ? t / 10.0f + 900.0f : t / 10.0f + 1000.0f;
                }
            }
            catch (Exception e) {
                t = Float.NaN;
            }
            stations.add(aStid);
            discreteData[i][0] = lon;
            discreteData[i][1] = lat;
            discreteData[i][2] = t;
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
                continue;
            }
            if (minX > lon) {
                minX = lon;
            } else if (maxX < lon) {
                maxX = lon;
            }
            if (minY > lat) {
                minY = lat;
                continue;
            }
            if (!(maxY < lat)) continue;
            maxY = lat;
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        StationData stData = new StationData();
        stData.data = discreteData;
        stData.stations = stations;
        stData.dataExtent = dataExtent;
        stData.missingValue = this.getMissingValue();
        return stData;
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        StationInfoData stInfoData = new StationInfoData();
        List<List<String>> allDataList = this.readData();
        stInfoData.setDataList(allDataList);
        stInfoData.setFields(this._fieldList);
        stInfoData.setVariables(this._varList);
        ArrayList<String> stations = new ArrayList<String>();
        int stNum = allDataList.size();
        for (int i = 0; i < stNum; ++i) {
            stations.add(allDataList.get(i).get(0));
        }
        stInfoData.setStations(stations);
        return stInfoData;
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        StationModelData smData = new StationModelData();
        ArrayList<StationModel> smList = new ArrayList<StationModel>();
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        List<List<String>> allDataList = this.readData();
        for (int i = 0; i < allDataList.size(); ++i) {
            List<String> dataList = allDataList.get(i);
            String aStid = dataList.get(0);
            float lon = Float.parseFloat(dataList.get(1));
            float lat = Float.parseFloat(dataList.get(2));
            StationModel sm = new StationModel();
            sm.setStationIdentifer(aStid);
            sm.setLongitude(lon);
            sm.setLatitude(lat);
            sm.setWindDirection(Double.parseDouble(dataList.get(6)));
            sm.setWindSpeed(Double.parseDouble(dataList.get(7)));
            sm.setVisibility(Double.parseDouble(dataList.get(17)));
            sm.setWeather(Double.parseDouble(dataList.get(18)));
            sm.setCloudCover(Double.parseDouble(dataList.get(5)));
            sm.setTemperature(Double.parseDouble(dataList.get(19)));
            sm.setDewPoint(Double.parseDouble(dataList.get(16)));
            double press = Double.parseDouble(dataList.get(8));
            if (MIMath.doubleEquals((double)press, (double)this.getMissingValue())) {
                sm.setPressure(press);
            } else if (press > 800.0) {
                sm.setPressure(press / 10.0 + 900.0);
            } else {
                sm.setPressure(press / 10.0 + 1000.0);
            }
            smList.add(sm);
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
                continue;
            }
            if (minX > lon) {
                minX = lon;
            } else if (maxX < lon) {
                maxX = lon;
            }
            if (minY > lat) {
                minY = lat;
                continue;
            }
            if (!(maxY < lat)) continue;
            maxY = lat;
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        smData.setData(smList);
        smData.setDataExtent(dataExtent);
        smData.setMissingValue(this.getMissingValue());
        return smData;
    }
}

