/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import us.hebi.matlab.mat.format.CharEncoding;
import us.hebi.matlab.mat.format.Charsets;
import us.hebi.matlab.mat.format.Compat;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5Subsystem;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.types.AbstractMatFile;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.util.Bytes;
import us.hebi.matlab.mat.util.Preconditions;

public class Mat5File
extends AbstractMatFile {
    private final String description;
    private final long subsysOffset;
    private final ByteOrder byteOrder;
    private final short version;
    private final boolean reduced;
    private static final String MATLAB_IDENTIFIER = "MATLAB";
    private static final String MAT5_IDENTIFIER = "MATLAB 5.0 MAT-file";
    private static final String MAT73_IDENTIFIER = "MATLAB 7.3 MAT-file";

    public static Mat5File readFileHeader(Source source) throws IOException {
        return Mat5File.readFileHeader(source, false);
    }

    public static Mat5File readReducedFileHeader(Source source) throws IOException {
        return Mat5File.readFileHeader(source, true);
    }

    private static Mat5File readFileHeader(Source source, boolean reducedHeader) throws IOException {
        String description = "";
        long subsysOffset = 0L;
        if (!reducedHeader) {
            byte[] buffer = new byte[116];
            source.readBytes(buffer, 0, buffer.length);
            description = CharEncoding.parseAsciiString(buffer, 0, buffer.length);
            Mat5File.checkMat5Identifier(description);
            subsysOffset = source.readLong();
        }
        short version = Short.reverseBytes(source.readShort());
        ByteOrder order = source.order();
        short endianIndicator = source.readShort();
        switch (endianIndicator) {
            case 19785: {
                break;
            }
            case 18765: {
                order = Bytes.reverseByteOrder(order);
                subsysOffset = Long.reverseBytes(subsysOffset);
                version = Short.reverseBytes(version);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid endian indicator");
            }
        }
        if (reducedHeader) {
            source.skip(4L);
        }
        return new Mat5File(reducedHeader, description, subsysOffset, order, version);
    }

    public void writeFileHeader(Sink sink) throws IOException {
        if (!this.hasReducedHeader()) {
            Mat5File.checkMat5Identifier(this.getDescription());
            byte[] bytes = this.getDescription().getBytes(Charsets.US_ASCII);
            int remaining = 116 - bytes.length;
            sink.writeBytes(bytes, 0, Math.min(116, bytes.length));
            if (remaining > 0) {
                byte[] buffer = new byte[remaining];
                Arrays.fill(buffer, (byte)0);
                sink.writeBytes(buffer, 0, buffer.length);
            } else if (remaining < 0) {
                String msg = "Warning: Description is " + -remaining + " bytes too long and will be concatenated.";
                System.err.println(msg);
            }
            sink.writeLong(this.getSubsysOffset());
        }
        sink.writeShort(Short.reverseBytes(this.getVersion()));
        sink.writeShort((short)19785);
        if (this.hasReducedHeader()) {
            sink.writeInt(0);
        }
    }

    static void updateSubsysOffset(long headerStart, long subsysStart, Sink sink) throws IOException {
        long currentPosition = sink.position();
        sink.position(headerStart + 116L);
        sink.writeLong(subsysStart - headerStart);
        sink.position(currentPosition);
    }

    public static String getDefaultDescription() {
        return ", Platform: " + System.getProperty("os.name") + ", Created on: " + new Date().toString();
    }

    protected Mat5File() {
        this(Mat5File.getDefaultDescription());
    }

    protected Mat5File(String description) {
        this.description = MAT5_IDENTIFIER + description;
        this.subsysOffset = 0L;
        this.byteOrder = ByteOrder.nativeOrder();
        this.version = 1;
        this.reduced = false;
    }

    private Mat5File(boolean reduced, String description, long subsysOffset, ByteOrder byteOrder, short version) {
        this.reduced = reduced;
        this.description = description;
        this.subsysOffset = subsysOffset;
        this.byteOrder = byteOrder;
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public long getSubsysOffset() {
        return this.subsysOffset;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public short getVersion() {
        return this.version;
    }

    public boolean hasReducedHeader() {
        return this.reduced;
    }

    @Override
    public String toString() {
        return "Mat5File{description='" + this.description + '\'' + ", subsysOffset=" + this.subsysOffset + ", byteOrder=" + this.byteOrder + ", version=" + this.version + "}\n" + super.toString();
    }

    @Override
    public long getUncompressedSerializedSize() {
        long size = this.reduced ? 8L : 128L;
        for (MatFile.Entry entry : this.entries) {
            size += (long)Mat5WriteUtil.computeArraySize(entry.getName(), entry.getValue());
        }
        if (this.getSubsystem() != null) {
            size += (long)Mat5WriteUtil.computeArraySize(this.subsystem.getName(), this.subsystem.getValue());
        }
        return size;
    }

    @Override
    public Mat5File writeTo(Sink sink) throws IOException {
        Mat5.newWriter(sink).writeMat((MatFile)this);
        return this;
    }

    @Override
    public Mat5File addEntry(MatFile.Entry entry) {
        if (this.reduced && this.getNumEntries() >= 2) {
            throw new IllegalStateException("Reduced MAT 5 files may not contain more than 2 entries");
        }
        if (entry.getValue() instanceof Mat5Subsystem) {
            Preconditions.checkState(this.subsystem == null, "mat file already contains a subsystem");
            this.subsystem = entry;
        } else {
            this.entries.add(entry);
        }
        this.lookup.put(entry.getName(), entry.getValue());
        return this;
    }

    private static void checkMat5Identifier(String description) {
        if (!description.startsWith(MAT5_IDENTIFIER)) {
            if (description.startsWith(MAT73_IDENTIFIER)) {
                throw new IllegalArgumentException("This file was saved using the unsupported MATLAB 7.3 MAT-file version ('-v7.3' flag). Only files saved with the '-v7' version flag can be loaded.");
            }
            if (description.startsWith(MATLAB_IDENTIFIER)) {
                throw new IllegalArgumentException("This file was saved using an unknown MAT-file format. Only files saved with the '-v7' version flag can be loaded.");
            }
            throw new IllegalArgumentException("The input is not a valid MATLAB 5.0 MAT-file.");
        }
    }

    @Override
    protected int subHashCode() {
        return Compat.hash(this.description, this.subsysOffset, this.byteOrder, this.version, this.reduced);
    }

    @Override
    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        Mat5File other = (Mat5File)otherGuaranteedSameClass;
        return Compat.equals(other.description, this.description) && Compat.equals(other.subsysOffset, this.subsysOffset) && Compat.equals(other.byteOrder, this.byteOrder) && Compat.equals(other.version, this.version) && Compat.equals(other.reduced, this.reduced);
    }
}

