/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.types.AbstractArray;
import us.hebi.matlab.mat.types.FunctionHandle;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.types.Struct;

class MatFunction
extends AbstractArray
implements FunctionHandle,
Mat5Serializable {
    final Struct content;

    MatFunction(Struct content) {
        super(new int[]{1, 1});
        this.content = content;
    }

    @Override
    public MatlabType getType() {
        return MatlabType.Function;
    }

    @Override
    public Struct getContent() {
        return this.content;
    }

    @Override
    public int getMat5Size(String name) {
        return 8 + Mat5WriteUtil.computeArrayHeaderSize(name, this) + Mat5WriteUtil.computeArraySize(this.getContent());
    }

    @Override
    public void writeMat5(String name, boolean isGlobal, Sink sink) throws IOException {
        Mat5WriteUtil.writeMatrixTag(name, this, sink);
        Mat5WriteUtil.writeArrayHeader(name, isGlobal, this, sink);
        Mat5WriteUtil.writeNestedArray(this.content, sink);
    }

    @Override
    public void close() throws IOException {
        this.content.close();
    }

    @Override
    protected int subHashCode() {
        return this.content.hashCode();
    }

    @Override
    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        MatFunction other = (MatFunction)otherGuaranteedSameClass;
        return other.content.equals(this.content);
    }
}

