/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.lab.gui;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.intern.CDockable;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.common.colors.ColorUtil;
import org.meteoinfo.console.ConsoleExecEvent;
import org.meteoinfo.console.IConsoleExecListener;
import org.meteoinfo.console.editor.TextEditor;
import org.meteoinfo.console.jython.PythonInteractiveInterpreter;
import org.meteoinfo.lab.Options;
import org.meteoinfo.lab.application.AppCollection;
import org.meteoinfo.lab.application.Application;
import org.meteoinfo.lab.event.CurrentPathChangedEvent;
import org.meteoinfo.lab.event.ICurrentPathChangedListener;
import org.meteoinfo.lab.gui.ConsoleDockable;
import org.meteoinfo.lab.gui.CustomWindowFactory;
import org.meteoinfo.lab.gui.EditorDockable;
import org.meteoinfo.lab.gui.FigureDockable;
import org.meteoinfo.lab.gui.FileDockable;
import org.meteoinfo.lab.gui.FrmAbout;
import org.meteoinfo.lab.gui.FrmAppsManager;
import org.meteoinfo.lab.gui.FrmFindReplace;
import org.meteoinfo.lab.gui.FrmSetting;
import org.meteoinfo.lab.gui.VariableDockable;
import org.meteoinfo.ui.ColorListCellRender;
import org.meteoinfo.ui.plugin.IApplication;
import org.meteoinfo.ui.plugin.IPlugin;
import org.python.core.PyInstance;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;
import org.xml.sax.SAXException;

public class FrmMain
extends JFrame
implements IApplication {
    private final EditorDockable editorDock;
    private final ConsoleDockable consoleDock;
    private final FigureDockable figuresDock;
    private final VariableDockable variableDock;
    private final FileDockable fileDock;
    private String startupPath;
    private Options options = new Options();
    private AppCollection apps = new AppCollection();
    private List<String> loadObjects = new ArrayList<String>();
    private JButton jButton_CurrentFolder;
    private JButton jButton_NewFile;
    private JButton jButton_OpenFile;
    private JButton jButton_Redo;
    private JButton jButton_RunScript;
    private JButton jButton_SaveAs;
    private JButton jButton_SaveFile;
    private JButton jButton_Undo;
    private JComboBox jComboBox_CurrentFolder;
    private JLabel jLabel1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem_About;
    private JMenuItem jMenuItem_AppsManager;
    private JMenuItem jMenuItem_CloseAllFiles;
    private JMenuItem jMenuItem_ColorDialog;
    private JMenuItem jMenuItem_ColorMaps;
    private JMenuItem jMenuItem_Comment;
    private JMenuItem jMenuItem_Copy;
    private JMenuItem jMenuItem_Cut;
    private JMenuItem jMenuItem_DeleteTab;
    private JMenuItem jMenuItem_Exit;
    private JMenuItem jMenuItem_FindReplace;
    private JMenuItem jMenuItem_Help;
    private JMenuItem jMenuItem_InsertTab;
    private JMenuItem jMenuItem_NewFile;
    private JMenuItem jMenuItem_OpenFile;
    private JMenuItem jMenuItem_Paste;
    private JMenuItem jMenuItem_SaveAs;
    private JMenuItem jMenuItem_SaveFile;
    private JMenuItem jMenuItem_Setting;
    private JMenu jMenu_Apps;
    private JMenu jMenu_Editor;
    private JMenu jMenu_File;
    private JMenu jMenu_Help;
    private JMenu jMenu_Options;
    private JPanel jPanel_Status;
    private JPanel jPanel_Toolbar;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JToolBar jToolBar_CurrentFolder;
    private JToolBar jToolBar_Editor;
    private JProgressBar jProgressBar_Run;
    private JProgressBar jProgressBar_Memory;

    public FrmMain(String startupPath, Options options) {
        String appConfFn;
        this.initComponents();
        this.startupPath = startupPath;
        this.options = options;
        boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
        System.out.println("Set icon image...");
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/MeteoLab_32.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setIconImage(image);
        this.setLocation(this.options.getMainFormLocation());
        this.setSize(this.options.getMainFormSize());
        this.jComboBox_CurrentFolder.removeAllItems();
        for (String cf : this.options.getRecentFolders()) {
            if (!new File(cf).isDirectory()) continue;
            this.jComboBox_CurrentFolder.addItem(cf);
        }
        String cf = this.options.getCurrentFolder();
        if (cf != null) {
            if (!new File(cf).isDirectory()) {
                cf = this.startupPath;
                this.options.setCurrentFolder(cf);
            }
            if (!this.options.getRecentFolders().contains(cf)) {
                this.jComboBox_CurrentFolder.addItem(cf);
            }
            this.jComboBox_CurrentFolder.setSelectedItem(cf);
        }
        System.out.println("Add dockable panels...");
        CControl control = new CControl((JFrame)this);
        this.add((Component)control.getContentArea());
        if (this.options.isDockWindowDecorated()) {
            control.putProperty(ScreenDockStation.WINDOW_FACTORY, (Object)new CustomWindowFactory());
        }
        control.setTheme("flat");
        control.getIcons().setIconClient("locationmanager.minimize", (Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/minimize.svg"));
        control.getIcons().setIconClient("locationmanager.maximize", (Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/maximize.svg"));
        control.getIcons().setIconClient("locationmanager.externalize", (Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/outgoing.svg"));
        control.getIcons().setIconClient("locationmanager.unexternalize", (Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/incoming.svg"));
        control.getIcons().setIconClient("locationmanager.normalize", (Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/restore.svg"));
        control.getIcons().setIconClient("locationmanager.unmaximize_externalized", (Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/restore.svg"));
        System.out.println("Editor and Console panels...");
        CGrid grid = new CGrid(control);
        this.consoleDock = new ConsoleDockable(this, this.startupPath, "Console", "Console", new CAction[0]);
        this.consoleDock.getConsole().setFont(this.options.getTextFont());
        this.editorDock = new EditorDockable(this, "Editor", "Editor", new CAction[0]);
        this.editorDock.setInterp((PythonInterpreter)this.consoleDock.getInterpreter());
        this.editorDock.addNewTextEditor("New file");
        this.editorDock.openFiles(this.options.getOpenedFiles());
        this.editorDock.setTextFont(this.options.getTextFont());
        System.out.println("Load toolbox applications...");
        String toolboxPath = this.startupPath + File.separator + "toolbox";
        if (this.startupPath.endsWith("meteoinfo-lab")) {
            Path path = new File(this.startupPath).toPath();
            path = path.getParent();
            Object toolPath = path.getParent();
            if (!(toolPath = toolPath.resolve(Paths.get("toolbox", new String[0]))).toFile().isDirectory()) {
                toolPath = path.resolve(Paths.get("auxdata", "toolbox"));
            }
            toolboxPath = toolPath.toString();
        }
        if (new File(appConfFn = toolboxPath + File.separator + "apps.xml").exists()) {
            try {
                this.apps.setPluginPath(toolboxPath);
                this.apps.loadConfigFile(appConfFn);
                if (this.apps.size() > 0) {
                    for (Application app : this.apps) {
                        if (!app.isLoad()) continue;
                        this.loadApplication(app);
                    }
                }
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParserConfigurationException | SAXException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        final PythonInteractiveInterpreter interp = this.consoleDock.getInterpreter();
        PyStringMap locals = (PyStringMap)interp.getLocals();
        PyList items = locals.items();
        for (Object a : items) {
            PyTuple at = (PyTuple)a;
            String name = at.__getitem__(0).toString();
            this.loadObjects.add(name);
        }
        interp.addConsoleExecListener(new IConsoleExecListener(){

            public void consoleExecEvent(ConsoleExecEvent event) {
                PyStringMap locals = (PyStringMap)interp.getLocals();
                PyList items = locals.items();
                ArrayList<Object[]> vars = new ArrayList<Object[]>();
                for (Object a : items) {
                    String value;
                    String className;
                    PyTuple at = (PyTuple)a;
                    String name = at.__getitem__(0).toString();
                    if (FrmMain.this.loadObjects.contains(name)) continue;
                    PyObject var = at.__getitem__(1);
                    if (var instanceof PyInstance) {
                        switch (className = ((PyInstance)var).instclass.__name__) {
                            case "DimArray": 
                            case "NDArray": {
                                value = var.__len__() <= 10 ? var.__str__().toString() : "";
                                vars.add(new Object[]{name, className, var.__getattr__("sizestr"), value});
                                break;
                            }
                            default: {
                                vars.add(new Object[]{name, className, "", ""});
                                break;
                            }
                        }
                        continue;
                    }
                    if (var instanceof PyType || var instanceof PyJavaType) continue;
                    className = var.getClass().getSimpleName();
                    value = "";
                    String size = "";
                    boolean isAdd = true;
                    switch (className) {
                        case "PyInteger": 
                        case "PyFloat": 
                        case "PyString": {
                            value = var.toString();
                            size = "1";
                            break;
                        }
                        case "PyList": 
                        case "PyTuple": {
                            if (var.__len__() <= 10) {
                                value = var.toString();
                            }
                            size = String.valueOf(var.__len__());
                            break;
                        }
                        case "PyObjectDerived": {
                            switch (className = var.getType().getName()) {
                                case "DimArray": 
                                case "NDArray": {
                                    value = var.__len__() <= 10 ? var.__str__().toString() : "";
                                    size = var.__getattr__("shape").toString();
                                }
                            }
                            break;
                        }
                        default: {
                            isAdd = false;
                        }
                    }
                    if (!isAdd) continue;
                    vars.add(new Object[]{name, className, size, value});
                }
                if (FrmMain.this.variableDock != null) {
                    FrmMain.this.variableDock.getVariableExplorer().updateVariables(vars);
                }
            }
        });
        System.out.println("Add figure panel...");
        this.figuresDock = new FigureDockable(this, "Figures", "Figures", new CAction[0]);
        this.figuresDock.setDoubleBuffer(this.options.isDoubleBuffer());
        this.variableDock = new VariableDockable("Variables", "Variable explorer", new CAction[0]);
        System.out.println("Add file panel...");
        this.fileDock = new FileDockable("Files", "File explorer", new CAction[0]);
        if (cf != null) {
            this.fileDock.setPath(new File(cf));
        }
        this.fileDock.getFileExplorer().addCurrentPathChangedListener(new ICurrentPathChangedListener(){

            @Override
            public void currentPathChangedEvent(CurrentPathChangedEvent event) {
                FrmMain.this.setCurrentPath(FrmMain.this.fileDock.getFileExplorer().getPath().getAbsolutePath());
            }
        });
        this.fileDock.getFileExplorer().getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                File file = null;
                int row = ((JTable)e.getSource()).getSelectedRow();
                if (row >= 0 && ((JTable)e.getSource()).getValueAt(row, 2).toString().equals("py")) {
                    file = new File(FrmMain.this.fileDock.getFileExplorer().getPath().getAbsoluteFile() + File.separator + ((JTable)e.getSource()).getValueAt(row, 0).toString());
                }
                if (e.getButton() == 3) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItemOpen = new JMenuItem("Open file");
                    final File finalFile = file;
                    jMenuItemOpen.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (finalFile != null) {
                                FrmMain.this.editorDock.openFile(finalFile);
                            }
                        }
                    });
                    jPopupMenu.add(jMenuItemOpen);
                    JMenuItem jMenuItemRun = new JMenuItem("Run file");
                    jMenuItemRun.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (finalFile != null) {
                                FrmMain.this.consoleDock.execJythonFile(finalFile.getAbsolutePath());
                            }
                        }
                    });
                    jPopupMenu.add(jMenuItemRun);
                    jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getClickCount() == 2 && file != null) {
                    FrmMain.this.editorDock.openFile(file);
                }
            }
        });
        grid.add(0.0, 0.0, 5.0, 5.0, new CDockable[]{this.editorDock});
        grid.add(0.0, 5.0, 5.0, 5.0, new CDockable[]{this.consoleDock});
        grid.add(5.0, 0.0, 5.0, 5.0, new CDockable[]{this.variableDock});
        grid.add(5.0, 0.0, 5.0, 5.0, new CDockable[]{this.fileDock});
        grid.add(5.0, 5.0, 5.0, 5.0, new CDockable[]{this.figuresDock});
        control.getContentArea().deploy(grid);
        System.out.println("Main form is loaded!");
        System.setOut(this.consoleDock.getConsole().getOut());
        System.setErr(this.consoleDock.getConsole().getOut());
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent ke) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                switch (ke.getKeyCode()) {
                    case 67: {
                        Thread myThread;
                        if (!ke.isControlDown() || (myThread = FrmMain.this.consoleDock.getMyThread()) == null) break;
                        myThread.stop();
                        Object var2_2 = null;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent ke) {
            }
        });
    }

    public AppCollection getApplications() {
        return this.apps;
    }

    public String getStartupPath() {
        return this.startupPath;
    }

    public Options getOptions() {
        return this.options;
    }

    public void loadApplication(Application plugin) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            PythonInteractiveInterpreter interp = this.getConsoleDockable().getInterpreter();
            String path = plugin.getPath();
            interp.exec("import " + path);
            interp.exec("from " + path + ".loadApp import LoadApp");
            PyObject loadClass = interp.get("LoadApp");
            PyObject loadObj = loadClass.__call__();
            IPlugin instance = (IPlugin)loadObj.__tojava__(IPlugin.class);
            instance.setApplication((IApplication)this);
            instance.setName(plugin.getName());
            plugin.setPluginObject(instance);
            plugin.setLoad(true);
            instance.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void unloadApplication(Application plugin) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (plugin.getPluginObject() != null) {
            plugin.getPluginObject().unload();
            plugin.setPluginObject(null);
            plugin.setLoad(false);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void initComponents() {
        this.jPanel_Toolbar = new JPanel();
        this.jToolBar_Editor = new JToolBar();
        this.jButton_NewFile = new JButton();
        this.jButton_OpenFile = new JButton();
        this.jButton_SaveFile = new JButton();
        this.jButton_SaveAs = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_Undo = new JButton();
        this.jButton_Redo = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_RunScript = new JButton();
        this.jToolBar_CurrentFolder = new JToolBar();
        this.jLabel1 = new JLabel();
        this.jComboBox_CurrentFolder = new JComboBox();
        this.jButton_CurrentFolder = new JButton();
        this.jPanel_Status = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu_File = new JMenu();
        this.jMenuItem_NewFile = new JMenuItem();
        this.jMenuItem_OpenFile = new JMenuItem();
        this.jMenuItem_SaveFile = new JMenuItem();
        this.jMenuItem_SaveAs = new JMenuItem();
        this.jMenuItem_CloseAllFiles = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItem_Exit = new JMenuItem();
        this.jMenu_Editor = new JMenu();
        this.jMenuItem_Cut = new JMenuItem();
        this.jMenuItem_Copy = new JMenuItem();
        this.jMenuItem_Paste = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItem_FindReplace = new JMenuItem();
        this.jMenuItem_Comment = new JMenuItem();
        this.jMenuItem_InsertTab = new JMenuItem();
        this.jMenuItem_DeleteTab = new JMenuItem();
        this.jMenu_Options = new JMenu();
        this.jMenuItem_Setting = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem_ColorMaps = new JMenuItem();
        this.jMenuItem_ColorDialog = new JMenuItem();
        this.jMenu_Apps = new JMenu();
        this.jMenuItem_AppsManager = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenu_Help = new JMenu();
        this.jMenuItem_About = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItem_Help = new JMenuItem();
        this.jProgressBar_Run = new JProgressBar();
        this.jProgressBar_Memory = new JProgressBar();
        this.setDefaultCloseOperation(3);
        this.setTitle("MeteoInfoLab");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrmMain.this.formWindowClosing(evt);
            }
        });
        this.jPanel_Toolbar.setLayout(new BorderLayout());
        this.jToolBar_Editor.setRollover(true);
        this.jToolBar_Editor.setPreferredSize(new Dimension(250, 25));
        this.jButton_NewFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/file-new.svg"));
        this.jButton_NewFile.setToolTipText("New File");
        this.jButton_NewFile.setFocusable(false);
        this.jButton_NewFile.setHorizontalTextPosition(0);
        this.jButton_NewFile.setVerticalTextPosition(3);
        this.jButton_NewFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_NewFileActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_NewFile);
        this.jButton_OpenFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/file-open.svg"));
        this.jButton_OpenFile.setToolTipText("Open File");
        this.jButton_OpenFile.setFocusable(false);
        this.jButton_OpenFile.setHorizontalTextPosition(0);
        this.jButton_OpenFile.setVerticalTextPosition(3);
        this.jButton_OpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_OpenFileActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_OpenFile);
        this.jButton_SaveFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/file-save.svg"));
        this.jButton_SaveFile.setToolTipText("Save File");
        this.jButton_SaveFile.setFocusable(false);
        this.jButton_SaveFile.setHorizontalTextPosition(0);
        this.jButton_SaveFile.setVerticalTextPosition(3);
        this.jButton_SaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_SaveFileActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_SaveFile);
        this.jButton_SaveAs.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/save-as.svg"));
        this.jButton_SaveAs.setToolTipText("Save As");
        this.jButton_SaveAs.setFocusable(false);
        this.jButton_SaveAs.setHorizontalTextPosition(0);
        this.jButton_SaveAs.setVerticalTextPosition(3);
        this.jButton_SaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_SaveAsActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_SaveAs);
        this.jToolBar_Editor.add(this.jSeparator1);
        this.jButton_Undo.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/undo.svg"));
        this.jButton_Undo.setToolTipText("Undo");
        this.jButton_Undo.setFocusable(false);
        this.jButton_Undo.setHorizontalTextPosition(0);
        this.jButton_Undo.setVerticalTextPosition(3);
        this.jButton_Undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_UndoActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_Undo);
        this.jButton_Redo.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/redo.svg"));
        this.jButton_Redo.setToolTipText("Redo");
        this.jButton_Redo.setFocusable(false);
        this.jButton_Redo.setHorizontalTextPosition(0);
        this.jButton_Redo.setVerticalTextPosition(3);
        this.jButton_Redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_RedoActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_Redo);
        this.jToolBar_Editor.add(this.jSeparator2);
        this.jButton_RunScript.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/execute.svg"));
        this.jButton_RunScript.setToolTipText("Run Script (F5)");
        this.jButton_RunScript.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_RunScriptActionPerformed(evt);
            }
        }, KeyStroke.getKeyStroke(116, 0), 2);
        this.jButton_RunScript.setFocusable(false);
        this.jButton_RunScript.setHorizontalTextPosition(0);
        this.jButton_RunScript.setVerticalTextPosition(3);
        this.jButton_RunScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_RunScriptActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_RunScript);
        this.jPanel_Toolbar.add((Component)this.jToolBar_Editor, "Before");
        this.jToolBar_CurrentFolder.setRollover(true);
        this.jLabel1.setText("Current Folder: ");
        this.jToolBar_CurrentFolder.add(this.jLabel1);
        this.jComboBox_CurrentFolder.setEditable(true);
        this.jComboBox_CurrentFolder.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_CurrentFolder.setPreferredSize(new Dimension(400, 21));
        this.jComboBox_CurrentFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jComboBox_CurrentFolderActionPerformed(evt);
            }
        });
        this.jToolBar_CurrentFolder.add(this.jComboBox_CurrentFolder);
        this.jButton_CurrentFolder.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/file-open.svg"));
        this.jButton_CurrentFolder.setFocusable(false);
        this.jButton_CurrentFolder.setHorizontalTextPosition(0);
        this.jButton_CurrentFolder.setVerticalTextPosition(3);
        this.jButton_CurrentFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_CurrentFolderActionPerformed(evt);
            }
        });
        this.jToolBar_CurrentFolder.add(this.jButton_CurrentFolder);
        this.jPanel_Toolbar.add((Component)this.jToolBar_CurrentFolder, "After");
        this.getContentPane().add((Component)this.jPanel_Toolbar, "North");
        this.jPanel_Status.setPreferredSize(new Dimension(588, 23));
        this.jPanel_Status.setLayout(new BorderLayout());
        this.jProgressBar_Run.setIndeterminate(true);
        this.jProgressBar_Run.setStringPainted(true);
        this.jProgressBar_Run.setString("Run...");
        this.jProgressBar_Run.setVisible(false);
        this.jPanel_Status.add((Component)this.jProgressBar_Run, "West");
        final float maxMemory = (float)((double)Runtime.getRuntime().maxMemory() / 1.073741824E9);
        this.jProgressBar_Memory.setStringPainted(true);
        this.jProgressBar_Memory.setString(String.format("%.1fG", Float.valueOf(maxMemory)));
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                int ratio = (int)((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) * 100.0 / (double)Runtime.getRuntime().maxMemory());
                FrmMain.this.jProgressBar_Memory.setValue(ratio);
                FrmMain.this.jProgressBar_Memory.setString(String.format("%d%% / %.1fG", ratio, Float.valueOf(maxMemory)));
            }
        }, 1000L, 1000L);
        this.jPanel_Status.add((Component)this.jProgressBar_Memory, "East");
        this.getContentPane().add((Component)this.jPanel_Status, "Last");
        this.jMenu_File.setText("File");
        this.jMenu_File.setMnemonic(70);
        this.jMenuItem_NewFile.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItem_NewFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/file-new.svg"));
        this.jMenuItem_NewFile.setText("New");
        this.jMenuItem_NewFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_NewFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_NewFile);
        this.jMenuItem_OpenFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem_OpenFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/file-open.svg"));
        this.jMenuItem_OpenFile.setText("Open ...");
        this.jMenuItem_OpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_OpenFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_OpenFile);
        this.jMenuItem_SaveFile.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem_SaveFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/file-save.svg"));
        this.jMenuItem_SaveFile.setText("Save");
        this.jMenuItem_SaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_SaveFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_SaveFile);
        this.jMenuItem_SaveAs.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/save-as.svg"));
        this.jMenuItem_SaveAs.setText("Save As ...");
        this.jMenuItem_SaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_SaveAsActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_SaveAs);
        this.jMenuItem_CloseAllFiles.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/file-close-all.svg"));
        this.jMenuItem_CloseAllFiles.setText("Close All Files");
        this.jMenuItem_CloseAllFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_CloseAllFilesActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_CloseAllFiles);
        this.jMenu_File.add(this.jSeparator3);
        this.jMenuItem_Exit.setText("Exit");
        this.jMenuItem_Exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_ExitActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_Exit);
        this.jMenuBar1.add(this.jMenu_File);
        this.jMenu_Editor.setMnemonic('E');
        this.jMenu_Editor.setText("Edit");
        this.jMenu_Editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenu_EditorActionPerformed(evt);
            }
        });
        this.jMenuItem_Cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuItem_Cut.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/menu-cut.svg"));
        this.jMenuItem_Cut.setText("Cut");
        this.jMenuItem_Cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_CutActionPerformed(evt);
            }
        });
        this.jMenu_Editor.add(this.jMenuItem_Cut);
        this.jMenuItem_Copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItem_Copy.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/copy.svg"));
        this.jMenuItem_Copy.setText("Copy");
        this.jMenuItem_Copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_CopyActionPerformed(evt);
            }
        });
        this.jMenu_Editor.add(this.jMenuItem_Copy);
        this.jMenuItem_Paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItem_Paste.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/menu-paste.svg"));
        this.jMenuItem_Paste.setText("Paste");
        this.jMenuItem_Paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_PasteActionPerformed(evt);
            }
        });
        this.jMenu_Editor.add(this.jMenuItem_Paste);
        this.jMenu_Editor.add(this.jSeparator6);
        this.jMenuItem_FindReplace.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.jMenuItem_FindReplace.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/find.svg"));
        this.jMenuItem_FindReplace.setText("Find & Replace");
        this.jMenuItem_FindReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_FindReplaceActionPerformed(evt);
            }
        });
        this.jMenu_Editor.add(this.jMenuItem_FindReplace);
        this.jMenuItem_Comment.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.jMenuItem_Comment.setText("Toggle Comment");
        this.jMenuItem_Comment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_CommentActionPerformed(evt);
            }
        });
        this.jMenu_Editor.add(this.jMenuItem_Comment);
        this.jMenuItem_InsertTab.setAccelerator(KeyStroke.getKeyStroke(9, 0));
        this.jMenuItem_InsertTab.setText("Insert Tab (4 spaces)");
        this.jMenuItem_InsertTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_InsertTabActionPerformed(evt);
            }
        });
        this.jMenu_Editor.add(this.jMenuItem_InsertTab);
        this.jMenuItem_DeleteTab.setAccelerator(KeyStroke.getKeyStroke(9, 1));
        this.jMenuItem_DeleteTab.setText("Delete Tab (4 spaces)");
        this.jMenuItem_DeleteTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_DeleteTabActionPerformed(evt);
            }
        });
        this.jMenu_Editor.add(this.jMenuItem_DeleteTab);
        this.jMenuBar1.add(this.jMenu_Editor);
        this.jMenu_Options.setMnemonic(79);
        this.jMenu_Options.setText("Options");
        this.jMenuItem_Setting.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/gear.svg"));
        this.jMenuItem_Setting.setText("Setting");
        this.jMenuItem_Setting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_SettingActionPerformed(evt);
            }
        });
        this.jMenu_Options.add(this.jMenuItem_Setting);
        this.jMenu_Options.add(this.jSeparator4);
        this.jMenuItem_ColorMaps.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/color-wheel.svg"));
        this.jMenuItem_ColorMaps.setText("Color Maps");
        this.jMenuItem_ColorMaps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_ColorMapsActionPerformed(evt);
            }
        });
        this.jMenu_Options.add(this.jMenuItem_ColorMaps);
        this.jMenuItem_ColorDialog.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/colors.svg"));
        this.jMenuItem_ColorDialog.setText("Color Dialog");
        this.jMenuItem_ColorDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_ColorDialogActionPerformed(evt);
            }
        });
        this.jMenu_Options.add(this.jMenuItem_ColorDialog);
        this.jMenuBar1.add(this.jMenu_Options);
        this.jMenu_Apps.setText("Apps");
        this.jMenu_Apps.setMnemonic(65);
        this.jMenuItem_AppsManager.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/toolbox.svg"));
        this.jMenuItem_AppsManager.setText("Application Manager");
        this.jMenuItem_AppsManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_AppsManagerActionPerformed(evt);
            }
        });
        this.jMenu_Apps.add(this.jMenuItem_AppsManager);
        this.jMenu_Apps.add(this.jSeparator5);
        this.jMenuBar1.add(this.jMenu_Apps);
        this.jMenu_Help.setText("Help");
        this.jMenu_Help.setMnemonic(72);
        this.jMenuItem_About.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/information.svg"));
        this.jMenuItem_About.setText("About");
        this.jMenuItem_About.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_AboutActionPerformed(evt);
            }
        });
        this.jMenu_Help.add(this.jMenuItem_About);
        this.jMenu_Help.add(this.jSeparator7);
        this.jMenuItem_Help.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/help.svg"));
        this.jMenuItem_Help.setText("Help");
        this.jMenuItem_Help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_HelpActionPerformed(evt);
            }
        });
        this.jMenu_Help.add(this.jMenuItem_Help);
        this.jMenuBar1.add(this.jMenu_Help);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jButton_NewFileActionPerformed(ActionEvent evt) {
        this.editorDock.addNewTextEditor("New file");
    }

    private void jButton_OpenFileActionPerformed(ActionEvent evt) {
        this.editorDock.doOpen_Jython();
    }

    private void jButton_SaveFileActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        if (textEditor != null) {
            this.editorDock.doSave(textEditor);
        }
    }

    private void jButton_UndoActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        textEditor.getTextArea().undoLastAction();
    }

    private void jButton_RedoActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        textEditor.getTextArea().redoLastAction();
    }

    private void jButton_RunScriptActionPerformed(ActionEvent evt) {
        TextEditor te = this.editorDock.getActiveTextEditor();
        if (!te.getFileName().isEmpty() && te.getTextArea().isDirty()) {
            te.saveFile(te.getFile());
        }
        if (te.getFileName().isEmpty()) {
            String code = te.getTextArea().getText();
            try {
                this.consoleDock.runJythonScript(code);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.consoleDock.execJythonFile(te.getFileName());
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.formClose();
    }

    private void formClose() {
        this.saveConfigureFile();
        boolean isDispose = true;
        for (int i = 0; i < this.editorDock.getTabbedPane().getTabCount(); ++i) {
            TextEditor textEditor = (TextEditor)this.editorDock.getTabbedPane().getComponentAt(i);
            if (textEditor == null) continue;
            boolean ifClose = true;
            if (textEditor.getTextArea().isDirty()) {
                int result;
                String fName = textEditor.getFileName();
                if (fName.isEmpty()) {
                    fName = "New file";
                }
                if ((result = JOptionPane.showConfirmDialog(null, MessageFormat.format("Save changes to \"{0}\"", fName), "Save?", 1)) == 0) {
                    if (!this.editorDock.doSave(textEditor)) {
                        ifClose = false;
                    }
                } else if (result == 2) {
                    ifClose = false;
                }
            }
            if (ifClose) continue;
            isDispose = false;
            break;
        }
        if (isDispose) {
            System.exit(0);
        }
    }

    private void jButton_SaveAsActionPerformed(ActionEvent evt) {
        TextEditor editor = this.editorDock.getActiveTextEditor();
        if (editor != null) {
            this.editorDock.doSaveAs_Jython(editor);
        }
    }

    private void jMenuItem_CutActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        textEditor.getTextArea().cut();
    }

    private void jMenuItem_CopyActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        textEditor.getTextArea().copy();
    }

    private void jMenuItem_PasteActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        textEditor.getTextArea().paste();
    }

    private void jMenuItem_AboutActionPerformed(ActionEvent evt) {
        FrmAbout frmAbout = new FrmAbout((Frame)this, false);
        frmAbout.setLocationRelativeTo(this);
        frmAbout.setVisible(true);
    }

    private void jComboBox_CurrentFolderActionPerformed(ActionEvent evt) {
        if (this.fileDock == null) {
            return;
        }
        if (this.jComboBox_CurrentFolder.getItemCount() > 0) {
            Object obj = this.jComboBox_CurrentFolder.getSelectedItem();
            String path = obj.toString();
            if (new File(path).isDirectory()) {
                this.fileDock.setPath(new File(path));
            }
            this.jComboBox_CurrentFolder.removeItem(obj);
            this.jComboBox_CurrentFolder.addItem(obj);
            this.jComboBox_CurrentFolder.setSelectedItem(obj);
        }
    }

    private void jButton_CurrentFolderActionPerformed(ActionEvent evt) {
        JFileChooser aDlg = new JFileChooser();
        File pathDir = new File(this.jComboBox_CurrentFolder.getSelectedItem().toString());
        if (pathDir.isDirectory()) {
            aDlg.setCurrentDirectory(pathDir);
        }
        aDlg.setFileSelectionMode(1);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            String path = aFile.getAbsolutePath();
            this.setCurrentPath(path);
            this.fileDock.setPath(new File(this.options.getCurrentFolder()));
        }
    }

    private void jMenuItem_ExitActionPerformed(ActionEvent evt) {
        this.formClose();
    }

    private void jMenuItem_CloseAllFilesActionPerformed(ActionEvent evt) {
        this.editorDock.closeAllFiles();
    }

    private void jMenuItem_ColorMapsActionPerformed(ActionEvent evt) {
        try {
            ColorMap[] colorTables = ColorUtil.getColorMaps();
            ColorListCellRender render = new ColorListCellRender();
            render.setPreferredSize(new Dimension(62, 21));
            Object[][] elements = new Object[colorTables.length][2];
            for (int i = 0; i < colorTables.length; ++i) {
                elements[i][0] = colorTables[i];
                elements[i][1] = String.valueOf(i);
            }
            final JList jlist = new JList((E[])elements);
            jlist.setCellRenderer(render);
            jlist.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int idx;
                    if (e.getKeyCode() == 40 && (idx = jlist.getSelectedIndex()) >= 0) {
                        if (++idx == jlist.getModel().getSize() - 1) {
                            idx = 0;
                        }
                        jlist.setSelectedIndex(idx);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            JDialog colorMapDialog = new JDialog((Frame)this, false);
            colorMapDialog.setTitle("Color Map");
            colorMapDialog.setFocusableWindowState(false);
            colorMapDialog.add(new JScrollPane(jlist));
            colorMapDialog.setSize(this.getWidth() / 2, this.getHeight() * 2 / 3);
            colorMapDialog.setLocationRelativeTo(this);
            colorMapDialog.setVisible(true);
        }
        catch (IOException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jMenuItem_AppsManagerActionPerformed(ActionEvent evt) {
        FrmAppsManager frm = new FrmAppsManager(this, true);
        frm.setLocationRelativeTo(this);
        frm.setVisible(true);
    }

    private void jMenuItem_ColorDialogActionPerformed(ActionEvent evt) {
        JDialog colorMapDialog = new JDialog((Frame)this, false);
        colorMapDialog.setTitle("Color Dialog");
        colorMapDialog.setFocusableWindowState(false);
        colorMapDialog.add(new JColorChooser(Color.black));
        colorMapDialog.setSize(600, 400);
        colorMapDialog.setLocationRelativeTo(this);
        colorMapDialog.setVisible(true);
    }

    private void jMenuItem_NewFileActionPerformed(ActionEvent evt) {
        this.jButton_NewFile.doClick();
    }

    private void jMenuItem_OpenFileActionPerformed(ActionEvent evt) {
        this.jButton_OpenFile.doClick();
    }

    private void jMenuItem_SaveFileActionPerformed(ActionEvent evt) {
        this.jButton_SaveFile.doClick();
    }

    private void jMenuItem_SaveAsActionPerformed(ActionEvent evt) {
        this.jButton_SaveAs.doClick();
    }

    private void jMenu_EditorActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem_FindReplaceActionPerformed(ActionEvent evt) {
        FrmFindReplace frm = new FrmFindReplace((Frame)this, false, this.editorDock.getActiveTextEditor());
        frm.setLocationRelativeTo(this);
        frm.setVisible(true);
    }

    private void jMenuItem_SettingActionPerformed(ActionEvent evt) {
        FrmSetting frm = new FrmSetting((Frame)this, false);
        frm.setLocationRelativeTo(this);
        frm.setVisible(true);
    }

    private void jMenuItem_CommentActionPerformed(ActionEvent evt) {
        this.editorDock.Comment();
    }

    private void jMenuItem_InsertTabActionPerformed(ActionEvent evt) {
        this.editorDock.insertTab();
    }

    private void jMenuItem_DeleteTabActionPerformed(ActionEvent evt) {
        this.editorDock.delTab();
    }

    private void jMenuItem_HelpActionPerformed(ActionEvent evt) {
        try {
            URI uri = new URI("http://www.meteothink.org/docs/meteoinfolab/index.html");
            Desktop desktop = null;
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
            }
            if (desktop != null) {
                desktop.browse(uri);
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(FrmAbout.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FigureDockable getFigureDock() {
        return this.figuresDock;
    }

    public EditorDockable getEditorDock() {
        return this.editorDock;
    }

    public String getCurrentFolder() {
        return this.options.getCurrentFolder();
    }

    public ConsoleDockable getConsoleDockable() {
        return this.consoleDock;
    }

    public final void loadConfigureFile() {
        String fn = this.startupPath + File.separator + "milconfig.xml";
        if (new File(fn).exists()) {
            try {
                this.options.loadConfigFile(fn);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public final void saveConfigureFile() {
        String fn = this.options.getFileName();
        try {
            ArrayList<String> cfolders = new ArrayList<String>();
            for (int i = 0; i < 15 && i < this.jComboBox_CurrentFolder.getItemCount(); ++i) {
                cfolders.add(this.jComboBox_CurrentFolder.getItemAt(i).toString());
            }
            this.options.setRecentFolders(cfolders);
            List<String> ofiles = this.editorDock.getOpenedFiles();
            this.options.setOpenedFiles(ofiles);
            this.options.setMainFormLocation(this.getLocation());
            this.options.setMainFormSize(this.getSize());
            this.options.saveConfigFile(fn);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setCurrentPath(String path) {
        this.options.setCurrentFolder(path);
        ArrayList<String> paths = new ArrayList<String>();
        if (this.jComboBox_CurrentFolder.getItemCount() > 15) {
            this.jComboBox_CurrentFolder.removeItemAt(0);
        }
        for (int i = 0; i < this.jComboBox_CurrentFolder.getItemCount(); ++i) {
            paths.add(this.jComboBox_CurrentFolder.getItemAt(i).toString());
        }
        if (!paths.contains(path)) {
            this.jComboBox_CurrentFolder.addItem(path);
        }
        this.jComboBox_CurrentFolder.setSelectedItem(path);
        PythonInteractiveInterpreter interp = this.consoleDock.getInterpreter();
        try {
            path = path.replace("\\", "/");
            interp.exec("mipylib.migl.currentfolder = '" + path + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JMenuBar getMainMenuBar() {
        return this.jMenuBar1;
    }

    public JMenu getPluginMenu() {
        return this.jMenu_Apps;
    }

    public JPanel getToolBarPanel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JButton getCurrentTool() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCurrentTool(AbstractButton value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JProgressBar getProgressBar() {
        return this.jProgressBar_Run;
    }

    public JLabel getProgressBarLabel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void openProjectFile(String fileName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void delVariables() {
        PythonInteractiveInterpreter interp = this.consoleDock.getInterpreter();
        PyStringMap locals = (PyStringMap)interp.getLocals();
        PyList items = locals.items();
        for (Object a : items) {
            PyTuple at = (PyTuple)a;
            String name = at.__getitem__(0).toString();
            if (this.loadObjects.contains(name)) continue;
            locals.__delitem__(name);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmMain frame = new FrmMain(null, null);
                frame.setDefaultCloseOperation(0);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

