/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;
import org.apache.commons.statistics.distribution.SaddlePointExpansionUtils;

public final class HypergeometricDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfSuccesses;
    private final int populationSize;
    private final int sampleSize;
    private final int lowerBound;
    private final int upperBound;
    private final double p;
    private final double q;

    private HypergeometricDistribution(int populationSize, int numberOfSuccesses, int sampleSize) {
        this.numberOfSuccesses = numberOfSuccesses;
        this.populationSize = populationSize;
        this.sampleSize = sampleSize;
        this.lowerBound = HypergeometricDistribution.getLowerDomain(populationSize, numberOfSuccesses, sampleSize);
        this.upperBound = HypergeometricDistribution.getUpperDomain(numberOfSuccesses, sampleSize);
        this.p = (double)sampleSize / (double)populationSize;
        this.q = (double)(populationSize - sampleSize) / (double)populationSize;
    }

    public static HypergeometricDistribution of(int populationSize, int numberOfSuccesses, int sampleSize) {
        if (populationSize <= 0) {
            throw new DistributionException("Number %s is not greater than 0", populationSize);
        }
        if (numberOfSuccesses < 0) {
            throw new DistributionException("Number %s is negative", numberOfSuccesses);
        }
        if (sampleSize < 0) {
            throw new DistributionException("Number %s is negative", sampleSize);
        }
        if (numberOfSuccesses > populationSize) {
            throw new DistributionException("%s > %s", numberOfSuccesses, populationSize);
        }
        if (sampleSize > populationSize) {
            throw new DistributionException("%s > %s", sampleSize, populationSize);
        }
        return new HypergeometricDistribution(populationSize, numberOfSuccesses, sampleSize);
    }

    private static int getLowerDomain(int nn, int k, int n) {
        return Math.max(0, k - (nn - n));
    }

    private static int getUpperDomain(int k, int n) {
        return Math.min(n, k);
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public double probability(int x) {
        return Math.exp(this.logProbability(x));
    }

    @Override
    public double logProbability(int x) {
        if (x < this.lowerBound || x > this.upperBound) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.computeLogProbability(x);
    }

    private double computeLogProbability(int x) {
        double p1 = SaddlePointExpansionUtils.logBinomialProbability(x, this.numberOfSuccesses, this.p, this.q);
        double p2 = SaddlePointExpansionUtils.logBinomialProbability(this.sampleSize - x, this.populationSize - this.numberOfSuccesses, this.p, this.q);
        double p3 = SaddlePointExpansionUtils.logBinomialProbability(this.sampleSize, this.populationSize, this.p, this.q);
        return p1 + p2 - p3;
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < this.lowerBound) {
            return 0.0;
        }
        if (x >= this.upperBound) {
            return 1.0;
        }
        return this.innerCumulativeProbability(this.lowerBound, x);
    }

    @Override
    public double survivalProbability(int x) {
        if (x < this.lowerBound) {
            return 1.0;
        }
        if (x >= this.upperBound) {
            return 0.0;
        }
        return this.innerCumulativeProbability(this.upperBound, x + 1);
    }

    private double innerCumulativeProbability(int x0, int x1) {
        int x = x0;
        double ret = Math.exp(this.computeLogProbability(x));
        if (x0 < x1) {
            while (x != x1) {
                ret += Math.exp(this.computeLogProbability(++x));
            }
        } else {
            while (x != x1) {
                ret += Math.exp(this.computeLogProbability(--x));
            }
        }
        return ret;
    }

    @Override
    public double getMean() {
        return (double)this.getSampleSize() * ((double)this.getNumberOfSuccesses() / (double)this.getPopulationSize());
    }

    @Override
    public double getVariance() {
        double N = this.getPopulationSize();
        double K = this.getNumberOfSuccesses();
        double n = this.getSampleSize();
        return n * K * (N - K) * (N - n) / (N * N * (N - 1.0));
    }

    @Override
    public int getSupportLowerBound() {
        return this.lowerBound;
    }

    @Override
    public int getSupportUpperBound() {
        return this.upperBound;
    }
}

