/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.location.CBaseLocation;
import bibliothek.gui.dock.common.location.CFlapLocation;
import bibliothek.gui.dock.common.location.Side;
import bibliothek.gui.dock.common.mode.ExtendedMode;

public class CMinimizedLocation
extends CFlapLocation {
    private CBaseLocation parent;
    private Side side;

    public CMinimizedLocation(CBaseLocation parent, Side side) {
        super(parent);
        if (side == null) {
            throw new NullPointerException("side is null");
        }
        this.parent = parent;
        this.side = side;
    }

    public Side getSide() {
        return this.side;
    }

    @Override
    public ExtendedMode findMode() {
        return ExtendedMode.MINIMIZED;
    }

    @Override
    public String findRoot() {
        CContentArea center = this.parent.getContentArea();
        String id = center == null ? "ccontrol" : center.getUniqueId();
        switch (this.side) {
            case NORTH: {
                return CContentArea.getNorthIdentifier(id);
            }
            case SOUTH: {
                return CContentArea.getSouthIdentifier(id);
            }
            case EAST: {
                return CContentArea.getEastIdentifier(id);
            }
            case WEST: {
                return CContentArea.getWestIdentifier(id);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.parent) + " [minimized " + (Object)((Object)this.side) + "]";
    }
}

