/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.perspective.CGridPerspective;
import bibliothek.gui.dock.common.perspective.CMinimizePerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;

public class CContentPerspective {
    private CPerspective perspective;
    private String id;

    public CContentPerspective(CPerspective perspective, String id) {
        if (perspective == null) {
            throw new IllegalArgumentException("perspective must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.perspective = perspective;
        this.id = id;
        String center = CContentArea.getCenterIdentifier(id);
        String north = CContentArea.getNorthIdentifier(id);
        String south = CContentArea.getSouthIdentifier(id);
        String east = CContentArea.getEastIdentifier(id);
        String west = CContentArea.getWestIdentifier(id);
        this.ensureType(center, CGridPerspective.class);
        this.ensureType(north, CMinimizePerspective.class);
        this.ensureType(south, CMinimizePerspective.class);
        this.ensureType(east, CMinimizePerspective.class);
        this.ensureType(west, CMinimizePerspective.class);
        if (perspective.getStation(center) == null) {
            perspective.addStation(new CGridPerspective(center, CContentArea.TYPE_ID_CENTER, false));
        }
        if (perspective.getStation(north) == null) {
            perspective.addStation(new CMinimizePerspective(north, CContentArea.TYPE_ID_MINIMIZE));
        }
        if (perspective.getStation(south) == null) {
            perspective.addStation(new CMinimizePerspective(south, CContentArea.TYPE_ID_MINIMIZE));
        }
        if (perspective.getStation(east) == null) {
            perspective.addStation(new CMinimizePerspective(east, CContentArea.TYPE_ID_MINIMIZE));
        }
        if (perspective.getStation(west) == null) {
            perspective.addStation(new CMinimizePerspective(west, CContentArea.TYPE_ID_MINIMIZE));
        }
    }

    protected void ensureType(String id, Class<?> type) {
        CStationPerspective station = this.perspective.getStation(id);
        if (station != null && station.getClass() != type) {
            throw new IllegalStateException("present root station '" + id + "' is of type '" + station.getClass() + "' but should be of type '" + type + "'");
        }
    }

    public String getId() {
        return this.id;
    }

    public CPerspective getPerspective() {
        return this.perspective;
    }

    public CGridPerspective getCenter() {
        return (CGridPerspective)this.perspective.getStation(CContentArea.getCenterIdentifier(this.id));
    }

    public CMinimizePerspective getNorth() {
        return (CMinimizePerspective)this.perspective.getStation(CContentArea.getNorthIdentifier(this.id));
    }

    public CMinimizePerspective getSouth() {
        return (CMinimizePerspective)this.perspective.getStation(CContentArea.getSouthIdentifier(this.id));
    }

    public CMinimizePerspective getEast() {
        return (CMinimizePerspective)this.perspective.getStation(CContentArea.getEastIdentifier(this.id));
    }

    public CMinimizePerspective getWest() {
        return (CMinimizePerspective)this.perspective.getStation(CContentArea.getWestIdentifier(this.id));
    }
}

