/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.facile.mode.ExternalizedModeArea;
import bibliothek.gui.dock.facile.mode.ExternalizedModeBehavior;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class DefaultExternalizedModeBehavior
implements ExternalizedModeBehavior {
    private Dimension minSize = new Dimension(300, 200);

    @Override
    public ScreenDockProperty findLocation(ExternalizedModeArea target, Dockable dockable) {
        Point corner;
        Component component = dockable.getComponent();
        component.invalidate();
        Component parent = component;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        parent.validate();
        Dimension size = component.getSize();
        Dimension preferred = component.getPreferredSize();
        size.width = Math.max(Math.max(size.width, preferred.width), this.minSize.width);
        size.height = Math.max(Math.max(size.height, preferred.height), this.minSize.height);
        if (dockable.getComponent().isDisplayable()) {
            corner = new Point();
            SwingUtilities.convertPointToScreen(corner, dockable.getComponent());
        } else {
            DockController controller = dockable.getController();
            Window root = null;
            if (controller != null) {
                root = controller.getRootWindowProvider().searchWindow();
            }
            corner = root != null ? new Point(root.getX() + (root.getWidth() - size.width) / 2, root.getY() + (root.getHeight() - size.height) / 2) : new Point(0, 0);
        }
        return new ScreenDockProperty(corner.x, corner.y, size.width, size.height, null, false);
    }
}

