/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.predefined.CExternalizeAction;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.DefaultExternalizedModeBehavior;
import bibliothek.gui.dock.facile.mode.DefaultLocationMode;
import bibliothek.gui.dock.facile.mode.DefaultLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.ExternalizedModeArea;
import bibliothek.gui.dock.facile.mode.ExternalizedModeBehavior;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.action.ExternalizedModeAction;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.NullModeSettingsFactory;
import bibliothek.util.Path;

public class ExternalizedMode<M extends ExternalizedModeArea>
extends DefaultLocationMode<M> {
    public static final Path IDENTIFIER = new Path("dock.mode.externalized");
    public static final String ICON_IDENTIFIER = "locationmanager.externalize";
    private ExternalizedModeBehavior behavior = new DefaultExternalizedModeBehavior();

    protected ExternalizedMode() {
    }

    public ExternalizedMode(CControl control) {
        this.setActionProvider(new DefaultLocationModeActionProvider(new CExternalizeAction(control)));
    }

    public ExternalizedMode(DockController controller) {
        this.setActionProvider(new DefaultLocationModeActionProvider((DockAction)new ExternalizedModeAction(controller, this)));
    }

    @Override
    public Path getUniqueIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public ExtendedMode getExtendedMode() {
        return ExtendedMode.EXTERNALIZED;
    }

    @Override
    public boolean isDefaultMode(Dockable dockable) {
        return false;
    }

    @Override
    public boolean runApply(Dockable dockable, Location history, AffectedSet set) {
        return this.externalize(dockable, history, set);
    }

    private boolean externalize(Dockable dockable, Location location, AffectedSet affected) {
        affected.add(dockable);
        ExternalizedModeArea area = null;
        if (location != null) {
            area = (ExternalizedModeArea)this.get(location.getRoot());
        }
        if (area == null) {
            area = (ExternalizedModeArea)this.getDefaultArea();
        }
        DockableProperty property = null;
        if (location != null) {
            property = location.getLocation();
        }
        if (property == null && !area.isChild(dockable)) {
            property = this.behavior.findLocation(area, dockable);
        }
        return area.setLocation(dockable, property, affected);
    }

    @Override
    public ModeSettingFactory<Location> getSettingFactory() {
        return new NullModeSettingsFactory<Location>(this.getUniqueIdentifier());
    }

    public void setBehavior(ExternalizedModeBehavior behavior) {
        if (behavior == null) {
            throw new IllegalArgumentException("behavior must not be null");
        }
        this.behavior = behavior;
    }

    public ExternalizedModeBehavior getBehavior() {
        return this.behavior;
    }

    @Override
    public void ensureNotHidden(Dockable dockable) {
    }

    @Override
    public void writeSetting(ModeSetting<Location> setting) {
    }

    @Override
    public void readSetting(ModeSetting<Location> setting) {
    }
}

