/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock;

import bibliothek.extension.gui.dock.PreferenceTable;
import bibliothek.extension.gui.dock.preference.PreferenceEditorFactory;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.extension.gui.dock.preference.PreferenceTreeModel;
import bibliothek.util.Path;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PreferenceTreePanel
extends JPanel {
    private PreferenceTreeModel model;
    private JTree tree;
    private PreferenceTable table;

    public PreferenceTreePanel() {
        this((PreferenceTreeModel)null);
    }

    public PreferenceTreePanel(PreferenceTreeModel model) {
        this.model = model;
        this.setLayout(new GridLayout(1, 1));
        JSplitPane pane = new JSplitPane(1);
        this.tree = model == null ? new JTree(new DefaultTreeModel(new DefaultMutableTreeNode("<null>"))) : new JTree(model);
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        pane.setLeftComponent(new JScrollPane(this.tree));
        this.table = new PreferenceTable();
        pane.setRightComponent(new JScrollPane(this.table));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PreferenceTreePanel.this.checkSelection();
            }
        });
        this.add(pane);
        this.checkSelection();
    }

    public void addOperation(PreferenceOperation operation) {
        this.table.addOperation(operation);
    }

    public void setEditorFactory(Path type, PreferenceEditorFactory<?> factory) {
        this.table.setEditorFactory(type, factory);
    }

    public JTree getTree() {
        return this.tree;
    }

    public PreferenceTable getTable() {
        return this.table;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.table.getModel() == null) {
            size = new Dimension(size.width * 2, size.height);
        }
        return size;
    }

    private void checkSelection() {
        PreferenceModel preference = null;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && this.model != null) {
            PreferenceTreeModel.Node node = (PreferenceTreeModel.Node)path.getLastPathComponent();
            preference = node.getModel();
        }
        this.table.setModel(preference);
    }

    public void setModel(PreferenceTreeModel model) {
        this.model = model;
        if (model == null) {
            this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("<null>")));
            this.table.setModel(null);
        } else {
            this.tree.setModel(model);
        }
    }

    public PreferenceTreeModel getModel() {
        return this.model;
    }
}

