/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.AbstractPreference;
import bibliothek.extension.gui.dock.preference.PreferenceListener;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.extension.gui.dock.preference.PreferenceText;
import bibliothek.util.Path;

public abstract class DefaultPreference<V>
extends AbstractPreference<V> {
    private V value;
    private Object valueInfo;
    private Path type;
    private String label;
    private PreferenceText labelText;
    private String description;
    private PreferenceText descriptionText;
    private V defaultValue;
    private Path path;
    private boolean natural = false;
    private PreferenceModel model;

    public DefaultPreference(Path type, Path path) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (path.getSegmentCount() == 0) {
            throw new IllegalArgumentException("the root path is not a valid path for a preference");
        }
        this.type = type;
        this.path = path;
    }

    public DefaultPreference(String label, Path type, Path path) {
        this(type, path);
        this.setLabel(label);
    }

    @Override
    public void addPreferenceListener(PreferenceListener<V> listener) {
        if (!this.hasListeners() && this.model != null) {
            if (this.labelText != null) {
                this.labelText.setController(this.model.getController());
            }
            if (this.descriptionText != null) {
                this.descriptionText.setController(this.model.getController());
            }
        }
        super.addPreferenceListener(listener);
    }

    @Override
    public void removePreferenceListener(PreferenceListener<V> listener) {
        super.removePreferenceListener(listener);
        if (!this.hasListeners()) {
            if (this.labelText != null) {
                this.labelText.setController(null);
            }
            if (this.descriptionText != null) {
                this.descriptionText.setController(null);
            }
        }
    }

    @Override
    public void setModel(PreferenceModel model) {
        this.model = model;
        if (this.hasListeners()) {
            if (this.labelText != null) {
                this.labelText.setController(model == null ? null : model.getController());
            }
            if (this.descriptionText != null) {
                this.descriptionText.setController(model == null ? null : model.getController());
            }
        }
    }

    @Override
    public String getLabel() {
        if (this.labelText == null) {
            return this.label;
        }
        if (!this.hasListeners() && this.model != null) {
            this.labelText.update(this.model.getController().getTexts());
        }
        return (String)this.labelText.value();
    }

    public void setLabel(String label) {
        this.label = label;
        if (this.labelText != null) {
            this.labelText.setValue(label);
        } else {
            this.fireChanged();
        }
    }

    public void setLabelId(String labelId) {
        if (labelId == null) {
            if (this.labelText != null) {
                this.labelText.setController(null);
                this.labelText = null;
            }
        } else if (this.labelText == null) {
            this.labelText = new PreferenceText(labelId, this){

                @Override
                protected void changed(String oldValue, String newValue) {
                    DefaultPreference.this.fireChanged();
                }
            };
            if (this.hasListeners() && this.model != null) {
                this.labelText.setController(this.model.getController());
            }
        } else {
            this.labelText.setId(labelId);
        }
    }

    @Override
    public String getDescription() {
        if (this.descriptionText == null) {
            return this.description;
        }
        if (!this.hasListeners() && this.model != null) {
            this.descriptionText.update(this.model.getController().getTexts());
        }
        return (String)this.descriptionText.value();
    }

    public void setDescription(String description) {
        this.description = description;
        if (this.descriptionText != null) {
            this.descriptionText.setValue(description);
        } else {
            this.fireChanged();
        }
    }

    public void setDescriptionId(String descriptionId) {
        if (descriptionId == null) {
            if (this.descriptionText != null) {
                this.descriptionText.setController(null);
                this.descriptionText = null;
            }
        } else if (this.descriptionText == null) {
            this.descriptionText = new PreferenceText(descriptionId, this){

                @Override
                protected void changed(String oldValue, String newValue) {
                    DefaultPreference.this.fireChanged();
                }
            };
            if (this.hasListeners() && this.model != null) {
                this.descriptionText.setController(this.model.getController());
            }
        } else {
            this.descriptionText.setId(descriptionId);
        }
    }

    @Override
    public Path getTypePath() {
        return this.type;
    }

    public void setValueInfo(Object valueInfo) {
        this.valueInfo = valueInfo;
    }

    @Override
    public Object getValueInfo() {
        return this.valueInfo;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        if (this.value != value) {
            this.value = value;
            this.fireChanged();
        }
    }

    public void setDefaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
        this.fireChanged();
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
    }

    @Override
    public boolean isNatural() {
        return this.natural;
    }

    @Override
    public PreferenceOperation[] getOperations() {
        if (this.defaultValue == null) {
            return null;
        }
        return new PreferenceOperation[]{PreferenceOperation.DEFAULT};
    }

    @Override
    public boolean isEnabled(PreferenceOperation operation) {
        if (operation == PreferenceOperation.DEFAULT) {
            if (this.defaultValue == null) {
                return false;
            }
            return !this.defaultValue.equals(this.getValue());
        }
        return false;
    }

    @Override
    public void doOperation(PreferenceOperation operation) {
        if (operation == PreferenceOperation.DEFAULT) {
            if (this.defaultValue != null) {
                this.setValue(this.defaultValue);
            }
        } else {
            super.doOperation(operation);
        }
    }
}

