/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.AbstractPreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModelListener;
import bibliothek.gui.DockController;
import bibliothek.util.Path;
import bibliothek.util.PathCombiner;
import java.util.ArrayList;
import java.util.List;

public class MergedPreferenceModel
extends AbstractPreferenceModel {
    private List<Model> models = new ArrayList<Model>();
    private PathCombiner combiner = PathCombiner.UNIQUE;
    private PreferenceModelListener listener = new PreferenceModelListener(){

        @Override
        public void preferenceAdded(PreferenceModel model, int beginIndex, int endIndex) {
            int begin = MergedPreferenceModel.this.indexAt(model, beginIndex);
            int end = begin + (endIndex - beginIndex);
            MergedPreferenceModel.this.firePreferenceAdded(begin, end);
        }

        @Override
        public void preferenceChanged(PreferenceModel model, int beginIndex, int endIndex) {
            int begin = MergedPreferenceModel.this.indexAt(model, beginIndex);
            int end = begin + (endIndex - beginIndex);
            MergedPreferenceModel.this.firePreferenceChanged(begin, end);
        }

        @Override
        public void preferenceRemoved(PreferenceModel model, int beginIndex, int endIndex) {
            int begin = MergedPreferenceModel.this.indexAt(model, beginIndex);
            int end = begin + (endIndex - beginIndex);
            MergedPreferenceModel.this.firePreferenceRemoved(begin, end);
        }
    };

    public MergedPreferenceModel(DockController controller) {
        super(controller);
    }

    public MergedPreferenceModel(PathCombiner combiner, DockController controller) {
        super(controller);
        if (combiner == null) {
            throw new IllegalArgumentException("combiner must not be null");
        }
        this.combiner = combiner;
    }

    public void add(PreferenceModel model, Path path) {
        this.insert(this.models.size(), model, path);
    }

    public void insert(int index, PreferenceModel model, Path path) {
        int size;
        if (this == model) {
            throw new IllegalArgumentException("model must not be this");
        }
        for (Model check : this.models) {
            if (check.model == model) {
                throw new IllegalArgumentException("can't add a model twice");
            }
            if (!check.path.equals(path)) continue;
            throw new IllegalArgumentException("there is already a model with the path " + path);
        }
        Model insert = new Model();
        insert.model = model;
        insert.path = path;
        this.models.add(index, insert);
        if (this.hasListeners()) {
            model.addPreferenceModelListener(this.listener);
        }
        if ((size = model.getSize()) > 0) {
            int begin = 0;
            for (int i = 0; i < index; ++i) {
                begin += this.models.get((int)i).model.getSize();
            }
            this.firePreferenceAdded(begin, begin + size - 1);
        }
    }

    public void remove(int index) {
        int size;
        Model model = this.models.remove(index);
        if (this.hasListeners()) {
            model.model.removePreferenceModelListener(this.listener);
        }
        if ((size = model.model.getSize()) > 0) {
            int begin = 0;
            for (int i = 0; i < index; ++i) {
                begin += this.models.get((int)i).model.getSize();
            }
            this.firePreferenceRemoved(begin, begin + size - 1);
        }
    }

    public void remove(MergedPreferenceModel model) {
        int index = this.indexOf(model);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public void remove(Path path) {
        int index = this.indexOf(path);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public void clear() {
        int size = this.getSize();
        if (this.hasListeners()) {
            for (Model model : this.models) {
                model.model.removePreferenceModelListener(this.listener);
            }
        }
        this.models.clear();
        if (size > 0) {
            this.firePreferenceRemoved(0, size - 1);
        }
    }

    public int indexOf(PreferenceModel model) {
        int i = 0;
        for (Model check : this.models) {
            if (check.model == model) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(Path path) {
        int i = 0;
        for (Model check : this.models) {
            if (check.path.equals(path)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public PreferenceModel getModel(int index) {
        return this.models.get((int)index).model;
    }

    public PreferenceModel getModel(Path path) {
        int index = this.indexOf(path);
        if (index < 0) {
            return null;
        }
        return this.getModel(index);
    }

    @Override
    public void read() {
        for (Model model : this.models) {
            model.model.read();
        }
    }

    @Override
    public void write() {
        for (Model model : this.models) {
            model.model.write();
        }
    }

    @Override
    public void addPreferenceModelListener(PreferenceModelListener listener) {
        boolean hadListeners = this.hasListeners();
        super.addPreferenceModelListener(listener);
        if (this.hasListeners() && !hadListeners) {
            for (Model model : this.models) {
                model.model.addPreferenceModelListener(this.listener);
            }
        }
    }

    @Override
    public void removePreferenceModelListener(PreferenceModelListener listener) {
        boolean hadListeners = this.hasListeners();
        super.removePreferenceModelListener(listener);
        if (!this.hasListeners() && hadListeners) {
            for (Model model : this.models) {
                model.model.removePreferenceModelListener(this.listener);
            }
        }
    }

    @Override
    public int getSize() {
        int size = 0;
        for (Model model : this.models) {
            size += model.model.getSize();
        }
        return size;
    }

    @Override
    public String getLabel(int index) {
        Index local = this.indexAt(index);
        if (local == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return local.model.model.getLabel(local.index);
    }

    @Override
    public String getDescription(int index) {
        Index local = this.indexAt(index);
        if (local == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return local.model.model.getDescription(local.index);
    }

    @Override
    public Object getValueInfo(int index) {
        Index local = this.indexAt(index);
        if (local == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return local.model.model.getValueInfo(local.index);
    }

    @Override
    public Object getValue(int index) {
        Index local = this.indexAt(index);
        if (local == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return local.model.model.getValue(local.index);
    }

    @Override
    public void setValue(int index, Object value) {
        Index local = this.indexAt(index);
        if (local == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        local.model.model.setValue(local.index, value);
    }

    @Override
    public Path getTypePath(int index) {
        Index local = this.indexAt(index);
        if (local == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return local.model.model.getTypePath(local.index);
    }

    @Override
    public Path getPath(int index) {
        Index local = this.indexAt(index);
        if (local == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.combiner.combine(local.model.path, local.model.model.getPath(local.index));
    }

    @Override
    public boolean isNatural(int index) {
        Index local = this.indexAt(index);
        if (local == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return local.model.model.isNatural(local.index);
    }

    @Override
    public void setValueNatural(int index) {
        Index local = this.indexAt(index);
        if (local == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        local.model.model.setValueNatural(local.index);
    }

    protected Index indexAt(int globalIndex) {
        for (Model model : this.models) {
            int size = model.model.getSize();
            if (globalIndex < size) {
                return new Index(model, globalIndex);
            }
            globalIndex -= size;
        }
        return null;
    }

    protected int indexAt(PreferenceModel model, int index) {
        for (Model check : this.models) {
            if (check.model == model) {
                return index;
            }
            index += check.model.getSize();
        }
        return index;
    }

    private static class Model {
        public PreferenceModel model;
        public Path path;

        private Model() {
        }
    }

    protected static class Index {
        public Model model;
        public int index;

        public Index(Model model, int index) {
            this.model = model;
            this.index = index;
        }
    }
}

