/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.theme.bubble.BubbleStackDockComponent;
import bibliothek.extension.gui.dock.theme.bubble.RoundButton;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.station.stack.menu.ButtonCombinedMenu;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.color.MenuColor;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class BubbleTabMenu
extends ButtonCombinedMenu<RoundButton> {
    private BubbleStackDockComponent pane;
    private int borderSize = 3;

    public BubbleTabMenu(BubbleStackDockComponent pane) {
        super(pane, pane.getMenuHandler());
        this.pane = pane;
    }

    @Override
    protected RoundButton createButton(BasicTrigger trigger) {
        return new Button(trigger);
    }

    @Override
    protected BasicButtonModel getModel(RoundButton button) {
        return button.getModel();
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        RoundButton button = (RoundButton)this.getButton();
        if (button != null) {
            button.setController(controller);
        }
    }

    private class Button
    extends RoundButton {
        public Button(BasicTrigger trigger) {
            super(trigger, null, null, null);
            this.setController(BubbleTabMenu.this.getController());
            this.setPaintFocusBorder(false);
        }

        @Override
        protected AbstractDockColor[] createColors(Dockable dockable, DockAction action) {
            return new AbstractDockColor[]{this.createColor("stack.menu.background.top.mouse", dockable, action, Color.WHITE), this.createColor("stack.menu.background.bottom.mouse", dockable, action, Color.WHITE), this.createColor("stack.menu.border.mouse", dockable, action, Color.BLACK), this.createColor("stack.menu.background.top", dockable, action, Color.WHITE), this.createColor("stack.menu.background.bottom", dockable, action, Color.WHITE), this.createColor("stack.menu.border", dockable, action, Color.BLACK)};
        }

        @Override
        protected AbstractDockColor createColor(String key, Dockable dockable, DockAction action, Color backup) {
            return new BubbleMenuColor(key, backup);
        }

        @Override
        protected void updateColors() {
            if (this.getModel().isMouseInside() || this.getModel().isMousePressed()) {
                this.animate("top", "stack.menu.background.top.mouse");
                this.animate("bottom", "stack.menu.background.bottom.mouse");
                this.animate("border", "stack.menu.border.mouse");
            } else {
                this.animate("top", "stack.menu.background.top");
                this.animate("bottom", "stack.menu.background.bottom");
                this.animate("border", "stack.menu.border");
            }
        }

        @Override
        protected void doPaintBackground(Graphics g) {
            BubbleColorAnimation animation = this.getAnimation();
            Color top = animation.getColor("top");
            Color bottom = animation.getColor("bottom");
            Color border = animation.getColor("border");
            int w = this.getWidth();
            int h = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(border);
            g2.fillOval(0, 0, w, h);
            if (w > 2 * BubbleTabMenu.this.borderSize && h > 2 * BubbleTabMenu.this.borderSize) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, top, 0.0f, h - BubbleTabMenu.this.borderSize, bottom));
                g2.fillOval(BubbleTabMenu.this.borderSize, BubbleTabMenu.this.borderSize, w - 2 * BubbleTabMenu.this.borderSize, h - 2 * BubbleTabMenu.this.borderSize);
            }
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), 0.0f, h / 2, Color.WHITE));
            g2.setComposite(AlphaComposite.getInstance(10, 0.4f));
            g2.fillArc(0, 0, w, h, 0, 180);
            g2.dispose();
        }

        protected class BubbleMenuColor
        extends MenuColor {
            public BubbleMenuColor(String id, Color backup) {
                super(id, BubbleTabMenu.this.pane.getStation(), BubbleTabMenu.this, backup);
            }

            @Override
            protected void changed(Color oldValue, Color newValue) {
                Button.this.updateColors();
            }
        }
    }
}

