/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.smooth;

import bibliothek.extension.gui.dock.theme.smooth.SmoothChanger;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.basic.BasicDockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class SmoothDefaultTitle
extends BasicDockTitle {
    private final int ACTIVE_STATE = 0;
    private final int INACTIVE_STATE = 1;
    private final int DISABLED_STATE = 2;
    private int[] current = null;
    private SmoothChanger changer = new SmoothChanger(3){

        @Override
        protected int destination() {
            if (SmoothDefaultTitle.this.isDisabled()) {
                return 2;
            }
            if (SmoothDefaultTitle.this.isActive()) {
                return 0;
            }
            return 1;
        }

        @Override
        protected void repaint(int[] current) {
            SmoothDefaultTitle.access$102(SmoothDefaultTitle.this, current);
            SmoothDefaultTitle.this.updateForegroundColor();
            SmoothDefaultTitle.this.repaint();
        }
    };

    public SmoothDefaultTitle(Dockable dockable, DockTitleVersion origin) {
        super(dockable, origin);
    }

    public int getDuration() {
        return this.changer.getDuration();
    }

    public void setDuration(int duration) {
        this.changer.setDuration(duration);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    @Override
    protected void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    @Override
    protected void updateColors() {
        super.updateColors();
        this.updateForegroundColor();
    }

    protected void updateForegroundColor() {
        boolean done = false;
        if (this.changer != null && this.current != null) {
            int duration = this.getDuration();
            if (this.isActive() && this.current[0] != duration || !this.isActive() && this.current[0] != 0) {
                double ratio = (double)this.current[0] / (double)duration;
                this.setForeground(Colors.between(this.getInactiveTextColor(), this.getActiveTextColor(), ratio));
                done = true;
            }
            if (!done) {
                if (this.isActive()) {
                    this.setForeground(this.getActiveTextColor());
                } else {
                    this.setForeground(this.getInactiveTextColor());
                }
            }
        }
    }

    @Override
    protected void paintBackground(Graphics g, JComponent component) {
        if (this.changer.isRunning() && this.current != null) {
            Color left = this.get(this.getActiveLeftColor(), this.getInactiveLeftColor(), this.getDisabledLeftColor());
            Color right = this.get(this.getActiveRightColor(), this.getInactiveRightColor(), this.getDisabledRightColor());
            GradientPaint gradient = this.getGradient(left, right, component);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(gradient);
            g2.fillRect(0, 0, component.getWidth(), component.getHeight());
        } else {
            super.paintBackground(g, component);
        }
    }

    private Color get(Color active, Color inactive, Color disabled) {
        return Colors.between(active, this.current[0], inactive, this.current[1], disabled, this.current[2]);
    }

    static /* synthetic */ int[] access$102(SmoothDefaultTitle x0, int[] x1) {
        x0.current = x1;
        return x1;
    }
}

