/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.LayoutLocked;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@LayoutLocked(locked=false)
public class DockRegister {
    private Set<DockStation> protectedStations = new HashSet<DockStation>();
    private List<DockStation> stations = new ArrayList<DockStation>();
    private List<Dockable> dockables = new ArrayList<Dockable>();
    private DockController controller;
    private List<DockRegisterListener> registerListeners = new ArrayList<DockRegisterListener>();
    private StationListener stationListener = new StationListener();
    private int stalled = 0;
    private Map<Dockable, Status> changeMap = new HashMap<Dockable, Status>();
    private LinkedList<Dockable> changeQueue = new LinkedList();

    public DockRegister(DockController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = controller;
    }

    public DockController getController() {
        return this.controller;
    }

    public void addDockRegisterListener(DockRegisterListener listener) {
        this.registerListeners.add(listener);
    }

    public void removeDockRegisterListener(DockRegisterListener listener) {
        this.registerListeners.remove(listener);
    }

    public void kill() {
        ArrayList<DockStation> stations = new ArrayList<DockStation>(this.stations);
        for (DockStation station : stations) {
            this.remove(station);
        }
    }

    public void setProtected(DockStation station, boolean protect) {
        if (this.stations.contains(station)) {
            if (protect) {
                this.protectedStations.add(station);
            } else {
                this.protectedStations.remove(station);
            }
        }
    }

    public boolean isProtected(DockStation station) {
        return this.protectedStations.contains(station);
    }

    public void add(DockStation station) {
        this.add(station, true);
    }

    private void add(DockStation station, final boolean requiresListeners) {
        if (station == null) {
            throw new NullPointerException("Station must not be null");
        }
        if (!this.stations.contains(station)) {
            DockController other = station.getController();
            if (other != null && other != this.controller) {
                other.getRegister().remove(station);
            }
            DockUtilities.visit(station, new DockUtilities.DockVisitor(){

                @Override
                public void handleDockable(Dockable dockable) {
                    DockRegister.this.register(dockable);
                }

                @Override
                public void handleDockStation(DockStation station) {
                    DockRegister.this.register(station, requiresListeners);
                }
            });
        }
    }

    public void remove(DockStation station) {
        if (this.stations.contains(station)) {
            DockStation parent;
            this.setProtected(station, false);
            Dockable dock = station.asDockable();
            if (dock != null && (parent = dock.getDockParent()) != null) {
                parent.drag(dock);
            }
            DockUtilities.visit(station, new DockUtilities.DockVisitor(){
                private Set<DockStation> ignored = new HashSet<DockStation>();

                @Override
                public void handleDockable(Dockable dockable) {
                    DockStation station = dockable.asDockStation();
                    if (station == null || !DockRegister.this.isProtected(station)) {
                        for (DockStation parent : this.ignored) {
                            if (!DockUtilities.isAncestor(parent, dockable)) continue;
                            return;
                        }
                        DockRegister.this.unregister(dockable);
                    }
                }

                @Override
                public void handleDockStation(DockStation station) {
                    if (DockRegister.this.isProtected(station)) {
                        this.ignored.add(station);
                    } else {
                        DockRegister.this.unregister(station);
                    }
                }
            });
        }
    }

    public int getStationCount() {
        return this.stations.size();
    }

    public DockStation getStation(int index) {
        return this.stations.get(index);
    }

    public DockStation[] listDockStations() {
        return this.stations.toArray(new DockStation[this.stations.size()]);
    }

    public DockStation[] listRoots() {
        LinkedList<DockStation> list = new LinkedList<DockStation>();
        for (DockStation station : this.stations) {
            Dockable dockable = station.asDockable();
            if (dockable != null && dockable.getDockParent() != null) continue;
            list.add(station);
        }
        return list.toArray(new DockStation[list.size()]);
    }

    public int getDockableCount() {
        return this.dockables.size();
    }

    public Dockable getDockable(int index) {
        return this.dockables.get(index);
    }

    public boolean isRegistered(Dockable dockable) {
        return this.dockables.contains(dockable);
    }

    public boolean willBeRegistered(Dockable dockable) {
        Status status = this.changeMap.get(dockable);
        if (status == null) {
            return this.isRegistered(dockable);
        }
        switch (status) {
            case ADDED: 
            case REMOVED_AND_ADDED: {
                return true;
            }
            case ADDED_AND_REMOVED: 
            case REMOVED: {
                return false;
            }
        }
        throw new IllegalStateException("unexpected state: " + (Object)((Object)status));
    }

    public Dockable[] listDockables() {
        return this.dockables.toArray(new Dockable[this.dockables.size()]);
    }

    protected void register(Dockable dockable) {
        if (!this.dockables.contains(dockable)) {
            this.fireDockableRegistering(dockable);
            this.dockables.add(dockable);
            dockable.setController(this.controller);
            this.fireDockableRegistered(dockable);
        }
    }

    protected void unregister(Dockable dockable) {
        if (this.dockables.remove(dockable)) {
            dockable.setController(null);
            this.fireDockableUnregistered(dockable);
        }
    }

    protected void register(DockStation station, boolean requiresListener) {
        if (!this.stations.contains(station)) {
            this.fireDockStationRegistering(station);
            this.stations.add(station);
            station.setController(this.controller);
            station.updateTheme();
            if (requiresListener) {
                station.addDockStationListener(this.stationListener);
            }
            this.fireDockStationRegistered(station);
        }
    }

    protected void unregister(DockStation station) {
        if (this.stations.remove(station)) {
            station.setController(null);
            station.removeDockStationListener(this.stationListener);
            this.fireDockStationUnregistered(station);
        }
    }

    protected DockRegisterListener[] listDockRegisterListeners() {
        return this.registerListeners.toArray(new DockRegisterListener[this.registerListeners.size()]);
    }

    protected void fireDockableRegistering(Dockable dockable) {
        for (DockRegisterListener listener : this.listDockRegisterListeners()) {
            listener.dockableRegistering(this.controller, dockable);
        }
    }

    protected void fireDockableRegistered(Dockable dockable) {
        for (DockRegisterListener listener : this.listDockRegisterListeners()) {
            listener.dockableRegistered(this.controller, dockable);
        }
    }

    protected void fireDockableUnregistered(Dockable dockable) {
        for (DockRegisterListener listener : this.listDockRegisterListeners()) {
            listener.dockableUnregistered(this.controller, dockable);
        }
    }

    protected void fireDockStationRegistering(DockStation station) {
        for (DockRegisterListener listener : this.listDockRegisterListeners()) {
            listener.dockStationRegistering(this.controller, station);
        }
    }

    protected void fireDockStationRegistered(DockStation station) {
        for (DockRegisterListener listener : this.listDockRegisterListeners()) {
            listener.dockStationRegistered(this.controller, station);
        }
    }

    protected void fireDockStationUnregistered(DockStation station) {
        for (DockRegisterListener listener : this.listDockRegisterListeners()) {
            listener.dockStationUnregistered(this.controller, station);
        }
    }

    protected void fireStalledChange(Dockable dockable) {
        for (DockRegisterListener listener : this.listDockRegisterListeners()) {
            listener.dockableCycledRegister(this.controller, dockable);
        }
    }

    protected void fireStalled() {
        for (DockRegisterListener listener : this.listDockRegisterListeners()) {
            listener.registerStalled(this.controller);
        }
    }

    protected void fireUnstalled() {
        for (DockRegisterListener listener : this.listDockRegisterListeners()) {
            listener.registerUnstalled(this.controller);
        }
    }

    public void setStalled(boolean stalled) {
        if (stalled) {
            boolean wasStalled = this.isStalled();
            ++this.stalled;
            if (!wasStalled) {
                this.fireStalled();
            }
        } else {
            --this.stalled;
            if (!this.isStalled()) {
                this.fireUnstalled();
            }
        }
        if (this.stalled < 0) {
            this.stalled = 0;
        }
        if (this.stalled == 0) {
            this.stationListener.fire();
        }
    }

    public boolean isStalled() {
        return this.stalled > 0;
    }

    private class StationListener
    extends DockStationAdapter {
        private boolean firing = false;

        private StationListener() {
        }

        public void fire() {
            if (!this.firing) {
                try {
                    this.firing = true;
                    while (!DockRegister.this.changeQueue.isEmpty()) {
                        Dockable next = (Dockable)DockRegister.this.changeQueue.removeFirst();
                        Status status = (Status)((Object)DockRegister.this.changeMap.remove(next));
                        switch (status) {
                            case ADDED: {
                                this.addDockable(next, false);
                                break;
                            }
                            case REMOVED: {
                                this.removeDockable(next);
                                break;
                            }
                            case REMOVED_AND_ADDED: 
                            case ADDED_AND_REMOVED: {
                                DockRegister.this.fireStalledChange(next);
                            }
                        }
                    }
                }
                finally {
                    this.firing = false;
                }
            }
        }

        @Override
        public void dockableAdding(DockStation station, Dockable dockable) {
            if (DockRegister.this.stalled > 0) {
                DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){
                    private DockStation protectedAncestor;

                    @Override
                    public void handleDockable(Dockable dockable) {
                        if (this.protectedAncestor == null || !DockUtilities.isAncestor(this.protectedAncestor, dockable)) {
                            DockStation station = dockable.asDockStation();
                            if (station != null && DockRegister.this.isProtected(station)) {
                                this.protectedAncestor = station;
                            } else {
                                Status current = (Status)((Object)DockRegister.this.changeMap.get(dockable));
                                if (current == null) {
                                    DockRegister.this.changeMap.put(dockable, Status.ADDED);
                                    DockRegister.this.changeQueue.add(dockable);
                                } else {
                                    switch (current) {
                                        case REMOVED: {
                                            DockRegister.this.changeMap.put(dockable, Status.REMOVED_AND_ADDED);
                                            break;
                                        }
                                        case ADDED_AND_REMOVED: {
                                            DockRegister.this.changeMap.put(dockable, Status.ADDED);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    public void handleDockStation(DockStation station) {
                        if (this.protectedAncestor == null || !DockUtilities.isAncestor(this.protectedAncestor, station)) {
                            station.addDockStationListener(StationListener.this);
                        }
                    }
                });
            } else {
                this.addDockable(dockable, true);
            }
        }

        private void addDockable(Dockable dockable, boolean requiresListener) {
            DockStation asStation = dockable.asDockStation();
            if (asStation != null) {
                DockRegister.this.add(asStation, requiresListener);
            } else {
                DockRegister.this.register(dockable);
            }
        }

        @Override
        public void dockableRemoving(DockStation station, Dockable dockable) {
            if (DockRegister.this.stalled > 0) {
                DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){
                    private DockStation protectedAncestor;

                    @Override
                    public void handleDockable(Dockable dockable) {
                        if (this.protectedAncestor == null || !DockUtilities.isAncestor(this.protectedAncestor, dockable)) {
                            DockStation station = dockable.asDockStation();
                            if (station != null && DockRegister.this.isProtected(station)) {
                                this.protectedAncestor = station;
                            } else {
                                Status current = (Status)((Object)DockRegister.this.changeMap.get(dockable));
                                if (current == null) {
                                    DockRegister.this.changeMap.put(dockable, Status.REMOVED);
                                    DockRegister.this.changeQueue.add(dockable);
                                } else {
                                    switch (current) {
                                        case ADDED: {
                                            DockRegister.this.changeMap.put(dockable, Status.ADDED_AND_REMOVED);
                                            break;
                                        }
                                        case REMOVED_AND_ADDED: {
                                            DockRegister.this.changeMap.put(dockable, Status.REMOVED);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    public void handleDockStation(DockStation station) {
                        if (this.protectedAncestor == null || !DockUtilities.isAncestor(this.protectedAncestor, station)) {
                            station.removeDockStationListener(StationListener.this);
                        }
                    }
                });
            }
        }

        @Override
        public void dockableRemoved(DockStation station, Dockable dockable) {
            if (dockable.getDockParent() != null && dockable.getDockParent() != station) {
                throw new IllegalStateException("the parent of dockable is wrong: it is neither null nor '" + station + "'");
            }
            dockable.setDockParent(null);
            if (DockRegister.this.stalled == 0) {
                this.removeDockable(dockable);
            }
        }

        private void removeDockable(Dockable dockable) {
            DockStation asStation = dockable.asDockStation();
            if (asStation != null) {
                if (!DockRegister.this.isProtected(asStation)) {
                    DockRegister.this.remove(asStation);
                }
            } else {
                DockRegister.this.unregister(dockable);
            }
        }
    }

    private static enum Status {
        ADDED,
        REMOVED,
        ADDED_AND_REMOVED,
        REMOVED_AND_ADDED;

    }
}

