/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.frontend.DefaultDockFrontendPerspective;
import bibliothek.gui.dock.frontend.DockFrontendInternals;
import bibliothek.gui.dock.frontend.DockFrontendPerspective;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.LayoutChangeStrategy;
import bibliothek.gui.dock.frontend.MissingDockableStrategy;
import bibliothek.gui.dock.frontend.RegisteringDockFactory;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PredefinedDockSituation;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.perspective.PredefinedMap;
import bibliothek.gui.dock.perspective.PredefinedPerspective;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.xml.XException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultLayoutChangeStrategy
implements LayoutChangeStrategy {
    private boolean updatingFullLayout = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setLayout(DockFrontendInternals frontend, Setting setting, boolean entry) throws IOException, XException {
        try {
            this.updatingFullLayout = true;
            boolean bl = this.updateLayout(frontend, setting, entry);
            return bl;
        }
        finally {
            this.updatingFullLayout = false;
        }
    }

    @Override
    public boolean shouldUpdateLayoutOnAdd(Dockable dockable) {
        return !this.updatingFullLayout;
    }

    private boolean updateLayout(DockFrontendInternals frontend, Setting setting, boolean entry) throws IOException, XException {
        SettingAccess access;
        PredefinedDockSituation situation = this.createSituation(frontend, entry, true);
        DockSituationIgnore ignore = situation.getIgnore();
        if (ignore == null) {
            ignore = new DockSituationIgnore(){

                @Override
                public boolean ignoreChildren(DockStation station) {
                    return false;
                }

                @Override
                public boolean ignoreElement(DockElement element) {
                    return false;
                }

                @Override
                public boolean ignoreChildren(PerspectiveStation station) {
                    return false;
                }

                @Override
                public boolean ignoreElement(PerspectiveElement element) {
                    return false;
                }
            };
        }
        if (this.approveClosing(frontend, situation, access = this.createAccess(frontend, setting)) == null) {
            return false;
        }
        frontend.clean(ignore);
        this.applyLayout(frontend, situation, access, entry);
        this.applyInvisibleLayout(frontend, situation, access);
        return true;
    }

    protected SettingAccess createAccess(DockFrontendInternals frontend, Setting setting) {
        return new SettingAccess(setting);
    }

    @Override
    public PredefinedDockSituation createSituation(DockFrontendInternals frontend, boolean entry) {
        return this.createSituation(frontend, entry, false);
    }

    protected PredefinedDockSituation createSituation(final DockFrontendInternals frontend, final boolean entry, boolean onSetLayout) {
        PredefinedDockSituation situation = new PredefinedDockSituation(frontend.getFrontend().getController()){

            @Override
            protected boolean shouldLayout(DockElement element) {
                DockFrontend.DockInfo info;
                Dockable dockable;
                if (entry && (dockable = element.asDockable()) != null && (info = frontend.getInfo(dockable)) != null) {
                    return info.isEntryLayout();
                }
                return true;
            }

            @Override
            protected boolean shouldLayout(PerspectiveElement element, PredefinedPerspective perspective) {
                DockFrontend.DockInfo info;
                String key;
                if (entry && (key = perspective.get(element)) != null && (info = frontend.getInfo(key)) != null) {
                    return info.isEntryLayout();
                }
                return true;
            }
        };
        for (DockFrontend.RootInfo rootInfo : frontend.getRoots()) {
            situation.put("root" + rootInfo.getName(), rootInfo.getStation());
        }
        for (DockFrontend.DockInfo dockInfo : frontend.getDockables()) {
            if (dockInfo.getDockable() == null || !this.shouldPredefine(dockInfo.getDockable())) continue;
            situation.put("dockable" + dockInfo.getKey(), dockInfo.getDockable());
        }
        for (DockFactory<?, ?, ?> dockFactory : frontend.getDockFactories()) {
            situation.add(dockFactory);
        }
        for (DockFactory<?, ?, ?> dockFactory : frontend.getBackupDockFactories()) {
            situation.addBackup(new RegisteringDockFactory(frontend.getFrontend(), dockFactory));
        }
        for (AdjacentDockFactory<?> adjacentDockFactory : frontend.getAdjacentDockFactories()) {
            situation.addAdjacent(adjacentDockFactory);
        }
        if (entry) {
            situation.setIgnore(frontend.getFrontend().getIgnoreForEntry());
        } else {
            situation.setIgnore(frontend.getFrontend().getIgnoreForFinal());
        }
        return situation;
    }

    protected boolean shouldPredefine(Dockable dockable) {
        return true;
    }

    @Override
    public DockFrontendPerspective createPerspective(DockFrontendInternals frontend, boolean entry, final FrontendPerspectiveCache cache) {
        PerspectiveElement element;
        PredefinedDockSituation situation = this.createSituation(frontend, entry);
        PredefinedPerspective perspective = situation.createPerspective();
        for (DockFrontend.DockInfo dockInfo : frontend.getDockables()) {
            if (dockInfo.getDockable() == null || (element = cache.get(dockInfo.getKey(), dockInfo.getDockable(), false)) == null) continue;
            perspective.put("dockable" + dockInfo.getKey(), element);
        }
        for (DockFrontend.RootInfo rootInfo : frontend.getRoots()) {
            element = cache.get(rootInfo.getName(), rootInfo.getStation(), true);
            perspective.put("root" + rootInfo.getName(), element);
        }
        perspective.put(new PredefinedMap(){

            @Override
            public PerspectiveElement get(String id) {
                if (id.startsWith("dockable")) {
                    return cache.get(id.substring("dockable".length()), false);
                }
                if (id.startsWith("root")) {
                    return cache.get(id.substring("root".length()), true);
                }
                return null;
            }

            @Override
            public String get(PerspectiveElement element) {
                String id = cache.get(element);
                if (id == null) {
                    return null;
                }
                if (element.asStation() != null && cache.isRootStation(element.asStation())) {
                    return "root" + id;
                }
                return "dockable" + id;
            }
        });
        return new DefaultDockFrontendPerspective(frontend.getFrontend(), perspective, entry);
    }

    @Override
    public PropertyTransformer createTransformer(DockFrontendInternals frontend) {
        PropertyTransformer transformer = new PropertyTransformer(frontend.getFrontend().getController());
        for (DockablePropertyFactory factory : frontend.getPropertyFactories()) {
            transformer.addFactory(factory);
        }
        return transformer;
    }

    protected void applyLayout(DockFrontendInternals frontend, DockSituation situation, SettingAccess setting, boolean entry) throws IOException, XException {
        DockFrontend dockFrontend = frontend.getFrontend();
        MissingDockableStrategy missingDockable = frontend.getMissingDockableStrategy();
        for (DockFrontend.RootInfo info : frontend.getRoots()) {
            Map<String, DockLayoutComposition> missingLayouts;
            DockLayoutComposition layout = setting.getRoot(info.getName());
            if (layout == null) continue;
            Map<String, DockableProperty> missingLocations = this.listEstimateLocations(situation, layout = situation.fillMissing(layout));
            if (missingLocations != null) {
                for (Map.Entry<String, DockableProperty> missing : missingLocations.entrySet()) {
                    String key = missing.getKey();
                    DockFrontend.DockInfo dockInfo = frontend.getInfo(key);
                    if (dockInfo == null && missingDockable.shouldStoreShown(key)) {
                        dockFrontend.addEmpty(key);
                        dockInfo = frontend.getInfo(key);
                    }
                    if (dockInfo == null) continue;
                    dockInfo.setLocation(info.getName(), missing.getValue());
                    dockInfo.setShown(true);
                }
            }
            if ((missingLayouts = this.listLayouts(situation, layout)) != null) {
                for (Map.Entry<String, DockLayoutComposition> missing : missingLayouts.entrySet()) {
                    String key = missing.getKey();
                    DockFrontend.DockInfo dockInfo = frontend.getInfo(key);
                    if (dockInfo == null && missingDockable.shouldStoreShown(key)) {
                        dockFrontend.addEmpty(key);
                        dockInfo = frontend.getInfo(key);
                    }
                    if (dockInfo == null) continue;
                    dockInfo.setShown(true);
                    if (entry && !dockInfo.isEntryLayout()) continue;
                    dockInfo.setLayout(missing.getValue());
                }
            }
            situation.convert(layout);
        }
    }

    protected void applyInvisibleLayout(DockFrontendInternals frontend, DockSituation situation, SettingAccess setting) throws IOException, XException {
        DockFrontend dockFrontend = frontend.getFrontend();
        MissingDockableStrategy missingDockable = frontend.getMissingDockableStrategy();
        int n = setting.getInvisibleCount();
        for (int i = 0; i < n; ++i) {
            String key = setting.getInvisibleKey(i);
            DockFrontend.DockInfo info = frontend.getInfo(key);
            if (info == null && missingDockable.shouldStoreHidden(key)) {
                dockFrontend.addEmpty(key);
                info = frontend.getInfo(key);
            }
            if (info == null) continue;
            info.setShown(false);
            info.setLocation(setting.getInvisibleRoot(i), setting.getInvisibleLocation(i));
            DockLayoutComposition layout = setting.getInvisibleLayout(i);
            if (layout == null) continue;
            layout = situation.fillMissing(layout);
            if (info.getDockable() != null) {
                situation.convert(layout);
                layout = null;
            }
            info.setLayout(layout);
        }
    }

    protected Map<String, DockLayoutComposition> listLayouts(DockSituation situation, DockLayoutComposition layout) {
        if (situation instanceof PredefinedDockSituation) {
            Map<String, DockLayoutComposition> map = ((PredefinedDockSituation)situation).listLayouts(layout, true);
            HashMap<String, DockLayoutComposition> result = new HashMap<String, DockLayoutComposition>();
            for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
                String key = entry.getKey();
                if (key.startsWith("dockable")) {
                    result.put(key.substring("dockable".length()), entry.getValue());
                    continue;
                }
                if (key.startsWith("root")) {
                    result.put(key.substring("root".length()), entry.getValue());
                    continue;
                }
                result.put(key, entry.getValue());
            }
            return result;
        }
        return null;
    }

    protected Map<String, DockableProperty> listEstimateLocations(DockSituation situation, DockLayoutComposition layout) {
        if (situation instanceof PredefinedDockSituation) {
            Map<String, DockableProperty> map = ((PredefinedDockSituation)situation).listEstimatedLocations(layout, true);
            HashMap<String, DockableProperty> result = new HashMap<String, DockableProperty>();
            for (Map.Entry<String, DockableProperty> entry : map.entrySet()) {
                String key = entry.getKey();
                if (key.startsWith("dockable")) {
                    result.put(key.substring("dockable".length()), entry.getValue());
                    continue;
                }
                if (key.startsWith("root")) {
                    result.put(key.substring("root".length()), entry.getValue());
                    continue;
                }
                result.put(key, entry.getValue());
            }
            return result;
        }
        return null;
    }

    @Override
    public void estimateLocations(DockFrontendInternals frontend, DockSituation situation, DockLayoutComposition layout) {
        if (situation instanceof PredefinedDockSituation) {
            ((PredefinedDockSituation)situation).estimateLocations(layout);
        }
    }

    protected Collection<Dockable> approveClosing(DockFrontendInternals frontend, DockSituation situation, SettingAccess setting) {
        HashSet<Dockable> remainingVisible = new HashSet<Dockable>();
        for (DockFrontend.RootInfo info : frontend.getRoots()) {
            Set<Dockable> visible;
            DockLayoutComposition layout = setting.getRoot(info.getName());
            if (layout == null || (visible = this.estimateVisible(frontend, situation, layout)) == null) continue;
            remainingVisible.addAll(visible);
        }
        Collection<Dockable> closing = this.getClosingDockables(frontend, remainingVisible);
        if (!closing.isEmpty() && !frontend.getVetos().expectToHide(closing, true)) {
            return null;
        }
        return closing;
    }

    protected Collection<Dockable> getClosingDockables(DockFrontendInternals frontend, Set<Dockable> visible) {
        ArrayList<Dockable> closing = new ArrayList<Dockable>();
        for (DockFrontend.DockInfo info : frontend.getDockables()) {
            Dockable dockable = info.getDockable();
            if (dockable == null || !info.isHideable() || visible.contains(dockable)) continue;
            closing.add(info.getDockable());
        }
        return closing;
    }

    protected Set<Dockable> estimateVisible(DockFrontendInternals frontend, DockSituation situation, DockLayoutComposition layout) {
        if (situation instanceof PredefinedDockSituation) {
            HashSet<Dockable> allDockables = new HashSet<Dockable>();
            for (DockFrontend.DockInfo info : frontend.getDockables()) {
                Dockable dockable = info.getDockable();
                if (dockable == null) continue;
                allDockables.add(dockable);
            }
            PredefinedDockSituation predefined = (PredefinedDockSituation)situation;
            Set<Dockable> visible = predefined.listVisible(allDockables, layout);
            return visible;
        }
        return null;
    }

    @Override
    public PlaceholderStrategy getPlaceholderStrategy(DockFrontendInternals frontend) {
        return null;
    }

    protected class SettingAccess {
        private Setting setting;

        public SettingAccess(Setting setting) {
            this.setting = setting;
        }

        public Setting getSetting() {
            return this.setting;
        }

        public DockLayoutComposition getRoot(String root) {
            return this.setting.getRoot(root);
        }

        public String[] getRootKeys() {
            return this.setting.getRootKeys();
        }

        public int getInvisibleCount() {
            return this.setting.getInvisibleCount();
        }

        public String getInvisibleKey(int index) {
            return this.setting.getInvisibleKey(index);
        }

        public String getInvisibleRoot(int index) {
            return this.setting.getInvisibleRoot(index);
        }

        public DockableProperty getInvisibleLocation(int index) {
            return this.setting.getInvisibleLocation(index);
        }

        public DockLayoutComposition getInvisibleLayout(int index) {
            return this.setting.getInvisibleLayout(index);
        }

        public void fillMissing(DockSituation situation) {
            this.setting.fillMissing(situation);
        }
    }
}

