/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.perspective;

import bibliothek.gui.dock.layout.PredefinedDockSituation;
import bibliothek.gui.dock.perspective.Perspective;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PredefinedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PredefinedPerspective
extends Perspective {
    private Map<String, PerspectiveElement> stringToElement = new HashMap<String, PerspectiveElement>();
    private Map<PerspectiveElement, String> elementToString = new HashMap<PerspectiveElement, String>();
    private List<PredefinedMap> maps = new ArrayList<PredefinedMap>();

    public PredefinedPerspective(PredefinedDockSituation situation) {
        super(situation);
    }

    @Override
    public PredefinedDockSituation getSituation() {
        return (PredefinedDockSituation)super.getSituation();
    }

    public void put(PredefinedMap map) {
        if (map == null) {
            throw new IllegalArgumentException("map must no be null");
        }
        this.maps.add(map);
    }

    public void put(String key, PerspectiveElement element) {
        PerspectiveElement old = this.stringToElement.remove(key);
        if (old != null) {
            this.elementToString.remove(old);
        }
        this.stringToElement.put(key, element);
        this.elementToString.put(element, key);
    }

    public String[] getKeys() {
        return this.stringToElement.keySet().toArray(new String[this.stringToElement.size()]);
    }

    public String get(PerspectiveElement element) {
        String result = this.elementToString.get(element);
        if (result == null) {
            for (PredefinedMap map : this.maps) {
                result = map.get(element);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public PerspectiveElement get(String key) {
        PerspectiveElement result = this.stringToElement.get(key);
        if (result == null) {
            for (PredefinedMap map : this.maps) {
                result = map.get(key);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }
}

