/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.station.screen.BoundaryRestriction;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JDesktopPane;

public class InternalBoundaryRestriction
implements BoundaryRestriction {
    private JDesktopPane desktop;
    private Dimension lastSize = null;

    public InternalBoundaryRestriction(JDesktopPane desktop) {
        this.desktop = desktop;
    }

    @Override
    public Rectangle check(ScreenDockWindow window) {
        return this.validate(window.getWindowBounds(), window.getTitleCenter());
    }

    @Override
    public Rectangle check(ScreenDockWindow window, Rectangle target) {
        return this.validate(target, window.getTitleCenter());
    }

    protected Rectangle validate(Rectangle destination, Point center) {
        if (this.desktop.isVisible()) {
            if (this.lastSize == null || this.lastSize.width == 0 || this.lastSize.height == 0) {
                this.lastSize = this.desktop.getSize();
            } else {
                if (center == null) {
                    center = new Point(destination.width / 2, destination.height / 2);
                }
                Rectangle result = new Rectangle(destination);
                result.x = Math.max(-center.x, result.x);
                result.x = Math.min(result.x, this.desktop.getWidth() - center.x);
                result.y = Math.max(-center.y, result.y);
                result.y = Math.min(this.desktop.getHeight() - center.y, result.y);
                return result;
            }
        }
        return null;
    }
}

