/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DockActionDistributorSource
extends AbstractDockActionSource {
    private DockActionDistributor.Target target;
    private DockActionSource source;
    private Dockable dockable;
    private boolean buildSourceCheck = false;
    private DockHierarchyListener listener = new DockHierarchyListener(){

        @Override
        public void hierarchyChanged(DockHierarchyEvent event) {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent event) {
            DockActionDistributorSource.this.reset();
        }
    };
    private PropertyValue<DockActionDistributor> distributor = new PropertyValue<DockActionDistributor>(new PropertyKey("dock.empty")){

        @Override
        protected void valueChanged(DockActionDistributor oldValue, DockActionDistributor newValue) {
            DockActionDistributorSource.this.buildSource(false);
        }
    };
    private DockActionSourceListener actionListener = new DockActionSourceListener(){

        @Override
        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            DockActionDistributorSource.this.fireRemoved(firstIndex, lastIndex);
        }

        @Override
        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            DockActionDistributorSource.this.fireAdded(firstIndex, lastIndex);
        }
    };

    public DockActionDistributorSource(DockActionDistributor.Target target, PropertyKey<DockActionDistributor> key) {
        this.target = target;
        this.distributor.setKey(key);
    }

    public DockActionDistributorSource(DockActionDistributor.Target target, PropertyKey<DockActionDistributor> key, Dockable dockable) {
        this(target, key);
        this.setDockable(dockable);
    }

    private DockActionSource source() {
        if (this.dockable == null) {
            return null;
        }
        if (this.source != null) {
            return this.source;
        }
        DockController controller = this.dockable.getController();
        if (controller == null) {
            return null;
        }
        DockActionDistributor distributor = controller.getProperties().get(this.distributor.getKey());
        return distributor.createSource(this.dockable, this.target);
    }

    @Override
    public DockAction getDockAction(int index) {
        DockActionSource source = this.source();
        return source.getDockAction(index);
    }

    @Override
    public int getDockActionCount() {
        DockActionSource source = this.source();
        if (source == null) {
            return 0;
        }
        return source.getDockActionCount();
    }

    @Override
    public LocationHint getLocationHint() {
        DockActionSource source = this.source();
        if (source == null) {
            return LocationHint.UNKNOWN;
        }
        return source.getLocationHint();
    }

    @Override
    public Iterator<DockAction> iterator() {
        DockActionSource source = this.source();
        if (source == null) {
            return new Iterator<DockAction>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public DockAction next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                }
            };
        }
        return source.iterator();
    }

    public void setDockable(Dockable dockable) {
        if (this.dockable != dockable) {
            if (this.dockable != null) {
                this.dockable.removeDockHierarchyListener(this.listener);
                this.dockable = null;
                this.setSource(null);
            }
            this.dockable = dockable;
            if (this.dockable != null) {
                if (this.hasListeners()) {
                    this.dockable.addDockHierarchyListener(this.listener);
                }
                this.reset();
            }
        }
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener listener) {
        if (!this.hasListeners() && this.dockable != null) {
            this.dockable.addDockHierarchyListener(this.listener);
            this.distributor.setProperties(this.dockable.getController());
            this.buildSource(true);
        }
        super.addDockActionSourceListener(listener);
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener listener) {
        super.removeDockActionSourceListener(listener);
        if (!this.hasListeners() && this.dockable != null) {
            this.dockable.removeDockHierarchyListener(this.listener);
            this.distributor.setProperties((DockProperties)null);
            this.setSource(null);
        }
    }

    private void setSource(DockActionSource source) {
        if (this.source != source) {
            int size;
            if (this.source != null) {
                size = this.getDockActionCount();
                this.source.removeDockActionSourceListener(this.actionListener);
                this.source = null;
                if (size > 0) {
                    this.fireRemoved(0, size - 1);
                }
            }
            this.source = source;
            if (this.source != null) {
                size = this.getDockActionCount();
                if (size > 0) {
                    this.fireAdded(0, size - 1);
                }
                this.source.addDockActionSourceListener(this.actionListener);
            }
        }
    }

    private void reset() {
        if (this.dockable != null && this.hasListeners()) {
            DockController controller = this.dockable.getController();
            if (controller == null) {
                this.setSource(null);
            }
            this.buildSourceCheck = true;
            this.distributor.setProperties(controller);
            if (this.buildSourceCheck) {
                this.buildSource(false);
            }
        }
    }

    private void buildSource(boolean force) {
        if (force || this.hasListeners()) {
            this.buildSourceCheck = false;
            if (this.dockable != null) {
                this.setSource(this.distributor.getValue().createSource(this.dockable, this.target));
            }
        }
    }
}

