/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.station.stack.CombinedHandler;
import bibliothek.gui.dock.station.stack.menu.AbstractCombinedMenu;
import bibliothek.gui.dock.station.stack.tab.TabMenuDockIcon;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPaint;
import java.awt.Component;
import javax.swing.Icon;

public abstract class ButtonCombinedMenu<B extends Component>
extends AbstractCombinedMenu {
    private B button;
    private TabMenuDockIcon icon = new TabMenuDockIcon("dock.menu.overflow", this){

        @Override
        protected void changed(Icon oldValue, Icon newValue) {
            ButtonCombinedMenu.this.currentIcon = newValue;
            if (ButtonCombinedMenu.this.button != null) {
                ButtonCombinedMenu.this.getModel(ButtonCombinedMenu.this.button).setIcon(ActionContentModifier.NONE, newValue);
            }
        }
    };
    private Icon currentIcon;

    public ButtonCombinedMenu(TabPane pane, CombinedHandler<? super AbstractCombinedMenu> handler) {
        super(pane, handler);
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        if (controller == null) {
            this.icon.setManager(null);
        } else {
            this.icon.setManager(controller.getIcons());
        }
    }

    @Override
    protected void backgroundChanged(BackgroundPaint paint) {
        if (this.button != null) {
            this.getModel(this.button).setBackground(paint, this.getBackground());
        }
    }

    @Override
    protected Component createComponent() {
        BasicTrigger trigger = new BasicTrigger(){

            @Override
            public void triggered() {
                ButtonCombinedMenu.this.open();
            }

            @Override
            public DockAction getAction() {
                return null;
            }

            @Override
            public Dockable getDockable() {
                return null;
            }
        };
        this.button = this.createButton(trigger);
        this.getModel(this.button).setIcon(ActionContentModifier.NONE, this.currentIcon);
        return this.button;
    }

    public B getButton() {
        return this.button;
    }

    protected abstract B createButton(BasicTrigger var1);

    protected abstract BasicButtonModel getModel(B var1);

    @Override
    protected void ensureComponent() {
        boolean set = this.button == null;
        super.ensureComponent();
        if (set) {
            BackgroundAlgorithm background = this.getBackground();
            this.getModel(this.button).setBackground(background.getPaint(), background);
        }
    }

    @Override
    protected void selected(Dockable dockable) {
        this.getTabParent().setSelectedDockable(dockable);
    }
}

