/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Condition;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class BasicDockTitle
extends AbstractDockTitle {
    public static final DockTitleFactory FACTORY = new DockTitleFactory(){

        @Override
        public void install(DockTitleRequest request) {
        }

        @Override
        public void uninstall(DockTitleRequest request) {
        }

        @Override
        public void request(DockTitleRequest request) {
            request.answer(new BasicDockTitle(request.getTarget(), request.getVersion()));
        }
    };
    private TitleColor activeLeftColor = new BasicTitleColor("title.active.left", Color.BLACK);
    private TitleColor inactiveLeftColor = new BasicTitleColor("title.inactive.left", Color.DARK_GRAY);
    private TitleColor disabledLeftColor = new BasicTitleColor("title.disabled.left", Color.LIGHT_GRAY);
    private TitleColor activeRightColor = new BasicTitleColor("title.active.right", Color.DARK_GRAY);
    private TitleColor inactiveRightColor = new BasicTitleColor("title.inactive.right", Color.LIGHT_GRAY);
    private TitleColor disabledRightColor = new BasicTitleColor("title.disabled.right", Color.LIGHT_GRAY);
    private TitleColor activeTextColor = new BasicTitleColor("title.active.text", Color.WHITE);
    private TitleColor inactiveTextColor = new BasicTitleColor("title.inactive.text", Color.BLACK);
    private GradientPaint gradient;

    public BasicDockTitle(Dockable dockable, DockTitleVersion origin) {
        this(dockable, origin, true);
    }

    protected BasicDockTitle(Dockable dockable, DockTitleVersion origin, boolean setDefaultConditionalFonts) {
        super(dockable, origin);
        this.setActive(false);
        this.addColor(this.activeLeftColor);
        this.addColor(this.inactiveLeftColor);
        this.addColor(this.disabledLeftColor);
        this.addColor(this.activeRightColor);
        this.addColor(this.inactiveRightColor);
        this.addColor(this.disabledRightColor);
        this.addColor(this.activeTextColor);
        this.addColor(this.inactiveTextColor);
        if (setDefaultConditionalFonts) {
            this.addConditionalFont("title.active", TitleFont.KIND_TITLE_FONT, new Condition(){

                @Override
                public boolean getState() {
                    return BasicDockTitle.this.isActive();
                }
            }, null);
            this.addConditionalFont("title.inactive", TitleFont.KIND_TITLE_FONT, new Condition(){

                @Override
                public boolean getState() {
                    return !BasicDockTitle.this.isActive();
                }
            }, null);
        }
    }

    @Override
    @Deprecated
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        this.gradient = null;
    }

    @Override
    public void validate() {
        this.gradient = null;
        super.validate();
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        this.gradient = null;
        super.setOrientation(orientation);
    }

    @Override
    protected void paintBackground(Graphics g, JComponent component) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.gradient == null) {
            this.gradient = this.isDisabled() ? this.getGradient((Color)this.disabledLeftColor.value(), (Color)this.disabledRightColor.value(), component) : (this.isActive() ? this.getGradient((Color)this.activeLeftColor.value(), (Color)this.activeRightColor.value(), component) : this.getGradient((Color)this.inactiveLeftColor.value(), (Color)this.inactiveRightColor.value(), component));
        }
        g2.setPaint(this.gradient);
        g.fillRect(0, 0, component.getWidth(), component.getHeight());
    }

    protected GradientPaint getGradient(Color left, Color right, Component component) {
        GradientPaint gradient;
        if (this.getOrientation().isHorizontal()) {
            float h = (float)component.getHeight() / 2.0f;
            gradient = new GradientPaint(0.0f, h, left, component.getWidth(), h, right, false);
        } else {
            float w = (float)component.getWidth() / 2.0f;
            gradient = new GradientPaint(w, 0.0f, left, w, component.getHeight(), right, false);
        }
        return gradient;
    }

    public Color getActiveLeftColor() {
        return (Color)this.activeLeftColor.value();
    }

    public TitleColor getActiveLeftTitleColor() {
        return this.activeLeftColor;
    }

    public void setActiveLeftColor(Color activeLeftColor) {
        this.activeLeftColor.setValue(activeLeftColor);
    }

    public void setActiveLeftColorId(String id) {
        this.activeLeftColor.setId(id);
    }

    public Color getActiveRightColor() {
        return (Color)this.activeRightColor.value();
    }

    public TitleColor getActiveRightTitleColor() {
        return this.activeRightColor;
    }

    public void setActiveRightColor(Color activeRightColor) {
        this.activeRightColor.setValue(activeRightColor);
    }

    public void setActiveRightColorId(String id) {
        this.activeRightColor.setId(id);
    }

    public Color getActiveTextColor() {
        return (Color)this.activeTextColor.value();
    }

    public TitleColor getActiveTextTitleColor() {
        return this.activeTextColor;
    }

    public void setActiveTextColor(Color activeTextColor) {
        this.activeTextColor.setValue(activeTextColor);
    }

    public void setActiveTextColorId(String id) {
        this.activeTextColor.setId(id);
    }

    public Color getDisabledLeftColor() {
        return (Color)this.disabledLeftColor.value();
    }

    public TitleColor getDisabledLeftTitleColor() {
        return this.disabledLeftColor;
    }

    public void setDisabledLeftColor(Color disabledLeftColor) {
        this.disabledLeftColor.setValue(disabledLeftColor);
    }

    public void setDisabledLeftColorId(String id) {
        this.disabledLeftColor.setId(id);
    }

    public Color getDisabledRightColor() {
        return (Color)this.disabledRightColor.value();
    }

    public TitleColor getDisabledRightTitleColor() {
        return this.disabledRightColor;
    }

    public void setDisabledRightColor(Color disabledRightColor) {
        this.disabledRightColor.setValue(disabledRightColor);
    }

    public void setDisabledRightColorId(String id) {
        this.disabledRightColor.setId(id);
    }

    public Color getInactiveLeftColor() {
        return (Color)this.inactiveLeftColor.value();
    }

    public TitleColor getInactiveLeftTitleColor() {
        return this.inactiveLeftColor;
    }

    public void setInactiveLeftColor(Color inactiveLeftColor) {
        this.inactiveLeftColor.setValue(inactiveLeftColor);
    }

    public void setInactiveLeftColorId(String id) {
        this.inactiveLeftColor.setId(id);
    }

    public Color getInactiveRightColor() {
        return (Color)this.inactiveRightColor.value();
    }

    public TitleColor getInactiveRightTitleColor() {
        return this.inactiveRightColor;
    }

    public void setInactiveRightColor(Color inactiveRightColor) {
        this.inactiveRightColor.setValue(inactiveRightColor);
    }

    public void setInactiveRightColorId(String id) {
        this.activeRightColor.setId(id);
    }

    public Color getInactiveTextColor() {
        return (Color)this.inactiveTextColor.value();
    }

    public TitleColor getInactiveTextTitleColor() {
        return this.inactiveTextColor;
    }

    public void setInactiveTextColor(Color inactiveTextColor) {
        this.inactiveTextColor.setValue(inactiveTextColor);
    }

    public void setInactiveTextColorId(String id) {
        this.inactiveTextColor.setId(id);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.updateColors();
        this.updateFonts();
    }

    @Override
    protected void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.updateColors();
        this.updateFonts();
    }

    protected void updateColors() {
        this.gradient = null;
        if (this.isActive()) {
            if (this.activeTextColor != null) {
                this.setForeground((Color)this.activeTextColor.value());
            }
        } else if (this.inactiveTextColor != null) {
            this.setForeground((Color)this.inactiveTextColor.value());
        }
        this.repaint();
    }

    private class BasicTitleColor
    extends TitleColor {
        public BasicTitleColor(String id, Color backup) {
            super(id, BasicDockTitle.this, backup);
        }

        @Override
        protected void changed(Color oldColor, Color newColor) {
            BasicDockTitle.this.gradient = null;
            BasicDockTitle.this.updateColors();
        }
    }
}

