/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockComponentListener;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.StackDockComponentRepresentative;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.station.stack.action.DockActionDistributorSource;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecoratorListener;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class TabDecorator
implements BasicDockableDisplayerDecorator,
StackDockComponentParent {
    private StackDockComponentListener componentListener = new StackDockComponentListener(){

        @Override
        public void tabChanged(StackDockComponent stack, Dockable dockable) {
            TabDecorator.this.fireMoveableElementChanged();
        }

        @Override
        public void selectionChanged(StackDockComponent stack) {
        }
    };
    private PropertyValue<StackDockComponentFactory> factory = new PropertyValue<StackDockComponentFactory>(StackDockStation.COMPONENT_FACTORY){

        @Override
        protected void valueChanged(StackDockComponentFactory oldValue, StackDockComponentFactory newValue) {
            TabContentFilter filter = null;
            if (TabDecorator.this.filter != null) {
                filter = (TabContentFilter)TabDecorator.this.filter.getValue();
            }
            if (TabDecorator.this.component != null) {
                TabDecorator.this.component.setController(null);
                TabDecorator.this.component.removeAll();
                if (filter != null) {
                    filter.uninstall(TabDecorator.this.component);
                }
                TabDecorator.this.component.removeStackDockComponentListener(TabDecorator.this.componentListener);
                TabDecorator.this.component = null;
            }
            if (newValue != null) {
                TabDecorator.this.component = newValue.create(TabDecorator.this);
                TabDecorator.this.component.setDockTabPlacement((TabPlacement)((Object)TabDecorator.this.tabPlacement.getValue()));
                if (filter != null) {
                    filter.install(TabDecorator.this.component);
                }
                TabDecorator.this.component.setController(TabDecorator.this.controller);
                TabDecorator.this.component.addStackDockComponentListener(TabDecorator.this.componentListener);
                if (TabDecorator.this.dockable != null) {
                    TabDecorator.this.component.addTab(TabDecorator.this.dockable.getTitleText(), TabDecorator.this.dockable.getTitleIcon(), TabDecorator.this.representation, TabDecorator.this.dockable);
                    TabDecorator.this.component.setSelectedIndex(0);
                }
            }
            TabDecorator.this.representative.setComponent(TabDecorator.this.component);
            TabDecorator.this.fireMoveableElementChanged();
        }
    };
    private PropertyValue<TabPlacement> tabPlacement = new PropertyValue<TabPlacement>(StackDockStation.TAB_PLACEMENT){

        @Override
        protected void valueChanged(TabPlacement oldValue, TabPlacement newValue) {
            if (TabDecorator.this.component != null) {
                TabDecorator.this.component.setDockTabPlacement(newValue);
            }
        }
    };
    private PropertyValue<TabContentFilter> filter = new PropertyValue<TabContentFilter>(StackDockStation.TAB_CONTENT_FILTER){

        @Override
        protected void valueChanged(TabContentFilter oldValue, TabContentFilter newValue) {
            if (oldValue != null) {
                if (TabDecorator.this.component != null) {
                    oldValue.uninstall(TabDecorator.this.component);
                }
                oldValue.removeListener(TabDecorator.this.filterListener);
            }
            if (newValue != null) {
                if (TabDecorator.this.component != null) {
                    newValue.install(TabDecorator.this.component);
                }
                newValue.addListener(TabDecorator.this.filterListener);
            }
            TabDecorator.this.updateTabContent();
        }
    };
    private DockableListener dockableListener = new DockableAdapter(){

        @Override
        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            TabDecorator.this.updateTabContent();
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            TabDecorator.this.updateTabContent();
        }

        @Override
        public void titleToolTipChanged(Dockable dockable, String oldTooltip, String newTooltip) {
            TabDecorator.this.updateTabContent();
        }
    };
    private TabContentFilterListener filterListener = new TabContentFilterListener(){

        @Override
        public void contentChanged() {
            TabDecorator.this.updateTabContent();
        }

        @Override
        public void contentChanged(StackDockComponent component) {
            if (component == TabDecorator.this.component) {
                TabDecorator.this.updateTabContent();
            }
        }

        @Override
        public void contentChanged(StackDockStation station) {
        }

        @Override
        public void contentChanged(Dockable dockable) {
            if (dockable == TabDecorator.this.dockable) {
                TabDecorator.this.updateTabContent();
            }
        }
    };
    private DockController controller;
    private Dockable dockable;
    private DockStation station;
    private StackDockComponent component;
    private Component representation;
    private StackDockComponentRepresentative representative = new StackDockComponentRepresentative();
    private DockActionDistributorSource actions;
    private List<BasicDockableDisplayerDecoratorListener> listeners = new ArrayList<BasicDockableDisplayerDecoratorListener>(2);

    public TabDecorator(DockStation station, PropertyKey<DockActionDistributor> distributor) {
        this.station = station;
        if (distributor != null) {
            this.actions = new DockActionDistributorSource(DockActionDistributor.Target.TITLE, distributor);
        }
    }

    @Override
    public void addDecoratorListener(BasicDockableDisplayerDecoratorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDecoratorListener(BasicDockableDisplayerDecoratorListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireMoveableElementChanged() {
        for (BasicDockableDisplayerDecoratorListener listener : this.listeners.toArray(new BasicDockableDisplayerDecoratorListener[this.listeners.size()])) {
            listener.moveableElementChanged(this);
        }
    }

    @Override
    public DockStation getStackDockParent() {
        return this.station;
    }

    @Override
    public int indexOf(Dockable dockable) {
        if (this.dockable == dockable) {
            return 0;
        }
        return -1;
    }

    public StackDockComponent getStackComponent() {
        return this.component;
    }

    @Override
    public void setDockable(Component panel, Dockable dockable) {
        if (this.dockable != null) {
            this.dockable.removeDockableListener(this.dockableListener);
        }
        this.dockable = dockable;
        this.representation = panel;
        if (this.dockable != null) {
            this.dockable.addDockableListener(this.dockableListener);
        }
        if (this.component != null) {
            this.component.removeAll();
            if (dockable != null) {
                this.component.addTab(null, null, this.representation, dockable);
                this.component.setSelectedIndex(0);
                this.updateTabContent();
            }
        }
        this.representative.setTarget(dockable);
        if (this.actions != null) {
            this.actions.setDockable(dockable);
        }
        this.fireMoveableElementChanged();
    }

    @Override
    public DockElementRepresentative getMoveableElement() {
        if (this.component != null && this.component.getTabCount() > 0) {
            return this.component.getTabAt(0);
        }
        return null;
    }

    private void updateTabContent() {
        if (this.dockable != null && this.component != null && this.component.getTabCount() == 1) {
            TabContent content = new TabContent(this.dockable.getTitleIcon(), this.dockable.getTitleText(), this.dockable.getTitleToolTip());
            TabContentFilter contentFilter = this.filter.getValue();
            if (contentFilter != null) {
                content = contentFilter.filter(content, this.component, this.dockable);
            }
            if (content == null) {
                this.component.setTitleAt(0, null);
                this.component.setIconAt(0, null);
                this.component.setTooltipAt(0, null);
            } else {
                this.component.setTitleAt(0, content.getTitle());
                this.component.setIconAt(0, content.getIcon());
                this.component.setTooltipAt(0, content.getTooltip());
            }
        }
    }

    @Override
    public void setController(DockController controller) {
        this.controller = controller;
        this.factory.setProperties(controller);
        this.tabPlacement.setProperties(controller);
        this.filter.setProperties(controller);
        if (this.component != null) {
            this.component.setController(controller);
        }
        this.representative.setController(controller);
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            return null;
        }
        return this.component.getComponent();
    }

    @Override
    public DockActionSource getActionSuggestion() {
        return this.actions;
    }

    @Override
    public Insets getDockableInsets() {
        if (this.representation == null) {
            return new Insets(0, 0, 0, 0);
        }
        Point location = new Point(0, 0);
        SwingUtilities.convertPoint(this.representation, location, this.getComponent());
        Dimension size = this.getComponent().getSize();
        Dimension used = this.representation.getSize();
        return new Insets(location.y, location.x, size.height - used.height - location.y, size.width - used.width - location.x);
    }
}

