/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonTrigger;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.util.container.Triple;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class BasicDropDownButtonModel
extends BasicButtonModel {
    private boolean overDropDown = false;
    private boolean selectionEnabled = true;
    private BasicDropDownButtonTrigger trigger;

    public BasicDropDownButtonModel(JComponent owner, BasicDropDownButtonTrigger trigger, BasicResourceInitializer initializer) {
        this(owner, trigger, initializer, true);
    }

    public BasicDropDownButtonModel(JComponent owner, BasicDropDownButtonTrigger trigger, BasicResourceInitializer initializer, boolean createListener) {
        super(owner, trigger, initializer, createListener);
        this.trigger = trigger;
        if (createListener) {
            Listener listener = new Listener();
            owner.addMouseMotionListener(listener);
        }
    }

    @Override
    protected List<Triple<KeyStroke, String, Action>> listActions() {
        List<Triple<KeyStroke, String, Action>> list = super.listActions();
        Triple<KeyStroke, String, 1> popup = new Triple<KeyStroke, String, 1>();
        popup.setA(KeyStroke.getKeyStroke(40, 0, true));
        popup.setB("basic_drop_down_model_popup");
        popup.setC(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDropDownButtonModel.this.popupTriggered();
            }
        });
        list.add(popup);
        return list;
    }

    @Override
    protected void setMouseInside(boolean mouseInside) {
        super.setMouseInside(mouseInside);
        if (!mouseInside) {
            this.setMouseOverDropDown(false);
        }
    }

    protected void setMouseOverDropDown(boolean overDropDown) {
        this.overDropDown = overDropDown;
        this.changed();
    }

    public boolean isMouseOverDropDown() {
        return this.overDropDown;
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        this.selectionEnabled = selectionEnabled;
        this.changed();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    @Override
    public Icon getPaintIcon() {
        return super.getPaintIcon(this.isEnabled() && this.isSelectionEnabled());
    }

    protected abstract boolean inDropDownArea(int var1, int var2);

    protected void popupTriggered() {
        this.trigger.popupTriggered();
    }

    private class Listener
    extends MouseMotionAdapter {
        private Listener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            boolean over = BasicDropDownButtonModel.this.inDropDownArea(e.getX(), e.getY());
            if (over != BasicDropDownButtonModel.this.overDropDown) {
                BasicDropDownButtonModel.this.setMouseOverDropDown(over);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            boolean over = BasicDropDownButtonModel.this.inDropDownArea(e.getX(), e.getY());
            if (over != BasicDropDownButtonModel.this.overDropDown) {
                BasicDropDownButtonModel.this.setMouseOverDropDown(over);
            }
        }
    }
}

