/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.border;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.themes.border.DockBorder;
import bibliothek.util.Path;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class BorderForwarder
implements DockBorder {
    private JComponent target;
    private Border border;
    private BorderModifier modifier;
    private boolean forwarding = false;
    private DockController controller;
    private Path kind;
    private String id;

    public BorderForwarder(Path kind, String id, JComponent target) {
        if (kind == null) {
            throw new IllegalArgumentException("kind must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        this.kind = kind;
        this.id = id;
        this.target = target;
    }

    public void setBorder(Border border) {
        if (this.border != border) {
            this.border = border;
            if (this.modifier == null) {
                this.forward(border);
            } else {
                this.forward(this.modifier.modify(border));
            }
        }
    }

    @Override
    public void set(BorderModifier value) {
        if (this.modifier != value) {
            this.modifier = value;
            if (this.modifier == null) {
                this.forward(this.border);
            } else {
                this.forward(this.modifier.modify(this.border));
            }
        }
    }

    public BorderModifier get() {
        return this.modifier;
    }

    public void setController(DockController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.getThemeManager().remove(this);
            }
            this.controller = controller;
            if (this.controller != null) {
                this.controller.getThemeManager().add(this.id, this.kind, ThemeManager.BORDER_MODIFIER_TYPE, this);
            } else {
                this.set(null);
            }
        }
    }

    protected void forward(Border border) {
        try {
            this.forwarding = true;
            this.target.setBorder(border);
        }
        finally {
            this.forwarding = false;
        }
    }

    public boolean isForwarding() {
        return this.forwarding;
    }
}

