/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleBackgroundComponent;
import bibliothek.gui.dock.title.DockTitleEvent;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.title.OrientationToRotationStrategy;
import bibliothek.gui.dock.title.OrientationToRotationStrategyListener;
import bibliothek.gui.dock.title.TitleDockBorder;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import bibliothek.gui.dock.util.font.AbstractDockFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.render.DockRenderingHints;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import bibliothek.util.Condition;
import bibliothek.util.Path;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public abstract class AbstractMultiDockTitle
extends ConfiguredBackgroundPanel
implements DockTitle {
    private static final Insets DEFAULT_INSETS_HORIZONTAL = new Insets(0, 1, 0, 1);
    private static final Insets DEFAULT_INSETS_VERTICAL = new Insets(1, 0, 1, 0);
    private Dockable dockable;
    private DockComponentRootHandler rootHandler;
    private OrientedLabel label = new OrientedLabel(){

        @Override
        protected void updateFonts() {
            AbstractMultiDockTitle.this.updateFonts();
        }
    };
    private Listener listener = new Listener();
    private DockTitleVersion origin;
    private boolean active = false;
    private boolean bound = false;
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private Icon icon;
    private Icon disabledIcon;
    private int iconTextGap = 0;
    private List<AbstractDockColor> colors = new ArrayList<AbstractDockColor>();
    private List<AbstractDockFont> fonts = new ArrayList<AbstractDockFont>();
    private List<ConditionalFont> conditionalFonts;
    private Background background = new Background();
    private TitleBorder border;
    private boolean disabled = false;
    private List<MouseInputListener> mouseInputListeners = new ArrayList<MouseInputListener>();
    private PropertyValue<OrientationToRotationStrategy> orientationConverter = new PropertyValue<OrientationToRotationStrategy>(DockTitle.ORIENTATION_STRATEGY){

        @Override
        protected void valueChanged(OrientationToRotationStrategy oldValue, OrientationToRotationStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeListener(AbstractMultiDockTitle.this.orientationListener);
                oldValue.uninstall(AbstractMultiDockTitle.this);
            }
            if (newValue != null) {
                newValue.install(AbstractMultiDockTitle.this);
                newValue.addListener(AbstractMultiDockTitle.this.orientationListener);
            }
            AbstractMultiDockTitle.this.updateLabelRotation();
        }
    };
    private OrientationToRotationStrategyListener orientationListener = new OrientationToRotationStrategyListener(){

        @Override
        public void rotationChanged(Dockable dockable, DockTitle title) {
            if (!(title != AbstractMultiDockTitle.this && title != null || dockable != AbstractMultiDockTitle.this.dockable && dockable != null)) {
                AbstractMultiDockTitle.this.updateLabelRotation();
            }
        }
    };

    public AbstractMultiDockTitle(Dockable dockable, DockTitleVersion origin) {
        super(Transparency.SOLID);
        this.init(dockable, origin);
    }

    protected AbstractMultiDockTitle() {
        super(Transparency.SOLID);
    }

    protected void init(Dockable dockable, DockTitleVersion origin) {
        this.dockable = dockable;
        this.origin = origin;
        this.label.setBackground(this.background);
        this.setBackground(this.background);
        this.setLayout(null);
        this.add(this.label);
        this.setActive(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component component) {
                return component != AbstractMultiDockTitle.this && super.accept(component);
            }
        });
        this.setOpaque(false);
        this.rootHandler = this.createRootHandler();
        this.rootHandler.addRoot(this.getComponent());
    }

    protected DockComponentRootHandler createRootHandler() {
        return new DockComponentRootHandler(this){

            @Override
            protected DockComponentRootHandler.TraverseResult shouldTraverse(Component component) {
                return DockComponentRootHandler.TraverseResult.INCLUDE_CHILDREN;
            }
        };
    }

    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
        this.revalidate();
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    protected void addColor(AbstractDockColor color) {
        this.colors.add(color);
        if (this.bound) {
            color.connect(this.getDockable().getController());
        }
    }

    protected void removeColor(AbstractDockColor color) {
        this.colors.remove(color);
        color.connect(null);
    }

    protected void addFont(AbstractDockFont font) {
        this.fonts.add(font);
        if (this.bound) {
            font.connect(this.getDockable().getController());
        }
    }

    protected void removeFont(AbstractDockFont font) {
        this.fonts.remove(font);
        font.connect(null);
    }

    protected void addConditionalFont(String id, Path kind, Condition condition, FontModifier backup) {
        ConditionalFont font = new ConditionalFont(id, kind, condition, backup);
        this.addFont(font);
        if (this.conditionalFonts == null) {
            this.conditionalFonts = new ArrayList<ConditionalFont>();
        }
        this.conditionalFonts.add(font);
        this.updateFonts();
    }

    protected void removeAllConditionalFonts() {
        if (this.conditionalFonts != null) {
            for (ConditionalFont font : this.conditionalFonts) {
                this.removeFont(font);
            }
            this.conditionalFonts = null;
            this.updateFonts();
        }
    }

    public Rectangle getIconBounds() {
        if (this.icon == null) {
            return null;
        }
        Insets insets = this.titleInsets();
        if (this.orientation.isVertical()) {
            int width = this.getWidth() - insets.left - insets.right;
            return new Rectangle(insets.left + (width - this.icon.getIconWidth()) / 2, insets.top, this.icon.getIconWidth(), this.icon.getIconHeight());
        }
        int height = this.getHeight() - insets.top - insets.bottom;
        return new Rectangle(insets.left, insets.top + (height - this.icon.getIconHeight()) / 2, this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    protected void setDisabled(boolean disabled) {
        block4: {
            if (this.disabled == disabled) break block4;
            this.disabled = disabled;
            this.label.setEnabled(!disabled);
            this.setEnabled(!disabled);
            if (disabled) {
                for (MouseInputListener listener : this.mouseInputListeners) {
                    this.doRemoveMouseInputListener(listener);
                }
            } else {
                for (MouseInputListener listener : this.mouseInputListeners) {
                    this.doAddMouseInputListener(listener);
                }
            }
        }
    }

    protected boolean isDisabled() {
        return this.disabled;
    }

    @Override
    protected void setupRenderingHints(Graphics g) {
        DockController controller;
        Dockable dockable = this.getDockable();
        if (dockable != null && (controller = dockable.getController()) != null) {
            DockRenderingHints renderingHints = controller.getProperties().get(DockRenderingHints.RENDERING_HINTS);
            renderingHints.setupGraphics(g);
        }
    }

    @Override
    public void paintBackground(Graphics g) {
        if (this.getTransparency() != Transparency.TRANSPARENT) {
            this.paintBackground(g, this);
        }
    }

    protected void paintBackground(Graphics g, JComponent component) {
        g.setColor(component.getBackground());
        g.fillRect(0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public void paintForeground(Graphics g) {
        this.paintForeground(g, this);
    }

    protected void paintForeground(Graphics g, JComponent component) {
        this.paintIcon(g, component);
    }

    protected void paintIcon(Graphics g, JComponent component) {
        Icon icon = this.icon;
        if (icon != null) {
            if (this.isDisabled()) {
                if (this.disabledIcon == null) {
                    this.disabledIcon = DockUtilities.disabledIcon(component, icon);
                }
                icon = this.disabledIcon;
            }
            if (icon != null) {
                Insets insets = this.titleInsets();
                if (this.orientation.isVertical()) {
                    int width = this.getWidth() - insets.left - insets.right;
                    icon.paintIcon(this, g, insets.left + (width - icon.getIconWidth()) / 2, insets.top);
                } else {
                    int height = this.getHeight() - insets.top - insets.bottom;
                    icon.paintIcon(this, g, insets.left, insets.top + (height - icon.getIconHeight()) / 2);
                }
            }
        }
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
        this.disabledIcon = null;
        this.revalidate();
        this.repaint();
    }

    protected Icon getIcon() {
        return this.icon;
    }

    protected OrientedLabel getLabel() {
        return this.label;
    }

    protected void setText(String text) {
        this.label.setText(text);
        this.repaint();
    }

    protected String getText() {
        return this.label.getText();
    }

    protected void setTooltip(String text) {
        this.setToolTipText(text);
        this.label.setToolTipText(text);
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        this.orientation = orientation;
        this.updateLabelRotation();
        this.revalidate();
    }

    private void updateLabelRotation() {
        this.label.setRotation(this.orientationConverter.getValue().convert(this.getOrientation(), this));
    }

    @Override
    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public DockTitleVersion getOrigin() {
        return this.origin;
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color fg) {
        super.setBackground(fg);
        if (this.label != null) {
            this.label.setBackground(fg);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    public void setFontModifier(FontModifier modifier) {
        this.label.setFontModifier(modifier);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.icon != null) {
            return new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
        }
        Dimension preferred = this.getPreferredSize();
        int min = Math.min(preferred.width, preferred.height);
        return new Dimension(min, min);
    }

    public void setBorder(String key, Border border) {
        if (!(this.border == null || key != null && this.border.id.equals(key))) {
            this.border.setController(null);
            this.border = null;
        }
        if (this.border == null && key != null) {
            this.border = new TitleBorder(key);
            if (this.bound) {
                this.border.setController(this.getOrigin().getController());
            }
        }
        if (this.border == null) {
            this.setBorder(border);
        } else {
            this.border.setBorder(border);
        }
    }

    protected Insets getInnerInsets() {
        if (this.getOrientation().isHorizontal()) {
            return DEFAULT_INSETS_HORIZONTAL;
        }
        return DEFAULT_INSETS_VERTICAL;
    }

    protected Insets titleInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            return this.getInnerInsets();
        }
        insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        Insets inner = this.getInnerInsets();
        insets.top += inner.top;
        insets.bottom += inner.bottom;
        insets.left += inner.left;
        insets.right += inner.right;
        return insets;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.doTitleLayout();
    }

    protected void doTitleLayout() {
        Insets insets = this.titleInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        if (this.orientation.isHorizontal()) {
            if (this.icon != null) {
                x += this.icon.getIconWidth() + this.iconTextGap;
                width -= this.icon.getIconWidth() + this.iconTextGap;
            }
            this.label.setBounds(x, y, width, height);
        } else {
            if (this.icon != null) {
                y += this.icon.getIconWidth() + this.iconTextGap;
                height -= this.icon.getIconWidth() + this.iconTextGap;
            }
            this.label.setBounds(x, y, width, height);
        }
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.mouseInputListeners.add(listener);
        if (!this.isDisabled()) {
            this.doAddMouseInputListener(listener);
        }
    }

    private void doAddMouseInputListener(MouseInputListener listener) {
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.label.addMouseListener(listener);
        this.label.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.mouseInputListeners.remove(listener);
        if (!this.isDisabled()) {
            this.doRemoveMouseInputListener(listener);
        }
    }

    private void doRemoveMouseInputListener(MouseInputListener listener) {
        this.removeMouseListener(listener);
        this.removeMouseMotionListener(listener);
        this.label.removeMouseListener(listener);
        this.label.removeMouseMotionListener(listener);
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        Rectangle icon = this.getIconBounds();
        if (icon != null && icon.contains(click)) {
            if (this.getOrientation().isHorizontal()) {
                return new Point(icon.x, icon.y + icon.height);
            }
            return new Point(icon.x + icon.width, icon.y);
        }
        return null;
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public DockElement getElement() {
        return this.getDockable();
    }

    @Override
    public boolean isUsedAsTitle() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return true;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void changed(DockTitleEvent event) {
        if (event instanceof ActivityDockTitleEvent) {
            this.setActive(((ActivityDockTitleEvent)event).isActive());
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferred = this.getText() == null || this.getText().length() == 0 ? new Dimension(5, 5) : this.label.getPreferredSize();
        Insets insets = this.titleInsets();
        if (this.orientation.isHorizontal()) {
            int width = 0;
            int height = 0;
            if (this.icon != null) {
                width = this.icon.getIconWidth();
                height = this.icon.getIconHeight();
            }
            height = Math.max(height, preferred.height);
            width += preferred.width;
            if (this.icon == null) {
                width = Math.max(width, 2 * height);
            }
            preferred = new Dimension(width + this.iconTextGap + insets.left + insets.right, height + insets.top + insets.bottom);
        } else {
            int width = 0;
            int height = 0;
            if (this.icon != null) {
                width = this.icon.getIconWidth();
                height = this.icon.getIconHeight();
            }
            width = Math.max(width, preferred.width);
            height += preferred.height;
            if (this.icon == null) {
                height = Math.max(height, 2 * width);
            }
            preferred = new Dimension(width + insets.left + insets.right, height + this.iconTextGap + insets.top + insets.bottom);
        }
        return preferred;
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(action, ViewTarget.TITLE, dockable);
    }

    @Override
    public void bind() {
        if (this.bound) {
            throw new IllegalArgumentException("Do not call bound twice!");
        }
        this.bound = true;
        DockController controller = this.getDockable().getController();
        this.dockable.addDockableListener(this.listener);
        if (controller != null) {
            for (AbstractDockColor color : this.colors) {
                color.connect(controller);
            }
            for (AbstractDockFont font : this.fonts) {
                font.connect(controller);
            }
            this.orientationConverter.setProperties(controller);
        }
        this.background.setController(controller);
        if (this.border != null) {
            this.border.setController(controller);
        }
        this.updateText();
        this.updateIcon();
        this.updateTooltip();
        this.rootHandler.setController(controller);
        this.revalidate();
    }

    @Override
    public void unbind() {
        if (!this.bound) {
            throw new IllegalArgumentException("Do not call unbind twice");
        }
        this.bound = false;
        this.dockable.removeDockableListener(this.listener);
        this.rootHandler.setController(null);
        for (AbstractDockColor color : this.colors) {
            color.connect(null);
        }
        for (AbstractDockFont font : this.fonts) {
            font.connect(null);
        }
        this.orientationConverter.setProperties((DockProperties)null);
        if (this.border != null) {
            this.border.setController(null);
        }
        this.setText("");
        this.setIcon(null);
        this.setTooltip(null);
        this.background.setController(null);
    }

    @Override
    public void setComponentConfiguration(DockComponentConfiguration configuration) {
        this.rootHandler.setConfiguration(configuration);
    }

    @Override
    public DockComponentConfiguration getComponentConfiguration() {
        return this.rootHandler.getConfiguration();
    }

    protected void updateIcon() {
        this.setIcon(this.dockable.getTitleIcon());
    }

    protected void updateText() {
        this.setText(this.dockable.getTitleText());
    }

    protected void updateTooltip() {
        this.setTooltip(this.dockable.getTitleToolTip());
    }

    public boolean isBound() {
        return this.bound;
    }

    protected void updateFonts() {
        if (this.conditionalFonts != null) {
            FontModifier modifier = null;
            for (ConditionalFont font : this.conditionalFonts) {
                if (!font.getState()) continue;
                modifier = (FontModifier)font.value();
                break;
            }
            this.setFontModifier(modifier);
        }
    }

    private class TitleBorder
    implements TitleDockBorder {
        private String id;
        private BorderModifier modifier;
        private DockController controller;
        private Border border;

        public TitleBorder(String id) {
            this.id = id;
        }

        @Override
        public DockTitle getTitle() {
            return AbstractMultiDockTitle.this;
        }

        @Override
        public void set(BorderModifier value) {
            if (value != this.modifier) {
                this.modifier = value;
                this.update();
            }
        }

        public void setBorder(Border border) {
            if (this.border != border) {
                this.border = border;
                this.update();
            }
        }

        private void update() {
            if (this.modifier == null) {
                AbstractMultiDockTitle.this.setBorder(this.border);
            } else {
                AbstractMultiDockTitle.this.setBorder(this.modifier.modify(this.border));
            }
        }

        public void setController(DockController controller) {
            if (this.controller != null) {
                this.controller.getThemeManager().remove(this);
            }
            this.controller = controller;
            if (this.controller == null) {
                this.set(null);
            } else {
                this.controller.getThemeManager().add(this.id, TitleDockBorder.KIND, ThemeManager.BORDER_MODIFIER_TYPE, this);
            }
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements DockTitleBackgroundComponent {
        public Background() {
            super(DockTitleBackgroundComponent.KIND, "dock.background.title");
        }

        @Override
        public DockTitle getTitle() {
            return AbstractMultiDockTitle.this;
        }

        @Override
        public Component getComponent() {
            return this.getTitle().getComponent();
        }
    }

    private class Listener
    implements DockableListener,
    DockHierarchyListener {
        private Listener() {
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            AbstractMultiDockTitle.this.updateIcon();
            AbstractMultiDockTitle.this.updateText();
        }

        @Override
        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            AbstractMultiDockTitle.this.updateIcon();
            AbstractMultiDockTitle.this.updateText();
        }

        @Override
        public void titleToolTipChanged(Dockable dockable, String oldTooltip, String newTooltip) {
            AbstractMultiDockTitle.this.updateTooltip();
        }

        @Override
        public void titleUnbound(Dockable dockable, DockTitle title) {
        }

        @Override
        public void titleBound(Dockable dockable, DockTitle title) {
        }

        @Override
        public void titleExchanged(Dockable dockable, DockTitle title) {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent event) {
            DockController controller = event.getDockable().getController();
            for (AbstractDockColor color : AbstractMultiDockTitle.this.colors) {
                color.connect(controller);
            }
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent event) {
        }
    }

    private class ConditionalFont
    extends TitleFont {
        private Condition condition;

        public ConditionalFont(String id, Path kind, Condition condition, FontModifier backup) {
            super(id, AbstractMultiDockTitle.this, kind, backup);
            this.condition = condition;
        }

        public boolean getState() {
            return this.condition.getState();
        }

        @Override
        protected void changed(FontModifier oldValue, FontModifier newValue) {
            AbstractMultiDockTitle.this.updateFonts();
        }
    }
}

