/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class WindowProviderWrapper
implements WindowProvider {
    private WindowProvider delegate;
    private List<WindowProviderListener> listeners = new ArrayList<WindowProviderListener>();
    private boolean showing = false;
    private WindowProviderListener listener = new WindowProviderListener(){

        @Override
        public void windowChanged(WindowProvider provider, Window window) {
            WindowProviderWrapper.this.fireWindowChanged(window);
        }

        @Override
        public void visibilityChanged(WindowProvider provider, boolean showing) {
            WindowProviderWrapper.this.showing = showing;
            WindowProviderWrapper.this.fireVisibilityChanged(showing);
        }
    };

    @Override
    public void addWindowProviderListener(WindowProviderListener listener) {
        int previous = this.listeners.size();
        this.listeners.add(listener);
        if (previous == 0 && this.listeners.size() > 0 && this.delegate != null) {
            this.delegate.addWindowProviderListener(this.listener);
        }
    }

    @Override
    public void removeWindowProviderListener(WindowProviderListener listener) {
        int previous = this.listeners.size();
        this.listeners.remove(listener);
        if (previous > 0 && this.listeners.size() == 0 && this.delegate != null) {
            this.delegate.removeWindowProviderListener(this.listener);
        }
    }

    protected WindowProviderListener[] listeners() {
        return this.listeners.toArray(new WindowProviderListener[this.listeners.size()]);
    }

    protected void fireWindowChanged(Window window) {
        for (WindowProviderListener listener : this.listeners()) {
            listener.windowChanged(this, window);
        }
    }

    protected void fireVisibilityChanged(boolean showing) {
        for (WindowProviderListener listener : this.listeners()) {
            listener.visibilityChanged(this, showing);
        }
    }

    public void setDelegate(WindowProvider delegate) {
        if (this.listeners.size() == 0) {
            this.delegate = delegate;
        } else {
            Window oldWindow = this.searchWindow();
            boolean oldShowing = this.isShowing();
            if (this.delegate != null) {
                this.delegate.removeWindowProviderListener(this.listener);
            }
            this.delegate = delegate;
            if (this.delegate != null) {
                this.delegate.addWindowProviderListener(this.listener);
            }
            Window newWindow = this.searchWindow();
            boolean newShowing = this.isShowing();
            if (oldWindow != newWindow) {
                this.fireWindowChanged(newWindow);
            }
            if (oldShowing != newShowing || this.showing != newShowing) {
                this.fireVisibilityChanged(newShowing);
                this.showing = newShowing;
            }
        }
    }

    public WindowProvider getDelegate() {
        return this.delegate;
    }

    @Override
    public Window searchWindow() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.searchWindow();
    }

    @Override
    public boolean isShowing() {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.isShowing();
    }
}

