/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PermuteArray {
    private int level = 0;
    private final int[] data;
    private final int[] iter;
    private final int[] valk;
    private final int[] ret;

    public PermuteArray(int N) {
        this.iter = new int[N];
        this.valk = new int[N];
        this.data = new int[N];
        this.ret = new int[N];
        Arrays.fill(this.data, -1);
    }

    public int sgn() {
        int total = 0;
        for (int i = 0; i < this.ret.length; ++i) {
            int val = this.ret[i];
            for (int j = i + 1; j < this.ret.length; ++j) {
                if (val <= this.ret[j]) continue;
                ++total;
            }
        }
        if (total % 2 == 1) {
            return -1;
        }
        return 1;
    }

    public static int fact(int N) {
        int ret = 1;
        while (N > 0) {
            ret *= N--;
        }
        return ret;
    }

    public static List<int[]> createList(int N) {
        int[] data = new int[N];
        Arrays.fill(data, -1);
        ArrayList<int[]> ret = new ArrayList<int[]>();
        PermuteArray.createList(data, 0, -1, ret);
        return ret;
    }

    private static void createList(int[] data, int k, int level, List<int[]> ret) {
        data[k] = level;
        if (level < data.length - 1) {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != -1) continue;
                PermuteArray.createList(data, i, level + 1, ret);
            }
        } else {
            int[] copy = new int[data.length];
            System.arraycopy(data, 0, copy, 0, data.length);
            ret.add(copy);
        }
        data[k] = -1;
    }

    @Nullable
    public int[] next() {
        boolean hasNewPerm = false;
        block0: while (this.level >= 0) {
            int i = this.iter[this.level];
            while (i < this.data.length) {
                int n = this.level++;
                this.iter[n] = this.iter[n] + 1;
                if (this.data[i] == -1) {
                    this.data[i] = this.level - 1;
                    if (this.level >= this.data.length) {
                        hasNewPerm = true;
                        System.arraycopy(this.data, 0, this.ret, 0, this.ret.length);
                        --this.level;
                        this.data[i] = -1;
                        break block0;
                    }
                    this.valk[this.level] = i;
                }
                i = this.iter[this.level];
            }
            this.data[this.valk[this.level]] = -1;
            this.iter[this.level] = 0;
            --this.level;
        }
        if (hasNewPerm) {
            return this.ret;
        }
        return null;
    }
}

