/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.graphic;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.graphic.PolygonGraphic;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;

public class PolygonGraphicCollection
extends GraphicCollection {
    private Array cData;
    private List<Array> data;

    public PolygonGraphicCollection() {
        this(new ArrayList<PolygonGraphic>());
    }

    public PolygonGraphicCollection(List<PolygonGraphic> graphics) {
        this.graphics = graphics;
        this.legend = new PolygonBreak();
    }

    public PolygonGraphicCollection(List<Array> data, PolygonBreak polygonBreak) {
        this.updateGraphics(data, polygonBreak);
    }

    public PolygonGraphicCollection(List<Array> data, List<PolygonBreak> polygonBreaks) {
        this.updateGraphics(data, polygonBreaks);
    }

    public PolygonGraphicCollection(List<Array> data, Array cData, LegendScheme ls) {
        this.legendScheme = ls;
        this.setSingleLegend(false);
        if (cData.getSize() == (long)data.size()) {
            ArrayList<PolygonBreak> polygonBreaks = new ArrayList<PolygonBreak>();
            IndexIterator iterC = cData.getIndexIterator();
            while (iterC.hasNext()) {
                polygonBreaks.add((PolygonBreak)ls.findLegendBreak(iterC.getDoubleNext()));
            }
            this.updateGraphics(data, polygonBreaks);
        } else {
            this.updateGraphics(data, cData, ls);
        }
    }

    public PolygonGraphicCollection(List<Array> data, List<Array> cData, LegendScheme ls) {
        this.legendScheme = ls;
        this.setSingleLegend(false);
        this.updateGraphics(data, cData, ls);
    }

    protected void updateGraphics(List<Array> data, PolygonBreak polygonBreak) {
        this.data = data;
        this.graphics = new ArrayList();
        int[] origin = new int[2];
        int[] shape = new int[2];
        try {
            for (Array array : data) {
                origin = new int[]{0, 0};
                shape = new int[]{array.getShape()[0], 1};
                Array x = array.section(origin, shape);
                origin = new int[]{0, 1};
                Array y = array.section(origin, shape);
                this.add(new PolygonGraphic(x, y, polygonBreak));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateGraphics(List<Array> data, List<PolygonBreak> breaks) {
        this.singleLegend = false;
        this.data = data;
        this.graphics = new ArrayList();
        int[] origin = new int[2];
        int[] shape = new int[2];
        try {
            int i = 0;
            for (Array array : data) {
                origin = new int[]{0, 0};
                shape = new int[]{array.getShape()[0], 1};
                Array x = array.section(origin, shape);
                origin = new int[]{0, 1};
                Array y = array.section(origin, shape);
                if (i >= breaks.size()) {
                    i = 0;
                }
                this.add(new PolygonGraphic(x, y, breaks.get(i)));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateGraphics(List<Array> data, List<Array> cData, LegendScheme ls) {
        this.singleLegend = false;
        this.data = data;
        this.graphics = new ArrayList();
        int[] origin = new int[2];
        int[] shape = new int[2];
        try {
            int i = 0;
            for (Array array : data) {
                origin = new int[]{0, 0};
                shape = new int[]{array.getShape()[0], 1};
                Array x = array.section(origin, shape);
                origin = new int[]{0, 1};
                Array y = array.section(origin, shape);
                this.add(new PolygonGraphic(x, y, cData.get(i), ls));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateGraphics(List<Array> data, Array cData, LegendScheme ls) {
        this.singleLegend = false;
        this.data = data;
        this.cData = cData;
        this.graphics = new ArrayList();
        int[] origin = new int[2];
        int[] shape = new int[2];
        try {
            int i = 0;
            for (Array array : data) {
                origin = new int[]{0, 0};
                shape = new int[]{array.getShape()[0], 1};
                Array x = array.section(origin, shape);
                origin = new int[]{0, 1};
                Array y = array.section(origin, shape);
                origin = new int[]{0, i++};
                Array c = cData.section(origin, shape);
                this.add(new PolygonGraphic(x, y, c, ls));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasColorData() {
        return this.cData != null;
    }

    public List<Array> getData() {
        return this.data;
    }

    public void setData(List<Array> value) {
        if (this.cData != null) {
            this.updateGraphics(value, this.cData, this.legendScheme);
        } else {
            List<PolygonBreak> breaks = this.getLegendBreaks();
            this.updateGraphics(value, breaks);
        }
    }

    public void setData(List<Array> value, Array cData) {
        this.updateGraphics(value, cData, this.legendScheme);
    }

    public List<PolygonBreak> getLegendBreaks() {
        ArrayList<PolygonBreak> breaks = new ArrayList<PolygonBreak>();
        for (PolygonGraphic polygonGraphic : this.getGraphics()) {
            breaks.add((PolygonBreak)polygonGraphic.legend);
        }
        return breaks;
    }
}

